<?php
/**
 * File description for WordPress functionality.
 *
 * @package WordPress
 * @since 3.0.0
 * @uses Mega_Menu_Util
 */

if ( ! class_exists( 'Mega_Menu_Util' ) ) {
	/**
	 * Mega_Menu_Util
	 */
	class Mega_Menu_Util {

		/**
		 * Indicates whether there is no header.
		 *
		 * @var bool
		 */
		private static $is_no_header = false;

		/**
		 * Indicates whether it is a template header.
		 *
		 * @var bool
		 */
		private static $is_template_header = false;

		/**
		 * Indicates whether it is a template header.
		 *
		 * @var bool
		 */
		private static $header_template_id = null;

		/**
		 * Indicates whether it is a template header.
		 *
		 * @var array
		 */
		private static $header_template_content = array(
			'tdc_header_mobile',
			'tdc_header_mobile_sticky',
			'tdc_header_desktop',
			'tdc_header_desktop_sticky',
		);

		/**
		 * Indicates whether it is a template header.
		 *
		 * @var string
		 */
		private static $authors_array_cache = ''; /** Cache the results from  create_array_authors */

		/**
		 * Indicates whether it is a template header.
		 *
		 * @var null
		 */
		private static $shortcodes_with_icons = null; /** Shortcodes with icon type params */

		/**
		 * Indicates whether it is a template header.
		 *
		 * @var bool
		 */
		private static $check_installed_plugins = false;

		/**
		 * Indicates whether it is a template header.
		 *
		 * @var array
		 */
		public static $e_keys = array(
			'dGRfMDEx'        => '',
			'dGRfMDExXw === ' => 2,
		);

		/**
		 *
		 * Generates a category tree, only on /wp_admin/, uses a buffer
		 *
		 * @var bool $add_all_category = if true ads - All categories - at the begining of the list ( used for dropdowns )
		 * @return array
		 */
		private static $category_to_id_array_walker_buffer = array();

		/**
		 * Get an array that maps category names to their IDs.
		 *
		 * This method retrieves a list of categories and their corresponding IDs from the WordPress database.
		 *
		 * @param bool $add_all_category Whether to add an option for "All categories" at the beginning of the list.
		 * @return array An associative array mapping category names to their IDs.
		 */
		public static function get_category_to_id_array( $add_all_category = true ) {
			if ( is_admin() === false ) {
				return array();
			}

			if ( empty( self::$category_to_id_array_walker_buffer ) ) {
				$categories = get_categories(
					array(
						'hide_empty' => 0,
					)
				);

				$category_to_id_array_walker = new Category_To_Id_Array_Walker();
				$category_to_id_array_walker->walk( $categories, 4 );
				self::$category_to_id_array_walker_buffer = $category_to_id_array_walker->array_buffer;
			}

			if ( true === $add_all_category ) {
				$categories_buffer['- All categories -'] = '';
				return array_merge(
					$categories_buffer,
					self::$category_to_id_array_walker_buffer
				);
			} else {
				return self::$category_to_id_array_walker_buffer;
			}
		}
	}
}
