<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$post_id_w3      = get_the_ID();
$categories      = get_the_category( $post_id_w3 );
$related_post_on = w3construct_get_opt( 'related_post_on', false );
if ( $categories ) {

	$category_ids = array();

	foreach ( $categories as $individual_category ) {
		$category_ids[] = $individual_category->term_id;
	}

	$args               = array(
		'category__in'        => $category_ids,
		'post__not_in'        => array( $post_id_w3 ),
		'posts_per_page'      => 2,
		'ignore_sticky_posts' => 1,
		'orderby'             => 'rand',
	);
	$args['meta_query'] = array(
		array(
			'key'     => '_thumbnail_id',
			'compare' => 'EXISTS',
		),
	);

	$related_query = new wp_query( $args );
	if ( $related_query->have_posts() ) {

		if ( $related_post_on ) {
			?>
			<div class="row extra-blog style-1">
				<div class="widget-title">
					<h4 class="title">
						<?php echo esc_html__( 'Related Blogs', 'w3construct' ); ?>
					</h4>
					<div class="dz-separator style-1 text-primary mb-0"></div>
				</div>
				<?php
				$count = 1;
				while ( $related_query->have_posts() ) {
					$related_query->the_post();
					$post_title     = ( has_post_thumbnail() ) ? w3construct_trim( get_the_title(), 3 ) : get_the_title();
					$post_desc      = ( has_post_thumbnail() ) ? w3construct_trim( get_the_content(), 22 ) : get_the_content();
					$author_name    = get_the_author_meta( 'display_name', $post->post_author );
					$no_image_class = '';
					$class          = ( 1 === $count ) ? 'm-sm-b30' : '';
					if ( ! has_post_thumbnail() ) {
						$no_image_class = 'no-image-box';
					}
					?>
					<div class="col-lg-6 col-md-6">
						<div class="dz-card blog-grid style-1 <?php echo esc_attr( $class ); ?>">
							<?php if ( has_post_thumbnail() ) { ?>
								<div class="dz-media <?php echo esc_attr( $no_image_class ); ?>">
									<?php the_post_thumbnail( 'w3construct_555x400' ); ?>
								</div>
							<?php } ?>
							<div class="dz-info">
								<div class="dz-meta">
									<ul>
										<li class="post-date">
											<?php echo esc_html( get_the_date() ); ?>
										</li>
										<li class="post-user">
											<?php esc_html_e( 'By', 'w3construct' ); ?> <a
												href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
												<?php echo esc_html( $author_name ); ?>
											</a>
										</li>
									</ul>
								</div>
								<h5 class="dz-title">
									<a href="<?php echo esc_url( get_permalink() ); ?>">
										<?php echo esc_html( $post_title ); ?>
									</a>
								</h5>
								<div class="dz-post-text text">
									<p>
										<?php echo esc_html( $post_desc ); ?>
									</p>
								</div>
								<a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-link">
									<?php echo esc_html__( 'Read More', 'w3construct' ); ?>
								</a>

							</div>
						</div>
					</div>
					<?php
					++$count;
				}
				?>
			</div>
			<?php
		}
	}
}
wp_reset_postdata();


