<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

global $w3construct_option;

$theme_options   = w3construct_get_theme_option();
$category_on     = w3construct_set( $theme_options, 'category_on', true );
$date_on         = w3construct_set( $theme_options, 'date_on', true );
$social_shaing   = w3construct_set( $theme_options, 'social_shaing_on_post' );
$featured_img_on = w3construct_set( $theme_options, 'featured_img_on', true );

$page_options        = w3construct_dzbase()->get_meta();
$post_show_sidebar   = w3construct_dzbase()->get_meta( 'post_show_sidebar' );
$post_sidebar_layout = w3construct_dzbase()->get_meta( 'post_sidebar_layout' );
$post_sidebar        = w3construct_dzbase()->get_meta( 'post_sidebar' );
$featured_image      = ( isset( $page_options['featured_image'] ) ) ? w3construct_dzbase()->get_meta( 'featured_image' ) : true;
$views_arr           = get_post_meta( get_the_id(), '_views_count' );
$views               = ( isset( $views_arr[0] ) ) ? $views_arr[0] : 0;

if ( ! $post_show_sidebar || empty( $post_sidebar ) || ! is_active_sidebar( $post_sidebar ) || 'full' === $post_sidebar_layout || ! w3construct_is_theme_sidebar_active() ) {
	$is_sidebar   = false;
	$classes      = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12';
	$blog_classes = 'dz-card blog-single style-1 ';
} else {
	$is_sidebar   = true;
	$classes      = 'col-xl-8 col-lg-8';
	$blog_classes = 'dz-card blog-single style-1 sidebar';
}

?>
<!-- Blog Large -->
<div class="content-inner bg-img-fix">
	<div class="<?php echo esc_attr( w3construct_get_container( $is_sidebar ) ); ?>">
		<div class="row">
			<?php if ( 'left' === $post_sidebar_layout && $is_sidebar ) { ?>
				<!-- Side bar start -->
				<div class="col-xl-4 col-lg-4 m-b30 dz-order-1">
					<aside class="side-bar sticky-top left">
						<?php dynamic_sidebar( $post_sidebar ); ?>
					</aside>
				</div>
				<!-- Side bar END -->
			<?php } ?>
			<div class="<?php echo esc_attr( $classes ); ?>">
				<?php
				while ( have_posts() ) {
					the_post();
					?>
					<div class="<?php echo esc_attr( $blog_classes ); ?>">
						<div class="dz-info">
							<div class="dz-meta">
								<ul>
									<?php if ( ! empty( $date_on ) ) { ?>
										<li class="post-date">
											<?php echo the_date(); ?>
										</li>
									<?php } ?>

									<li class="post-user">
										<?php esc_html_e( 'By', 'w3construct' ); ?>
										<a
											href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
											<?php the_author(); ?>
										</a>
									</li>

									<?php echo wp_kses( w3construct_show_post_view_count_view( $views ), w3construct_allowed_html_tag() ); ?>
									<?php if ( $category_on ) { ?>
										<li class="post-category">
											<?php echo wp_kses( get_the_category_list( ', ' ), w3construct_allowed_html_tag() ); ?>
										</li>
									<?php } ?>
								</ul>
							</div>
							<?php if ( ! w3construct_is_post_banner_enable() ) { ?>
								<h1 class="dz-title">
									<?php the_title(); ?>
								</h1>
							<?php } ?>
						</div>

						<?php if ( $featured_image && $featured_img_on && has_post_thumbnail() ) { ?>
							<div class="dz-media">
								<?php the_post_thumbnail( 'large' ); ?>
							</div>
						<?php } ?>


						<div class="dz-info">
							<div class="dz-post-text">
								<?php the_content(); ?>
							</div>
							<?php if ( has_tag() || $social_shaing ) { ?>
								<div class="post-footer">
									<?php if ( has_tag() ) { ?>
										<div class="post-tags">
											<?php w3construct_get_post_tags( get_the_id() ); ?>
										</div>
									<?php } ?>
									<?php echo wp_kses( w3construct_share_us( get_the_id(), get_the_title() ), w3construct_allowed_html_tag() ); ?>
								</div>
								<?php
							}
							?>
						</div>
					</div>
					<!-- blog start -->
					<?php
				}

				/* Get Author Block */
				get_template_part( 'dz-inc/elements/authors-block-element' );

				/* Get Pagination Element */
				get_template_part( 'dz-inc/elements/pagination-element' );

				/* Get Paginate Links */
				wp_link_pages(
					array(
						'before'      => '<div class="paginate-links">' . esc_html__( 'Pages: ', 'w3construct' ),
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
					)
				);

				/* Get Related Post Block */
				get_template_part( 'dz-inc/elements/related-element' );

				/* Get Comment Template */
				comments_template();
				?>
			</div>

			<?php if ( 'right' === $post_sidebar_layout && $is_sidebar ) { ?>
				<!-- Side bar start -->
				<div class="col-xl-4 col-lg-4 m-b30 dz-order-1">
					<aside class="side-bar sticky-top right">
						<?php dynamic_sidebar( $post_sidebar ); ?>
					</aside>
				</div>
				<!-- Side bar END -->
			<?php } ?>
		</div>
	</div>
</div>
