<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

?>

<div class="loadmore-content" id='masonry1'>
<?php
$w3construct_query_result = array();
$page_view                = 'latest_post';
$page_no                  = 1;
$no_of_posts_per_page     = get_option( 'posts_per_page' );

$query_args = array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => $no_of_posts_per_page,
	'paged'               => $page_no,
	'ignore_sticky_posts' => false,
	'orderby'             => 'post_date',
	'order'               => 'DESC',
);

$query_w3      = new WP_Query( $query_args );
$max_num_pages = $query_w3->max_num_pages;

set_query_var( 'w3construct_query_result', $query_w3 );

get_template_part( 'dz-inc/ajax/index-ajax' );
?>
</div>
<?php if ( 1 < $max_num_pages ) { ?>
	<div class="row">
		<div class="col-lg-12 m-t10">
			<div class="text-center m-b30">
				<a href="javascript:void(0);"
					class="btn shadow-primary btn-primary btn-rounded btn-ov-secondary dz-load-more loadmore-btn latest-post-dz-load-more "
					data-posts-per-page="<?php echo esc_js( $no_of_posts_per_page ); ?>"
					data-max-num-pages="<?php echo esc_js( $max_num_pages ); ?>">
					<?php echo esc_html__( 'Load More', 'w3construct' ); ?> <i class="fa fa-refresh fas fa-spinner fa-spin"></i>
				</a>
			</div>
		</div>
	</div>
	<?php
}
wp_reset_postdata();
