<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

global $w3construct_option;

$site_phone_icon    = w3construct_get_opt( 'site_phone_icon' );
$site_email_icon    = w3construct_get_opt( 'site_email_icon' );
$site_address_icon  = w3construct_get_opt( 'site_address_icon' );
$site_phone_title   = w3construct_get_opt( 'site_phone_title' );
$site_address_title = w3construct_get_opt( 'site_address_title' );
$site_email_title   = w3construct_get_opt( 'site_email_title' );
$header_about_title = ! empty( $w3construct_option['header_about_title'] ) ? $w3construct_option['header_about_title'] : '';
$header_about_on    = ! empty( $w3construct_option['header_about_on'] ) ? $w3construct_option['header_about_on'] : '';
$header_about_desc  = ! empty( $w3construct_option['header_about_desc'] ) ? $w3construct_option['header_about_desc'] : '';
$allowed_html_tags  = ! empty( $w3construct_option['allowed_html_tags'] ) ? $w3construct_option['allowed_html_tags'] : '';
$header_about_url   = ! empty( $w3construct_option['header_about_url'] ) ? $w3construct_option['header_about_url'] : '';
$site_phone_number  = ! empty( $w3construct_option['site_phone_number'] ) ? $w3construct_option['site_phone_number'] : '';
$site_address       = ! empty( $w3construct_option['site_address'] ) ? $w3construct_option['site_address'] : '';
$site_email         = ! empty( $w3construct_option['site_email'] ) ? $w3construct_option['site_email'] : '';


if ( $header_about_on ) {
	?>

<div class="contact-sidebar">
	<div class="contact-box">
		<div class="logo-contact">
			<?php
				do_action( 'w3construct_get_logo', 'site_logo' );
			?>
		</div>
		<div class="m-b50 contact-text">
			<div class="dz-title">
				<h4>
					<?php echo wp_kses( $header_about_title, 'string' ); ?>
				</h4>
				<div class="dz-separator style-1 text-primary mb-0"></div>
			</div>
			<p>
				<?php echo wp_kses( $header_about_desc, $allowed_html_tags ); ?>
			</p>
			<a href="<?php echo esc_url( $header_about_url ); ?>" class="btn btn-primary btn-sm"><?php echo esc_html__( 'READ MORE', 'w3construct' ); ?></a>
		</div>
		<div class="dz-title">
			<h4>
				<?php echo esc_html__( 'Contact Info', 'w3construct' ); ?>
			</h4>
			<div class="dz-separator style-1 text-primary mb-0"></div>
		</div>
		<?php if ( ! empty( $site_phone_number ) ) { ?>
			<div class="icon-bx-wraper left">
				<?php if ( ! empty( $site_phone_icon ) ) { ?>
					<div class="icon-md m-r20">
						<span class="icon-cell">
							<i class="<?php echo esc_attr( $site_phone_icon ); ?>"></i>
						</span>
					</div>
				<?php } ?>
				<div class="icon-content">
					<?php if ( ! empty( $site_phone_title ) ) { ?>
						<h5 class="tilte">
							<?php echo esc_html( $site_phone_title ); ?>
						</h5>
					<?php } ?>

					<p class="m-b0">
						<?php echo wp_kses( $site_phone_number, $allowed_html_tags ); ?>
					</p>
				</div>
			</div>
		<?php } ?>

		<?php if ( ! empty( $site_address ) ) { ?>
			<div class="icon-bx-wraper left">
				<?php if ( ! empty( $site_address_icon ) ) { ?>
					<div class="icon-md m-r20">
						<span class="icon-cell">
							<i class="<?php echo esc_attr( $site_address_icon ); ?>"></i>
						</span>
					</div>
				<?php } ?>

				<div class="icon-content">
					<?php if ( ! empty( $site_address_title ) ) { ?>
						<h5 class="tilte">
							<?php echo esc_html( $site_address_title ); ?>
						</h5>
					<?php } ?>

					<p class="m-b0">
						<?php echo wp_kses( $site_address, $allowed_html_tags ); ?>
					</p>
				</div>
			</div>
		<?php } ?>

		<?php if ( ! empty( $site_email ) ) { ?>
		<div class="icon-bx-wraper left">
			<?php if ( ! empty( $site_email_icon ) ) { ?>
				<div class="icon-md m-r20">
					<span class="icon-cell">
						<i class="<?php echo esc_attr( $site_email_icon ); ?>"></i>
					</span>
				</div>
			<?php } ?>
			<div class="icon-content">
				<?php if ( ! empty( $site_email_title ) ) { ?>
					<h5 class="tilte">
						<?php echo esc_html( $site_email_title ); ?>
					</h5>
				<?php } ?>
				<p class="m-b0">
					<?php echo wp_kses( $site_email, $allowed_html_tags ); ?>
				</p>
			</div>
		</div>
		<?php } ?>
	</div>
</div>
<div class="menu-close"></div>
	<?php
}
