<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

global $w3construct_option;

$header_sticky_class       = w3construct_set( $w3construct_option, 'header_sticky_class' );
$header_search_on          = w3construct_set( $w3construct_option, 'header_search_on' );
$site_phone_number         = w3construct_set( $w3construct_option, 'site_phone_number' );
$header_about_on           = w3construct_set( $w3construct_option, 'header_about_on' );
$show_login_registration   = w3construct_set( $w3construct_option, 'show_login_registration' );
$header_social_link_on     = w3construct_set( $w3construct_option, 'header_social_link_on' );
$show_social_icon          = w3construct_set( $w3construct_option, 'show_social_icon' );
$allowed_html_tags         = w3construct_set( $w3construct_option, 'allowed_html_tags' );
$header_register_on        = w3construct_set( $w3construct_option, 'header_register_on' );
$mobile_header_login_on    = w3construct_set( $w3construct_option, 'mobile_header_login_on' );
$mobile_header_register_on = w3construct_set( $w3construct_option, 'mobile_header_register_on' );
?>
<!-- Header -->
	<header class="site-header mo-left header style-2 onepage">
		<!-- Main Header -->
		<div class="<?php echo esc_attr( $header_sticky_class ); ?> main-bar-wraper navbar-expand-lg">
			<div class="main-bar clearfix ">
				<div class="container-fluid clearfix d-lg-flex d-block">

					<?php if ( $header_about_on ) { ?>
						<div class="sidebar-menu">
							<button type="button" class="menu-btn navicon">
								<span></span>
								<span></span>
								<span></span>
							</button>
						</div>
					<?php } ?>

					<!-- Website Logo -->
					<div class="logo-header mostion logo-dark">
						<?php do_action( 'w3construct_get_logo', 'site_logo' ); ?>
					</div>

					<!-- Nav Toggle Button -->
					<button id="NavigationToggle" class="navbar-toggler collapsed navicon justify-content-end" type="button"
					data-bs-toggle="collapse" data-bs-target="#navbarNavDropdown" aria-controls="navbarNavDropdown"
					aria-expanded="false" aria-label="Toggle navigation">
						<span></span>
						<span></span>
						<span></span>
					</button>

					<div class="header-nav navbar-collapse collapse justify-content-end" id="navbarNavDropdown">
						<div class="logo-header">
							<?php do_action( 'w3construct_get_logo', 'site_logo' ); ?>
						</div>
						<?php

						if ( ! empty( $w3construct_option['scroll_menu_pages'] ) && in_array( w3construct_get_current_page_id(), $w3construct_option['scroll_menu_pages'], true ) ) {
							$theme_location = 'one_page_menu';
							$menu_class     = 'navbar-nav-scroll';
						} else {
							$theme_location = 'main_menu';
							$menu_class     = '';
						}
						if ( function_exists( 'max_mega_menu_is_enabled' ) && max_mega_menu_is_enabled( $theme_location ) ) {
							wp_nav_menu(
								array(
									'theme_location'  => $theme_location,
									'container_id'    => 'navbar-collapse-1',
									'container_class' => '',
									'menu_class'      => 'nav navbar-nav',
									'fallback_cb'     => false,
									'items_wrap'      => '%3$s',
									'container'       => false,
									'depth'           => '3',
									'walker'          => new Bootstrap_walker(),
								)
							);
						} else {
							?>
						<ul id="MobileMenuBlock" class="nav navbar-nav navbar navbar-left <?php echo esc_attr( $menu_class ); ?>">
							<?php
							wp_nav_menu(
								array(
									'theme_location'  => $theme_location,
									'container_id'    => 'navbar-collapse-1',
									'container_class' => '',
									'menu_class'      => 'nav navbar-nav',
									'fallback_cb'     => false,
									'items_wrap'      => '%3$s',
									'container'       => false,
									'depth'           => '3',
									'walker'          => new Bootstrap_walker(),
								)
							);
							?>
						</ul>
						<?php } ?>
						<div class="sidebar-footer">
						<?php
						if ( ! is_user_logged_in() && get_option( 'users_can_register' ) && $show_login_registration ) {
							?>
							<div class="dz-login-register">
							<?php
							if ( $mobile_header_login_on ) {
								?>
									<a class="dz-login-btn btn btn-primary btn-sm" href="<?php echo esc_url( wp_login_url() ); ?>"><?php echo esc_html__( 'Sign In', 'w3construct' ); ?></a>
								<?php } ?>
								<?php if ( $mobile_header_register_on ) { ?>
									<a class="dz-register-btn btn btn-primary btn-sm" href="<?php echo esc_url( home_url( '/wp-login.php?action=register' ) ); ?>"><?php echo esc_html__( 'Sign Up', 'w3construct' ); ?></a>
								<?php } ?>
							</div>
							<?php } ?>
							<?php if ( $header_social_link_on && $show_social_icon ) { ?>
								<div class="dz-social-icon">
									<ul class="dz-social-link">
										<?php echo wp_kses( w3construct_get_social_icons( 'header' ), $allowed_html_tags ); ?>
									</ul>
								</div>
							<?php } ?>
						</div>

					</div>

					<!-- Extra Nav -->
					<div class="extra-nav">
						<div class="extra-cell">
							<?php if ( $header_social_link_on && $show_social_icon ) { ?>
								<ul class="social-list style-2">
									<?php echo wp_kses( w3construct_get_social_icons( 'header' ), $allowed_html_tags ); ?>
								</ul>
							<?php } ?>
						</div>
					</div>

				</div>
			</div>
		</div>
		<!-- Main Header End -->
	</header>
	<!-- Header End -->
	<?php
	get_template_part( 'dz-inc/elements/header/header-sidebar' );
