<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

global $w3construct_option;

$footer_copyright_text = w3construct_set( $w3construct_option, 'footer_copyright_text' );
$allowed_html_tags     = w3construct_set( $w3construct_option, 'allowed_html_tags' );
$class                 = ! empty( has_nav_menu( 'footer_menu' ) ) ? 'col-lg-6' : 'd-flex justify-content-center';
?>
<!-- Footer -->
<footer class="site-footer style-3 overflow-hidden" id="footer">
	<?php if ( is_active_sidebar( 'dz_footer_sidebar' ) ) { ?> 
		<div class="footer-top">
			<div class="container">
				<div class="row">
					<?php dynamic_sidebar( 'dz_footer_sidebar' ); ?>
				</div>
			</div>
		</div>
	<?php } ?>
	<?php if ( ! empty( $footer_copyright_text ) ) { ?>
		<!-- Footer Bottom -->
		<div class="footer-bottom">
			<div class="container">
				<div class="row align-items-center">
					<?php if ( has_nav_menu( 'footer_menu' ) ) { ?>
					<div class="col-lg-6 text-lg-start">
						<ul class="footer-link d-inline-block">
							<?php
							wp_nav_menu(
								array(
									'theme_location'  => 'footer_menu',
									'container_id'    => 'navbar-collapse-1',
									'container_class' => '',
									'menu_class'      => 'nav navbar-nav',
									'fallback_cb'     => false,
									'items_wrap'      => '%3$s',
									'container'       => false,
									'depth'           => '3',
									'walker'          => new Bootstrap_walker(),
								)
							);
							?>
						</ul>
					</div>
					<?php } ?>
					<div class="<?php echo esc_attr( $class ); ?> text-lg-end">
						<span class="copyright-text"><?php echo wp_kses( $footer_copyright_text, $allowed_html_tags ); ?></span>
					</div>			
				</div>
			</div>
		</div>
	<?php } ?>
</footer>
