<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

global $w3construct_option;

$footer_bg_image       = w3construct_set( $w3construct_option, 'footer_bg_image' );
$show_social_icon      = w3construct_set( $w3construct_option, 'show_social_icon' );
$footer_copyright_text = w3construct_set( $w3construct_option, 'footer_copyright_text' );
$allowed_html_tags     = w3construct_set( $w3construct_option, 'allowed_html_tags' );

?>
<!-- Footer -->
<footer class="site-footer style-1" id="footer" <?php if ( ! empty( $footer_bg_image['url'] ) ) { ?>
		style="background-image:url(<?php echo esc_url( $footer_bg_image['url'] ); ?>)" <?php } ?>>
	<div class="footer-top">
		<div class="container">

			<?php if ( is_active_sidebar( 'dz_footer_sidebar' ) ) { ?>
				<div class="row widget-area">
					<?php dynamic_sidebar( 'dz_footer_sidebar' ); ?>
				</div>
			<?php } ?>
		</div>
	</div>
	<!-- Footer Bottom -->
	<div class="footer-bottom">
		<div class="container">
			<div class="row align-items-center fb-inner spno">
				<?php if ( ! empty( $footer_copyright_text ) ) { ?>
					<div class="col-lg-12 col-md-12 text-center">
						<span class="copyright-text">
							<?php echo wp_kses( $footer_copyright_text, $allowed_html_tags ); ?>
						</span>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</footer>
<!-- Footer End -->
