<div class="loadmore-content" id='masonry'>
<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$w3construct_query_result = array();
$page_view                = 'archive';
$page_no                  = 1;
$no_of_posts_per_page     = get_option( 'posts_per_page' );
/* Post Sorting */
$sorting_on = w3construct_get_opt( 'archive_page_sorting_on' );
$orderby_w3 = '';
$order_w3   = '';
if ( $sorting_on ) {
	$sorting = w3construct_get_opt( 'archive_page_sorting' );
	if ( 'most_visited' === $sorting ) {
		$query_args['meta_key'] = '_views_count';
		$order_w3               = 'DESC';
		$orderby_w3             = '_views_count';
	} else {
		$sort_arr   = explode( '_', $sorting );
		$orderby_w3 = ! empty( $sort_arr[0] ) ? $sort_arr[0] : '';
		$order_w3   = ! empty( $sort_arr[1] ) ? $sort_arr[1] : '';
	}
} else {
	$orderby_w3 = 'date';
	$order_w3   = 'DESC';
}

if ( ! empty( $orderby_w3 ) && '_views_count' !== $orderby_w3 ) {
	$query_args['orderby'] = $orderby_w3;
}
$query_args['order'] = $order_w3;
/* Post Sorting END */

/* Get Post Type */
if ( get_post_type() ) {
	$post_type_w3 = get_post_type();
} else {
	$post_type_w3 = 'post';
}

/* Post Query args  */
$query_args = array(
	'post_type'           => $post_type_w3,
	'post_status'         => 'publish',
	'posts_per_page'      => $no_of_posts_per_page,
	'paged'               => $page_no,
	'ignore_sticky_posts' => true,
	'orderby'             => $orderby_w3,
	'order'               => $order_w3,
	'year'                => $queried_object_data->query_vars['year'],
);
/*Add Tax Query for category, tag, service, portfolio */
$taxonomy_w3 = get_query_var( 'taxonomy' );
$term_w3     = get_query_var( 'term' );
if ( ! empty( $taxonomy_w3 ) && ! empty( $term_w3 ) ) {
	$query_args['tax_query'][] = array(
		'taxonomy' => $taxonomy_w3,
		'field'    => 'slug',
		'terms'    => $term_w3,
		'operator' => 'IN',
	);
}

if ( ! empty( $queried_object_data->query_vars['monthnum'] ) ) {
	$query_args['monthnum'] = $queried_object_data->query_vars['monthnum'];
}

$query_w3 = new WP_Query( $query_args );

$max_num_pages = $query_w3->max_num_pages;

set_query_var( 'w3construct_query_result', $query_w3 );

get_template_part( 'dz-inc/ajax/archives-ajax' ); ?>
</div>
<?php if ( 1 < $max_num_pages ) { ?>
	<!-- Pagination start -->
<div class="reload-btn text-center mb-4">
	<a href="javascript:void(0);"
		class="btn shadow-primary btn-primary btn-rounded btn-ov-secondary loadmore-btn common-page-dz-load-more dz-load-more"
		data-common-page-view="<?php echo esc_js( $page_view ); ?>"
		data-posts-per-page="<?php echo esc_js( $no_of_posts_per_page ); ?>"
		data-max-num-pages="<?php echo esc_js( $max_num_pages ); ?>" data-orderby="<?php echo esc_js( $orderby_w3 ); ?>"
		data-order="<?php echo esc_js( $order_w3 ); ?>">
		<?php echo esc_html__( 'Load More', 'w3construct' ); ?> <i class="fa fa-refresh fas fa-spinner fa-spin"></i>
	</a>
</div>
<!-- Pagination End -->
	<?php
}
wp_reset_postdata();
