<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

?>

<div class="about-video-box">
	<?php
	if ( ! empty( $video_section_1_element_video_image['id'] ) ) {
		$image_url = $video_section_1_element_video_image['url'];
		?>
		<div class="video-bx content-media style-1">
			<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
			<div class="video-btn aos-item" data-aos-duration="1500" data-aos-delay="200">
				<a href="<?php echo esc_url( $video_section_1_element_youtube_url ); ?>" class="popup-youtube"><i
						class="fa fa-play"></i></a>
			</div>
		</div>
	<?php } ?>

	<?php
	if ( ! empty( $video_section_1_partners_element_image ) ) {
		$item_arr = $video_section_1_partners_element_image;
		?>
		<div class="container">
			<div class="swiper-container clients-swiper ">
				<div class="swiper-wrapper">
					<?php
					foreach ( $item_arr as $item_value ) {
						if ( ! empty( $item_value['id'] ) ) {

							?>
							<div class="swiper-slide">
								<div class="clients-logo aos-item" data-aos-duration="1000" data-aos-delay="100">
									<img class="logo-main" src="<?php echo esc_url( $item_value['url'] ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
								</div>
							</div>
							<?php
						}
					}
					?>
				</div>
			</div>
		</div>
	<?php } ?>
</div>
