<?php
	$query_args = array(
	'post_type' => 'dz_testimonial',
	'post_status' => 'publish',
	'posts_per_page'   	=> $testimonial_slider_1_element_no_of_posts ,	
	'orderby'=>$testimonial_slider_1_element_orderby,
	'order'=>$testimonial_slider_1_element_order,
	'ignore_sticky_posts' => true,
	);
	
	
	$testimonial_slider_1_element_image_preference = !empty($testimonial_slider_1_element_image_preference)?$testimonial_slider_1_element_image_preference:'all_posts';
	
	if($testimonial_slider_1_element_image_preference == 'image_post_only')
	{
		$query_args['meta_query'] = array(
			array(
			 'key' => '_thumbnail_id',
			 'compare' => 'EXISTS'
			),
		);
	}
	elseif($testimonial_slider_1_element_image_preference == 'text_post_only')
	{
		$query_args['meta_query'] = array(
			array(
			 'key' => '_thumbnail_id',
			 'compare' => 'Not EXISTS'
			),
		);
	}
	
	if($testimonial_slider_1_element_only_featured_posts == 'yes') 
	{ 		
		$query_args['meta_key'] = 'featured_post';		
		$query_args['meta_value'] = 1;				
		$query_args['meta_compare'] = 'LIKE';		
	}
	
	if(!empty($testimonial_slider_1_element_posts_in_categories) && !empty($testimonial_slider_1_element_posts_in_categories[0])){		
		
		$testimonial_slider_1_element_posts_in_categories1 = w3construct_get_cat_id_by_slug($testimonial_slider_1_element_posts_in_categories,'testimonial_category');
		
		$query_args['tax_query'][] = array(
		'taxonomy' => 'testimonial_category',
		'field' => 'id',
		'terms' => $testimonial_slider_1_element_posts_in_categories1,
		'operator' => 'IN'
		); 
	}
	
	$query_w3 = new WP_Query($query_args);
	
	
	if(!empty($query_w3->have_posts())){
	?>	
	<!-- Testimonials -->
<section class="content-inner bg-gray section-title style-1 line-img" >
	
	<div class="container">
		<div class="row section-head-bx align-items-center">
				<div class="col-md-8">
					<?php if(!empty($testimonial_slider_1_element_title)){ ?>
						<div class="section-head style-1">
							<h2 class="title">
								<?php echo wp_kses($testimonial_slider_1_element_title,w3construct_allowed_html_tag()); ?>
							</h2>
							<div class="dz-separator style-1 text-primary"></div>
							<?php if(!empty($testimonial_slider_1_element_description)){ ?>
								<p>
									<?php echo wp_kses($testimonial_slider_1_element_description,'string'); ?>
								</p>
							<?php } ?>
						</div>
					<?php } ?>
				</div>
			<div class="col-md-4 text-end d-none d-md-block">
				<div class="testimonial-swiper-2 m-b30">
					<!-- Add Navigation -->
					<div class="btn-prev swiper-button-prev3 pe-3"><i class="las la-long-arrow-alt-left"></i></div>
					<div class="btn-next swiper-button-next3 ps-3"><i class="las la-long-arrow-alt-right"></i></div>
				</div>
			</div>
		</div>
	</div>
	<div class="container">
		<div class="row">
			<div class="col-lg-12 m-b20">
				<div class="swiper-container testimonial-swiper-2">
					<div class="swiper-wrapper">
						<?php 
							$count=1;
							$animate_time = 0;
							while($query_w3->have_posts())
							{ 
								global $post;
								$query_w3->the_post();					
								$designation = w3construct_get_post_meta(get_the_id(),'testimonial_designation');
								$rating = w3construct_get_post_meta(get_the_id(),'testimonial_rating');
								$content_text_limit = $testimonial_slider_1_element_text_limit;
								$short_description = w3construct_short_description(get_the_excerpt(), get_the_content(), $content_text_limit);
								
						?>
							<div class="swiper-slide">
								<div class="testimonial-2 aos-item">
									<div class="testimonial-info m-b20">
										<div class="testimonial-text">
											<?php if(!empty($rating)){ ?>
												<ul class="star-rating text-primary m-b15">
													<?php 
														$star_count = $rating;
														for($star=1;$star<=5;$star++){ 
															 if($star<=$star_count){
															echo "<li><i class='fas fa-star'></i></li>";
														  }
														  else{
															  echo "<li><i class='far fa-star'></i></li>";
														  }
														}		
													?>
												</ul>
											<?php } ?>
											
											<p>
												<?php echo esc_html($short_description); ?>
											</p>
										</div>
									</div>
									<div class="testimonial-detail">
										<?php if(has_post_thumbnail()) { ?>
											<div class="testimonial-pic m-r20">
												<img src="<?php echo esc_url( get_the_post_thumbnail_url( $post ) ); ?>" alt="<?php echo esc_attr( get_the_title( get_the_id() ) ); ?>" >
											</div>	
										<?php } ?>
										
										<div>
											<h5 class="testimonial-name">
												<?php echo esc_html( get_the_title( get_the_id() ) );?>
											</h5> 
											<span class="testimonial-position text-primary">
												<?php echo esc_html( $designation ); ?>
											</span> 
										</div>
									</div>
								</div>
							</div>
						<?php $count++; } ?>	
					</div>
					<div class="swiper-pagination"></div>
				</div>
			</div>
		</div>
	</div>
</section>
<?php } ?>
