<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

	$blog_view    = 'team_listing_1';
	$page_no      = 1;
	$post_type_w3 = 'dz_team';

	$query_args = array(
		'post_type'           => $post_type_w3,
		'post_status'         => 'publish',
		'posts_per_page'      => $team_listing_1_element_no_of_posts,
		'order'               => $team_listing_1_element_order,
		'ignore_sticky_posts' => true,
	);

	if ( 'views_count' === $team_listing_1_element_orderby ) {
		$query_args['meta_key'] = '_views_count';
	} else {
		$query_args['orderby'] = $team_listing_1_element_orderby;
	}

	$team_listing_1_element_image_preference = ! empty( $team_listing_1_element_image_preference ) ? $team_listing_1_element_image_preference : 'all_posts';

	if ( 'image_post_only' === $team_listing_1_element_image_preference ) {
		$query_args['meta_query'] = array(
			array(
				'key'     => '_thumbnail_id',
				'compare' => 'EXISTS',
			),
		);
	} elseif ( 'text_post_only' === $team_listing_1_element_image_preference ) {
		$query_args['meta_query'] = array(
			array(
				'key'     => '_thumbnail_id',
				'compare' => 'Not EXISTS',
			),
		);
	}


	if ( ! empty( $team_listing_1_element_posts_in_categories ) && ! empty( $team_listing_1_element_posts_in_categories[0] ) ) {


		$query_args['tax_query'][]                  = array(
			'taxonomy' => 'team_category',
			'field'    => 'slug',
			'terms'    => $team_listing_1_element_posts_in_categories,
			'operator' => 'IN',
		);
		$team_listing_1_element_posts_in_categories = implode( ', ', $team_listing_1_element_posts_in_categories );
	} else {
		$team_listing_1_element_posts_in_categories = '';
	}

	if ( 'yes' === $team_listing_1_element_only_featured_posts ) {
		$query_args['meta_key']     = 'featured_post';
		$query_args['meta_value']   = 1;
		$query_args['meta_compare'] = 'LIKE';
	}

	$query = new WP_Query( $query_args );

	$blog_view_container = '';
	if ( 'load_more' === $team_listing_1_element_pagination_style ) {
		$blog_view_container = $blog_view . '_LoadMoreContainer';
	}

	global $w3construct_query_result;
	$w3construct_query_result['posts']               = $query->posts;
	$w3construct_query_result['posts_per_page']      = $team_listing_1_element_no_of_posts;
	$w3construct_query_result['current_page']        = $page_no;
	$w3construct_query_result['show_column']         = $team_listing_1_element_column;
	$w3construct_query_result['show_share']          = $team_listing_1_element_show_social;
	$w3construct_query_result['blog_view_container'] = $blog_view_container;
	$max_num_pages                                   = $query->max_num_pages;
	if ( $query->have_posts() ) {
		?>
<!-- Team -->
<section class="content-inner section-title style-2 line-img">
	<div class="container">
		<?php if ( ! empty( $team_listing_1_element_title ) ) { ?>
			<div class="section-head style-1 text-center">
				<h2 class="title">
					<?php echo wp_kses( $team_listing_1_element_title, w3construct_allowed_html_tag() ); ?>
				</h2>
				<div class="dz-separator style-1 text-primary"></div>
				<?php if ( ! empty( $team_listing_1_element_description ) ) { ?>
					<p>
						<?php echo wp_kses( $team_listing_1_element_description, 'string' ); ?>
					</p>
				<?php } ?>
			</div>
		<?php } ?>
		<!-- Left part start -->
		<div <?php if ( ! empty( $blog_view_container ) ) { ?>
			id="<?php echo esc_attr( $blog_view_container ); ?>" <?php } ?> class="row">
		<?php get_template_part( 'dz-inc/elementor/ajax/team-listing-1-ajax' ); ?>
		</div>
		<!-- Side bar END -->
			<?php
			if ( 'load_more' === $team_listing_1_element_pagination_style ) {
					$blog_view_btn       = $blog_view . '_LoadMoreBtn';
					$blog_view_container = $blog_view . '_LoadMoreContainer';

				if ( 1 < $max_num_pages ) {
					?>
					<!-- Pagination start -->
					<div class="reload-btn text-center mb-4">
					<a href="javascript:void(0);" class="btn shadow-primary btn-primary btn-rounded btn-ov-secondary loadmore-btn dz-load-more " id="<?php echo esc_attr( $blog_view_btn ); ?>"
						data-ajax-container = "<?php echo esc_js( $blog_view_container ); ?>"
						data-post-type = "<?php echo esc_js( $post_type_w3 ); ?>"
						data-blog-view = "<?php echo esc_js( $blog_view ); ?>"
						data-max-num-pages="<?php echo esc_js( $max_num_pages ); ?>"
						data-posts-per-page="<?php echo esc_js( $team_listing_1_element_no_of_posts ); ?>"
						data-only-featured-post="<?php echo esc_js( $team_listing_1_element_only_featured_posts ); ?>"
						data-post-order="<?php echo esc_js( $team_listing_1_element_order ); ?>"
						data-post-order-by="<?php echo esc_js( $team_listing_1_element_orderby ); ?>"
						data-show-column="<?php echo esc_js( $team_listing_1_element_column ); ?>"
						data-show-share="<?php echo esc_js( $team_listing_1_element_show_social ); ?>"
						data-posts-in-categories="<?php echo esc_js( $team_listing_1_element_posts_in_categories ); ?>"
						>
					<?php echo esc_html__( 'Load More', 'w3construct' ); ?> <i class="fa fa-refresh fas fa-spinner fa-spin"></i></a>
					</div>
					<!-- Pagination End -->
					<?php
				}
			}
			?>
	</div>
</section>
<?php } ?>
