<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

	$query_args = array(
		'post_type'           => 'dz_team',
		'post_status'         => 'publish',
		'posts_per_page'      => $team_1_element_no_of_posts,
		'orderby'             => $team_1_element_orderby,
		'order'               => $team_1_element_order,
		'ignore_sticky_posts' => true,
	);

	if ( 'views_count' === $team_1_element_orderby ) {
		$query_args['meta_key'] = '_views_count';
	} else {
		$query_args['orderby'] = $team_1_element_orderby;
	}


	$query_args['meta_query'] = array(
		array(
			'key'     => '_thumbnail_id',
			'compare' => 'EXISTS',
		),
	);

	$team_1_element_image_preference = ! empty( $team_1_element_image_preference ) ? $team_1_element_image_preference : 'all_posts';

	if ( 'image_post_only' === $team_1_element_image_preference ) {
		$query_args['meta_query'] = array(
			array(
				'key'     => '_thumbnail_id',
				'compare' => 'EXISTS',
			),
		);
	} elseif ( 'text_post_only' === $team_1_element_image_preference ) {
		$query_args['meta_query'] = array(
			array(
				'key'     => '_thumbnail_id',
				'compare' => 'Not EXISTS',
			),
		);
	}

	if ( 'yes' === $team_1_element_only_featured_posts ) {
		$query_args['meta_key']     = 'featured_post';
		$query_args['meta_value']   = 1;
		$query_args['meta_compare'] = 'LIKE';
	}

	if ( ! empty( $team_1_element_posts_in_categories ) && ! empty( $team_1_element_posts_in_categories[0] ) ) {
		$team_1_element_posts_in_categories1 = w3construct_get_cat_id_by_slug( $team_1_element_posts_in_categories, 'team_category' );

		$query_args['tax_query'][] = array(
			'taxonomy' => 'team_category',
			'field'    => 'id',
			'terms'    => $team_1_element_posts_in_categories1,
			'operator' => 'IN',
		);
	}

	$query_w3       = new WP_Query( $query_args );
	$bg_placeholder = '';
	$bg_class       = '';
	$bg_placeholder = ! empty( $team_1_element_bg_placeholder ) ? $team_1_element_bg_placeholder : '';

	if ( ! empty( $query_w3->have_posts() ) ) {

		?>

<!-- Team -->
<section class="content-inner section-title style-2" data-name="<?php echo esc_attr( $bg_placeholder ); ?>">
	<div class="container">
		<?php if ( ! empty( $team_1_element_title ) ) { ?>
			<div class="section-head style-1 text-center">
				<h2 class="title">
					<?php echo wp_kses( $team_1_element_title, w3construct_allowed_html_tag() ); ?>

				</h2>
				<div class="dz-separator style-1 text-primary"></div>
				<?php if ( ! empty( $team_1_element_description ) ) { ?>
					<p>
						<?php echo wp_kses( $team_1_element_description, 'string' ); ?>
					</p>
				<?php } ?>
			</div>
		<?php } ?>
		<div class="row">
			<div class="col-lg-12">

					<div class="swiper-container team-swiper-2">
						<div class="swiper-wrapper">
							<?php
							while ( $query_w3->have_posts() ) {
								$query_w3->the_post();
								global $post;
								$designation = w3construct_get_post_meta( get_the_id(), 'team_designation' );


								$team_social_data = w3construct_get_team_social_link( get_the_id() );
								?>
								<div class="swiper-slide">
									<div class="dz-team style-2 text-center m-b30 overlay-shine " >
										<?php if ( has_post_thumbnail() ) { ?>
											<div class="dz-media" tabindex="0">
												<?php the_post_thumbnail(); ?>

												<?php if ( $team_social_data['any_fill'] ) { ?>
													<ul class="team-social">
														<?php
														foreach ( $team_social_data['data'] as $key => $value ) {
															if ( ! empty( $value['url'] ) ) {
																?>
														<li>
															<a target="_blank" class="<?php echo esc_attr( $value['class'] ); ?>" href="<?php echo esc_url( $value['url'] ); ?>"></a>
														</li>
																<?php
															}
														}
														?>
													</ul>
												<?php } ?>
											</div>
										<?php } ?>
										<div class="dz-content m-t20">
											<h6 class="dz-position line text-primary"><?php echo esc_html( $designation ); ?></h6>
											<h5 class="dz-name">
												<?php the_title(); ?>
											</h5>
										</div>
									</div>
								</div>
							<?php } ?>
						</div>
					</div>

			</div>
		</div>
	</div>
</section>
<?php } ?>


<script>
	jQuery( document ).ready( function() {
		handleTeamSlider2();
	} );
</script>
