<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

global $w3construct_option;

$maintenance_title = w3construct_set( $w3construct_option, 'maintenance_title' );
$maintenance_desc  = w3construct_set( $w3construct_option, 'maintenance_desc' );
$maintenance_bg    = w3construct_set( $w3construct_option, 'maintenance_bg' );
$maintenance_icon  = w3construct_set( $w3construct_option, 'maintenance_icon' );

$maintenance_title = ! empty( $maintenance_title ) ? $maintenance_title : esc_html__( 'Site Is Down', 'w3construct' ) . ' <br/>' . esc_html__( 'For Maintenance', 'w3construct' );
$maintenance_desc  = ! empty( $maintenance_desc ) ? $maintenance_desc : esc_html__( 'This is the Technical Problems Page.', 'w3construct' ) . ' <br/>' . esc_html__( 'Or any other page.', 'w3construct' );

?>
<div class="under-construct" <?php if ( ! empty( $maintenance_bg ) ) { ?>
		style="background-image:url(<?php echo esc_url( $maintenance_bg ); ?>);  background-repeat:no-repeat; background-size:cover; background-position:bottom;"
	<?php } ?>>
	<div class="inner-box">
		<?php if ( ! empty( $maintenance_icon ) ) { ?>
			<div class="logo-header">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url( $maintenance_icon ); ?>"
						alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>"></a>
			<?php } ?>
		</div>
		<div class="dz-content">
			<?php if ( ! empty( $maintenance_title ) ) { ?>
				<h2 class="dz-title">
					<?php echo wp_kses( $maintenance_title, w3construct_allowed_html_tag() ); ?>
				</h2>
			<?php } ?>

			<?php if ( ! empty( $maintenance_desc ) ) { ?>
				<p>
					<?php echo wp_kses( $maintenance_desc, w3construct_allowed_html_tag() ); ?>
				</p>
			<?php } ?>
		</div>
	</div>
</div>
