<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

?>

<section class="content-inner">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12 aos-item" data-aos-duration="1000" data-aos-delay="100">
				<div class="service-detail dz-page-text sidebar">
					<div class="dz-content">
						<?php if ( ! empty( $service_detail_1_element_title ) ) { ?>
							<h2 class="title m-b15">
								<?php echo wp_kses( $service_detail_1_element_title, 'string' ); ?>
							</h2>
						<?php } ?>

						<div class="row">
							<?php if ( ! empty( $service_detail_1_element_left_description ) ) { ?>
								<div class="col-md-6">
									<p>
										<?php echo wp_kses( $service_detail_1_element_left_description, 'string' ); ?>
									</p>
								</div>
							<?php } ?>

							<?php if ( ! empty( $service_detail_1_element_right_description ) ) { ?>
								<div class="col-md-6">
									<p>
										<?php echo wp_kses( $service_detail_1_element_right_description, 'string' ); ?>
									</p>
								</div>
							<?php } ?>
						</div>
					</div>

					<?php
					if ( ! empty( $service_detail_1_element_item ) ) {
						$item_arr = $service_detail_1_element_item;
						?>

						<div class="dz-media">
							<div class="row gy-4">
								<?php
								$animation_time = 200;
								foreach ( $item_arr as $item_key => $item_value ) {

									if ( ! empty( $item_value['service_detail_1_element_image']['id'] ) ) {
										$image_url       = $item_value['service_detail_1_element_image']['url'];
										$animation_time += 200;

										$section_column = $item_value['service_detail_1_element_image_column'];
										?>
										<div class="<?php echo esc_attr( $section_column ); ?> aos-item" data-aos-duration="1000"
											data-aos-delay="<?php echo esc_attr( $animation_time ); ?>">
											<img src="<?php echo esc_url( $image_url ); ?>"
												alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
										</div>
										<?php
									}
								}
								?>
							</div>
						</div>
					<?php } ?>

					<?php if ( ! empty( $service_detail_1_element_content ) ) { ?>
						<div class="dz-content">
							<?php echo wp_kses( $service_detail_1_element_content, w3construct_allowed_html_tag() ); ?>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>
</section>
