<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$query_args       = array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => $post_slider_1_element_no_of_posts,
	'order'               => $post_slider_1_element_order,
	'ignore_sticky_posts' => true,
);
$title_text_limit = $post_slider_1_element_text_limit;
if ( 'views_count' === $post_slider_1_element_orderby ) {
	$query_args['meta_key'] = '_views_count';
} else {
	$query_args['orderby'] = $post_slider_1_element_orderby;
}
if ( 'image_post_only' === $post_slider_1_element_image_preference ) {
	$query_args['meta_query'] = array(
		array(
			'key'     => '_thumbnail_id',
			'compare' => 'EXISTS',
		),
	);
} elseif ( 'text_post_only' === $post_slider_1_element_image_preference ) {
	$query_args['meta_query'] = array(
		array(
			'key'     => '_thumbnail_id',
			'compare' => 'Not EXISTS',
		),
	);
}
if ( 'yes' === $post_slider_1_element_only_featured_posts ) {
	$query_args['meta_key']     = 'featured_post';
	$query_args['meta_value']   = 1;
	$query_args['meta_compare'] = 'LIKE';
}
if ( ! empty( $post_slider_1_element_posts_in_categories ) && ! empty( $post_slider_1_element_posts_in_categories[0] ) ) {
	$post_slider_1_element_posts_in_categories = implode( ',', $post_slider_1_element_posts_in_categories );
	$query_args['category_name']               = $post_slider_1_element_posts_in_categories;
} else {
	$post_slider_1_element_posts_in_categories = '';
}

$query_w3 = new WP_Query( $query_args );

if ( $query_w3->have_posts() ) {
	?>
	<!-- Blog -->
	<section class="content-inner-1">
		<div class="container">
			<?php if ( ! empty( $post_slider_1_element_title ) ) { ?>
				<div class="section-head style-1 text-center">
					<h2 class="title text-uppercase">
						<?php echo wp_kses( $post_slider_1_element_title, 'string' ); ?>
					</h2>
					<div class="dz-separator style-1 text-primary"></div>
					<?php if ( ! empty( $post_slider_1_element_description ) ) { ?>
						<p>
							<?php echo wp_kses( $post_slider_1_element_description, 'string' ); ?>
						</p>
					<?php } ?>
				</div>
			<?php } ?>

			<div class="blog-area">
				<div class="swiper-container blog-swiper">
					<div class="swiper-wrapper">
						<?php
						$animate_time = 200;
						while ( $query_w3->have_posts() ) {
							$query_w3->the_post();
							global $post;
							$post_title        = w3construct_trim( get_the_title(), 6 );
							$author_name       = get_the_author_meta( 'display_name', $post->post_author );
							$short_description = ! empty( $title_text_limit ) ? w3construct_trim( get_the_content(), $title_text_limit ) : get_the_content();

							$animate_time += 200;
							?>
							<div class="swiper-slide">
								<div class="dz-card blog-grid style-1 aos-item" data-aos-duration="2000"
									data-aos-delay="<?php echo esc_attr( $animate_time ); ?>">
									<div class="dz-media">
										<a href="<?php echo esc_url( get_permalink() ); ?>">
											<?php the_post_thumbnail( 'w3construct_555x400' ); ?>
										</a>
									</div>
									<div class="dz-info">
										<div class="dz-meta">
											<ul>
												<li class="post-date">
													<?php echo esc_html( get_the_date( 'M j, Y' ) ); ?>
												</li>
											</ul>
										</div>
										<h5 class="dz-title">
											<a href="<?php echo esc_url( get_permalink() ); ?>">
												<?php echo esc_html( $post_title ); ?>
											</a>
										</h5>
										<div class="dz-post-text text">
											<p>
												<?php echo esc_html( $short_description ); ?>
											</p>
										</div>
										<a href="<?php echo esc_url( get_permalink() ); ?>" class="btn-link">
											<?php echo esc_html__( 'Read More', 'w3construct' ); ?>
										</a>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<?php
}
wp_reset_postdata();
