<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$blog_view = 'post_listing_2';
$page_no   = 1;

$query_args = array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => $post_listing_2_element_no_of_posts,
	'order'               => $post_listing_2_element_order,
	'ignore_sticky_posts' => true,
);

if ( 'views_count' === $post_listing_2_element_orderby ) {
	$query_args['meta_key'] = '_views_count';
} else {
	$query_args['orderby'] = $post_listing_2_element_orderby;
}


$post_listing_2_element_image_preference = ! empty( $post_listing_2_element_image_preference ) ? $post_listing_2_element_image_preference : 'all_posts';

if ( 'image_post_only' === $post_listing_2_element_image_preference ) {
	$query_args['meta_query'] = array(
		array(
			'key'     => '_thumbnail_id',
			'compare' => 'EXISTS',
		),
	);
} elseif ( 'text_post_only' === $post_listing_2_element_image_preference ) {
	$query_args['meta_query'] = array(
		array(
			'key'     => '_thumbnail_id',
			'compare' => 'Not EXISTS',
		),
	);
}
if ( ! empty( $post_listing_2_element_posts_in_categories ) && ! empty( $post_listing_2_element_posts_in_categories[0] ) ) {
	$post_listing_2_element_posts_in_categories = implode( ',', $post_listing_2_element_posts_in_categories );
	$query_args['category_name']                = $post_listing_2_element_posts_in_categories;
} else {
	$post_listing_2_element_posts_in_categories = '';
}

if ( 'yes' === $post_listing_2_element_only_featured_posts ) {
	$query_args['meta_key']     = 'featured_post';
	$query_args['meta_value']   = 1;
	$query_args['meta_compare'] = 'LIKE';
}

if ( 'No_Sidebar' === $post_listing_2_element_selected_sidebar || ! is_active_sidebar( $post_listing_2_element_selected_sidebar ) || ! w3construct_is_theme_sidebar_active() ) {
	$col_classes = 'col-xl-12 col-lg-12';

} else {
	$col_classes = 'col-xl-8 col-lg-8';
}

$query_w3 = new WP_Query( $query_args );

$blog_view_container = '';
if ( 'load_more' === $post_listing_2_element_pagination_style ) {
	$blog_view_container = $blog_view . '_LoadMoreContainer';
}

global $w3construct_query_result;
$w3construct_query_result['posts']            = $query_w3->posts;
$w3construct_query_result['posts_per_page']   = $post_listing_2_element_no_of_posts;
$w3construct_query_result['current_page']     = $page_no;
$w3construct_query_result['side_bar']         = $post_listing_2_element_selected_sidebar;
$w3construct_query_result['title_text_limit'] = $post_listing_2_element_text_limit;

$w3construct_query_result['blog_view_container'] = $blog_view_container;
$max_num_pages                                   = $query_w3->max_num_pages;

if ( $query_w3->have_posts() ) {
	?>
	<!-- Blog -->
	<section class="content-inner">
		<div class="container">
			<?php if ( ! empty( $post_listing_2_element_title ) ) { ?>
				<div class="section-head style-1 text-center">
					<?php if ( ! empty( $post_listing_2_element_subtitle ) ) { ?>
						<h6 class="sub-title text-primary">
							<?php echo wp_kses( $post_listing_2_element_subtitle, 'string' ); ?>
						</h6>
					<?php } ?>

					<h2 class="title">
						<?php echo wp_kses( $post_listing_2_element_title, 'string' ); ?>
					</h2>

					<?php if ( ! empty( $post_listing_2_element_description ) ) { ?>
						<p>
							<?php echo wp_kses( $post_listing_2_element_description, 'string' ); ?>
						</p>
					<?php } ?>
				</div>
			<?php } ?>
			<div class="row">
				<?php
				if ( 'left' === $post_listing_2_element_sidebar_layout && is_active_sidebar( $post_listing_2_element_selected_sidebar ) && w3construct_is_theme_sidebar_active() ) {
					?>
					<div class="col-xl-4 col-lg-4 dz-order-1">
						<aside class="side-bar sticky-top left">
							<?php dynamic_sidebar( $post_listing_2_element_selected_sidebar ); ?>
						</aside>
					</div>
				<?php } ?>
				<!-- Side bar END -->
				<!-- Left part start -->
				<div class="<?php echo esc_attr( $col_classes ); ?>">
					<div <?php if ( ! empty( $blog_view_container ) ) { ?>
					id="<?php echo esc_attr( $blog_view_container ); ?>" <?php } ?>>
						<?php get_template_part( 'dz-inc/elementor/ajax/post-listing-2-ajax' ); ?>
					</div>
					<!-- Side bar END -->
					<?php
					if ( 'load_more' === $post_listing_2_element_pagination_style ) {
						$blog_view_btn       = $blog_view . '_LoadMoreBtn';
						$blog_view_container = $blog_view . '_LoadMoreContainer';

						if ( 1 < $max_num_pages ) {
							?>
							<!-- Pagination start -->
							<div class="reload-btn text-center mb-4">
								<a href="javascript:void( 0 );"
									class="btn shadow-primary btn-primary btn-rounded btn-ov-secondary loadmore-btn dz-load-more "
									id="<?php echo esc_attr( $blog_view_btn ); ?>"
									data-ajax-container="<?php echo esc_js( $blog_view_container ); ?>"
									data-blog-view="<?php echo esc_js( $blog_view ); ?>"
									data-max-num-pages="<?php echo esc_js( $max_num_pages ); ?>"
									data-posts-per-page="<?php echo esc_js( $post_listing_2_element_no_of_posts ); ?>"
									data-image-preference="<?php echo esc_js( $post_listing_2_element_image_preference ); ?>"
									data-only-featured-post="<?php echo esc_js( $post_listing_2_element_only_featured_posts ); ?>"
									data-post-order="<?php echo esc_js( $post_listing_2_element_order ); ?>"
									data-post-order-by="<?php echo esc_js( $post_listing_2_element_orderby ); ?>"
									data-posts-in-categories="<?php echo esc_js( $post_listing_2_element_posts_in_categories ); ?>"
									data-side-bar="<?php echo esc_js( $post_listing_2_element_selected_sidebar ); ?>"
									data-title-text-limit="<?php echo esc_js( $post_listing_2_element_text_limit ); ?>">
									<?php echo esc_html__( 'LOAD MORE', 'w3construct' ); ?> <i
										class="fa fa-refresh fas fa-spinner  fa-spin"></i>
								</a>
							</div>
							<!-- Pagination End -->
							<?php
						}
					}
					?>
				</div>
				<?php
				if ( 'right' === $post_listing_2_element_sidebar_layout && is_active_sidebar( $post_listing_2_element_selected_sidebar ) && w3construct_is_theme_sidebar_active() ) {
					?>
					<div class="col-xl-4 col-lg-4 dz-order-1">
						<aside class="side-bar sticky-top right">
							<?php dynamic_sidebar( $post_listing_2_element_selected_sidebar ); ?>
						</aside>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>
	<?php
}
