<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$query_args       = array(
	'post_type'           => 'post',
	'post_status'         => 'publish',
	'posts_per_page'      => 4,
	'order'               => $post_collage_1_element_order,
	'ignore_sticky_posts' => true,
);
$title_text_limit = $post_collage_1_element_text_limit;
if ( 'views_count' === $post_collage_1_element_orderby ) {
	$query_args['meta_key'] = '_views_count';
} else {
	$query_args['orderby'] = $post_collage_1_element_orderby;
}
if ( 'image_post_only' === $post_collage_1_element_image_preference ) {
	$query_args['meta_query'] = array(
		array(
			'key'     => '_thumbnail_id',
			'compare' => 'EXISTS',
		),
	);
} elseif ( 'text_post_only' === $post_collage_1_element_image_preference ) {
	$query_args['meta_query'] = array(
		array(
			'key'     => '_thumbnail_id',
			'compare' => 'Not EXISTS',
		),
	);
}
if ( 'true' === $post_collage_1_element_only_featured_posts ) {
	$query_args['meta_key']     = 'featured_post';
	$query_args['meta_value']   = 1;
	$query_args['meta_compare'] = 'LIKE';
}
if ( $post_collage_1_element_posts_in_categories ) {
	$post_collage_1_element_posts_in_categories = implode( ',', $post_collage_1_element_posts_in_categories );
	$query_args['category_name']                = $post_collage_1_element_posts_in_categories;
}

$query            = new WP_Query( $query_args );
$btn_link         = '';
$btn_text         = '';
$anchor_attribute = '';
if ( ! empty( $post_collage_1_element_content_link_title ) ) {
	$btn_link         = ! empty( $post_collage_1_element_content_link ) ? $post_collage_1_element_content_link : '';
	$btn_text         = ! empty( $post_collage_1_element_content_link_title ) ? $post_collage_1_element_content_link_title : '';
	$anchor_attribute = w3construct_elementor_get_anchor_attribute( $btn_link );
}
$section_class  = '';
$section_class .= ! empty( $post_collage_1_element_section_padding ) ? ' ' . $post_collage_1_element_section_padding : 'content-inner-1';
if ( $query->have_posts() ) {

	?>
<!-- Blog -->
<section class="<?php echo esc_attr( $section_class ); ?>">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-md-8">
				<?php
				if ( ! empty( $post_collage_1_element_title ) ) {
					?>
					<div class="section-head style-1">
						<h2 class="title">
							<?php echo wp_kses( $post_collage_1_element_title, w3construct_allowed_html_tag() ); ?>
						</h2>
						<div class="dz-separator style-1 text-primary"></div>
						<?php
						if ( ! empty( $post_collage_1_element_description ) ) {
							?>
							<p>
								<?php echo wp_kses( $post_collage_1_element_description, 'string' ); ?>
							</p>
						<?php } ?>
					</div>
				<?php } ?>
			</div>
			<?php if ( ! empty( $btn_text ) ) { ?>
				<div class="col-md-4 text-md-end text-start m-b30 d-none d-lg-block">
					<a href="<?php echo esc_url( $btn_link['url'] ); ?>" <?php echo esc_html( $anchor_attribute ); ?> class="btn-link style-2">
						<?php echo esc_html( $btn_text ); ?> <i class="m-l5 las la-plus"></i>
					</a>
				</div>
			<?php } ?>
		</div>
		<div class="row">
			<div class="col-lg-6">
			<?php
				$count  = 1;
				$output = '';
			while ( $query->have_posts() ) {

				$query->the_post();
				global $post;
				$post_title        = w3construct_trim( get_the_title(), 10 );
				$author_name       = get_the_author_meta( 'display_name', $post->post_author );
				$short_description = ! empty( $title_text_limit ) ? w3construct_trim( get_the_content(), $title_text_limit ) : get_the_content();

				if ( 1 === $count ) {
					$output .= '<div class="dz-card blog-grid style-2 m-b30">
						<div class="dz-media m-b20">
							<a href="' . esc_url( get_permalink() ) . '">
								<img src="' . get_the_post_thumbnail_url( get_the_id(), 'full' ) . '" >
							</a>
						</div>
						<div class="dz-info p-0">
							<div class="dz-meta">
								<ul>
									<li class="post-date">' . esc_html( get_the_date( 'M j, Y' ) ) . '</li>
									<li class="post-user"> <a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( $author_name ) . '</a></li>
								</ul>
							</div>
							<h5 class="dz-title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( $post_title ) . '</a></h5>
							<div class="dz-post-text text">
								<p>' . esc_html( $short_description ) . '</p>
							</div>
							<a class="btn-link style-2" href="' . esc_url( get_permalink() ) . '">' . esc_html__( 'READ MORE', 'w3construct' ) . ' <i class="m-l5 las la-plus"></i></a>
						</div>
					</div>';
				} else {
					if ( 2 === $count ) {

							$output .= '</div>
										<div class="col-lg-6">
											<div class="widget recent-posts-entry style-2">
												<div class="widget-post-bx">';
					}

							$output .= '<div class="widget-post clearfix">
											<div class="dz-media">
												<a href="' . esc_url( get_permalink() ) . '"><img src="' . get_the_post_thumbnail_url( get_the_id(), 'thumbnail' ) . '" ></a>
											</div>
											<div class="dz-info">
												<h5 class="title"><a href="' . esc_url( get_permalink() ) . '">' . esc_html( $post_title ) . '</a></h5>
												<div class="dz-meta">
													<ul>
														<li class="post-date">' . esc_html( get_the_date( 'M j, Y' ) ) . '</li>
														<li class="post-user"> <a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( $author_name ) . '</a></li>
													</ul>
												</div>
											</div>
										</div>';


					if ( 4 === $count ) {
							$output .= '		</div>
											</div>
										</div>';

					}
				}

				?>
				<?php

					++$count;

			}
				echo wp_kses( $output, w3construct_allowed_html_tag() );

			?>
			</div>
		</div>
	</div>
</section>
	<?php
}
