<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

?>

<section class="section-full content-inner-2 port-detail">
	<div class="container">
		<div class="row">
			<?php
			if ( ! empty( $portfolio_detail_1_element_image['id'] ) ) {
				$image_url = $portfolio_detail_1_element_image['url'];
				?>
				<div class="col-lg-12 col-md-12 m-b50 aos-item m-sm-b30" data-aos-duration="1000" data-aos-delay="200">
					<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
				</div>
			<?php } ?>
			<div class="col-lg-6 col-md-12 align-self-center aos-item" data-aos-duration="1000" data-aos-delay="400">
				<?php if ( ! empty( $portfolio_detail_1_element_title ) ) { ?>
					<h2 class="dz-title">
						<?php echo wp_kses( $portfolio_detail_1_element_title, 'string' ); ?>
					</h2>
				<?php } ?>

				<?php if ( ! empty( $portfolio_detail_1_element_description ) ) { ?>
					<p class="m-b30">
						<?php echo wp_kses( $portfolio_detail_1_element_description, w3construct_allowed_html_tag() ); ?>
					</p>
				<?php } ?>

				<?php
				$count     = 1;
				$icon_name = '';
				if ( ! empty( $portfolio_detail_1_element_contact ) ) {

					$item_arr = $portfolio_detail_1_element_contact;

					$item_count = count( $item_arr );

					foreach ( $item_arr as $item_key => $item_value ) {

						$class     = ( $count === $item_count ) ? '' : 'm-b30';
						$icon_name = $item_value['portfolio_detail_1_element_contact_icon']['value'];

						?>

						<div class="icon-bx-wraper style-7 left <?php echo esc_attr( $class ); ?>">
							<?php if ( ! empty( $icon_name ) ) { ?>
								<div class="icon-bx-sm rounded-0 bg-primary">
									<span class="icon-cell"><i class="<?php echo esc_attr( $icon_name ); ?>"></i></span>
								</div>
							<?php } ?>
							<div class="icon-content">
								<?php if ( ! empty( $item_value['portfolio_detail_1_element_contact_title'] ) ) { ?>
									<h4 class="title m-b5">
										<?php echo wp_kses( $item_value['portfolio_detail_1_element_contact_title'], 'string' ); ?>
									</h4>
								<?php } ?>

								<?php if ( ! empty( $item_value['portfolio_detail_1_element_contact_description'] ) ) { ?>
									<p>
										<?php echo wp_kses( $item_value['portfolio_detail_1_element_contact_description'], 'string' ); ?>
									</p>
								<?php } ?>
							</div>
						</div>
						<?php
						++$count;
					}
				}
				?>
			</div>
			<?php
			if ( ! empty( $portfolio_detail_1_element_image2['id'] ) ) {
				$image_url = $portfolio_detail_1_element_image2['url'];
				?>
				<div class="col-lg-6 col-md-12 aos-item" data-aos-duration="1000" data-aos-delay="600">
					<img src="<?php echo esc_url( $image_url ); ?>" class="d-lg-block d-none"
						alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
				</div>
			<?php } ?>
		</div>
	</div>
</section>
