<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

?>
<section class="content-inner overlay-grey-dark" <?php if ( ! empty( $partners_with_video_section_element_bg_img['id'] ) ) { ?>
style="background-image:url(<?php echo esc_url( $partners_with_video_section_element_bg_img['url'] ); ?>); background-position:left top; background-size:cover; background-repeat:no-repeat;" <?php } ?>>
	<div class="container">
		<div class="row">
			<?php if ( ! empty( $partners_with_video_section_element_video_link ) ) { ?>
				<div class="col-lg-12 text-center">
					<div class="video-bx content-media style-3 m-b50">
						<div class="video-btn">
							<a href="<?php echo esc_url( $partners_with_video_section_element_video_link ); ?>" class="popup-youtube"><i class="fas fa-play"></i></a>
						</div>
					</div>
					<?php
					if ( ! empty( $partners_with_video_section_element_title ) ) {
						?>
						<div class="section-head style-1 text-center">
							<h2 class="title">
								<?php echo wp_kses( $partners_with_video_section_element_title, w3construct_allowed_html_tag() ); ?>
							</h2>
						</div>
					<?php } ?>
				</div>
			<?php } ?>
			<?php
			if ( ! empty( $partners_with_video_element_item ) ) {
				$item_arr = $partners_with_video_element_item;
				?>
				<div class="col-lg-12">
					<div class="client-logo-wrapper">
						<?php
						foreach ( $item_arr as $item_value ) {
							if ( ! empty( $item_value['partners_with_video_element_item_image1']['id'] ) || $item_value['partners_with_video_element_item_image2']['id'] ) {
								$image_url    = $item_value['partners_with_video_element_item_image1']['url'];
								$back_img_url = $item_value['partners_with_video_element_item_image2']['url'];
								?>
								<div class="clients-logo aos-item aos-init aos-animate" data-aos="fade-in" data-aos-duration="1000" data-aos-delay="100">
									<img class="logo-main" src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
								</div>
								<?php
							}
						}
						?>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</section>
