<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$partners_1_element_title = ( ! empty( $partners_1_element_title ) ) ? $partners_1_element_title : '';
?>

<!-- Clients Logo -->
<section
	class="
	<?php
	if ( ! empty( $partners_1_element_title ) ) {
		echo 'content-inner';
	} else {
		?>
		clients-section-1  pb-0
		<?php
	}
	?>
	">
	<div class="container">
		<?php if ( ! empty( $partners_1_element_title ) ) { ?>
			<div class="section-head style-1 text-center">
				<?php if ( ! empty( $partners_1_element_subtitle ) ) { ?>
					<h6 class="sub-title text-primary">
						<?php echo wp_kses( $partners_1_element_subtitle, 'string' ); ?>
					</h6>
				<?php } ?>

				<h2 class="title">
					<?php echo wp_kses( $partners_1_element_title, 'string' ); ?>
				</h2>

				<?php if ( ! empty( $partners_1_element_description ) ) { ?>
					<p>
						<?php echo wp_kses( $partners_1_element_description, 'string' ); ?>
					</p>
				<?php } ?>
			</div>
		<?php } ?>

		<?php
		if ( ! empty( $partners_1_element_images ) ) {
			?>
			<div class="swiper-container clients-swiper">
				<div class="swiper-wrapper">
					<?php
					foreach ( $partners_1_element_images as $item_value ) {
						if ( ! empty( $item_value['id'] ) ) {
							?>
							<div class="swiper-slide">
								<div class="clients-logo aos-item" data-aos-duration="1000" data-aos-delay="100">
									<img class="logo-main" src="<?php echo esc_url( $item_value['url'] ); ?>"
										alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
								</div>
							</div>
							<?php
						}
					}
					?>
				</div>
			</div>
		<?php } ?>
	</div>
</section>
