<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$site_phone_number = w3construct_get_opt( 'site_phone_number' );
$site_email        = w3construct_get_opt( 'site_email' );
$allowed_html_tags = w3construct_allowed_html_tag();
if ( ! empty( $home_slider_1_element_item ) ) {
	$item_arr = $home_slider_1_element_item;
	?>
<!-- Slider -->
<div class="silder-two">
	<div class="swiper-container main-silder-swiper-2">
		<div class="swiper-wrapper">
			<?php

			foreach ( $item_arr as $item_value ) {

				$btn_link          = '';
				$btn_text          = '';
				$anchor_attribute  = '';
				$btn_link2         = '';
				$btn_text2         = '';
				$anchor_attribute2 = '';

				if ( ! empty( $item_value['home_slider_1_element_item_link_title'] ) || $item_value['home_slider_1_element_item_link_title2'] ) {

					$btn_link  = ! empty( $item_value['home_slider_1_element_item_link'] ) ? $item_value['home_slider_1_element_item_link'] : '';
					$btn_text  = ! empty( $item_value['home_slider_1_element_item_link_title'] ) ? $item_value['home_slider_1_element_item_link_title'] : '';
					$btn_link2 = ! empty( $item_value['home_slider_1_element_item_link2'] ) ? $item_value['home_slider_1_element_item_link2'] : '';
					$btn_text2 = ! empty( $item_value['home_slider_1_element_item_link_title2'] ) ? $item_value['home_slider_1_element_item_link_title2'] : '';

					$anchor_attribute  = w3construct_elementor_get_anchor_attribute( $btn_link );
					$anchor_attribute2 = w3construct_elementor_get_anchor_attribute( $btn_link2 );
				}
				?>
				<div class="swiper-slide">
					<div class="dz-slide-item">
						<div class="silder-content line-img" >
							<div class="inner-content">
								<?php if ( ! empty( $item_value['home_slider_1_element_item_subtitle'] ) ) { ?>
									<h6 class="sub-title text-primary">
										<?php echo wp_kses( $item_value['home_slider_1_element_item_subtitle'], 'string' ); ?>
									</h6>
								<?php } ?>
								<?php if ( ! empty( $item_value['home_slider_1_element_item_title'] ) ) { ?>
									<h1 class="title">
										<?php echo wp_kses( $item_value['home_slider_1_element_item_title'], w3construct_allowed_html_tag() ); ?>
									</h1>
								<?php } ?>
								<?php if ( ! empty( $item_value['home_slider_1_element_item_description'] ) ) { ?>
									<div class="m-b30">
										<?php echo wp_kses( $item_value['home_slider_1_element_item_description'], w3construct_allowed_html_tag() ); ?>
									</div>
								<?php } ?>
								<?php if ( ! empty( $btn_text ) ) { ?>
									<a href="<?php echo esc_url( $btn_link['url'] ); ?>" <?php echo esc_html( $anchor_attribute ); ?> class="btn shadow-primary btn-primary m-r30 m-b10">
										<?php echo esc_html( $btn_text ); ?> <i class="m-l5 las la-plus"></i>
									</a>
								<?php } ?>
								<?php if ( ! empty( $btn_text2 ) ) { ?>
									<a href="<?php echo esc_url( $btn_link2['url'] ); ?>" <?php echo esc_html( $anchor_attribute2 ); ?> class="btn btn-outline-primary shadow-none m-b10">
										<?php echo esc_html( $btn_text2 ); ?> <i class="m-l5 las la-plus"></i>
									</a>
								<?php } ?>
							</div>
						</div>
						<?php
						if ( ! empty( $item_value['home_slider_1_element_item_image']['id'] ) ) {
							$image_url = $item_value['home_slider_1_element_item_image']['url'];
							?>
							<div class="silder-img overlay-black-light">
								<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
							</div>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
	<?php if ( ! empty( $site_phone_number ) || ! empty( $site_email ) ) { ?>
		<div class="follow-info style-2 left">
			<div class="inner-info">
				<ul>
					<?php
					if ( ! empty( $site_phone_number ) ) {
						?>
						<li>
							<?php echo wp_kses( $site_phone_number, $allowed_html_tags ); ?>
						</li>
					<?php } ?>
					<?php if ( ! empty( $site_email ) ) { ?>
						<li>
							<?php echo wp_kses( $site_email, $allowed_html_tags ); ?>
						</li>
					<?php } ?>
				</ul>
			</div>
		</div>
	<?php } ?>
</div>
	<?php
}
