<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

if ( ! empty( $gallery_1_element_item ) ) {
	$item_arr = $gallery_1_element_item;
	?>
	<section class="content-inner">
		<div class="container">
			<div class="row lightgallery">
				<?php
				$animation_time = 200;
				foreach ( $item_arr as $item_key => $item_value ) {

					if ( ! empty( $item_value['gallery_1_element_image']['id'] ) ) {
						$image_url       = $item_value['gallery_1_element_image']['url'];
						$animation_time += 200;

						$section_column = $item_value['gallery_1_element_image_column'];
						?>
						<div class="<?php echo esc_attr( $section_column ); ?> m-b30 aos-item" data-aos-duration="1000"
							data-aos-delay="<?php echo esc_attr( $animation_time ); ?>">
							<div class="dz-box overlay style-1">
								<div class="dz-media">
									<img src="<?php echo esc_url( $image_url ); ?>"
										alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
								</div>
								<div class="dz-info">
									<span data-exthumbimage="<?php echo esc_url( $image_url ); ?>"
										data-src="<?php echo esc_url( $image_url ); ?>" class="view-btn lightimg"
										title="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>"></span>
								</div>
							</div>
						</div>
						<?php
					}
				}
				?>
			</div>
		</div>
	</section>
<?php } ?>
