<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$allowed_html_tag = w3construct_allowed_html_tag();

if ( 'style_1' === $counter_box_1_element_style ) { ?>
	<!-- Our Features -->
	<section class="content-inner counter-area">
		<div class="container">
			<div class="row">
				<?php if ( ! empty( $counter_box_1_element_title ) ) { ?>
					<div class="section-head style-1 text-center">
						<?php if ( ! empty( $counter_box_1_element_subtitle ) ) { ?>
							<h6 class="sub-title text-primary">
								<?php echo wp_kses( $counter_box_1_element_subtitle, 'string' ); ?>
							</h6>
						<?php } ?>

						<h2 class="title">
							<?php echo wp_kses( $counter_box_1_element_title, 'string' ); ?>
						</h2>

						<?php if ( ! empty( $counter_box_1_element_description ) ) { ?>
							<p>
								<?php echo wp_kses( $counter_box_1_element_description, 'string' ); ?>
							</p>
						<?php } ?>
					</div>
				<?php } ?>

				<?php
				if ( ! empty( $counter_box_1_element_item ) ) {
					$item_arr = $counter_box_1_element_item;
					foreach ( $item_arr as $item_key => $item_value ) {
						?>
						<div class="col-lg-3 col-6 aos-item" data-aos-duration="800" data-aos-delay="200">
							<div class="icon-bx-wraper style-6 m-b30" <?php if ( ! empty( $item_value['counter_box_1_element_item_number'] ) ) { ?>
									data-name="<?php echo wp_kses( $item_value['counter_box_1_element_item_number'], 'string' ); ?>" <?php } ?>>
								<?php if ( ! empty( $item_value['counter_box_1_element_item_number'] ) ) { ?>
									<h2 class="counter text-primary">
										<?php echo wp_kses( $item_value['counter_box_1_element_item_number'], 'string' ); ?>
									</h2>
								<?php } ?>

								<?php if ( ! empty( $item_value['counter_box_1_element_item_title'] ) ) { ?>
									<h4 class="title">
										<?php echo wp_kses( $item_value['counter_box_1_element_item_title'], $allowed_html_tag ); ?>
									</h4>
								<?php } ?>
							</div>
						</div>
						<?php
					}
				}
				?>
			</div>
		</div>
	</section>

<?php } else { ?>
	<section class="counter-area1">
		<div class="container">
			<div class="counter-inner bg-primary">
				<div class="row">
					<?php if ( ! empty( $counter_box_1_element_title ) ) { ?>
						<div class="section-head style-2 text-center">
							<?php if ( ! empty( $counter_box_1_element_subtitle ) ) { ?>
								<h6 class="sub-title text-primary">
									<?php echo wp_kses( $counter_box_1_element_subtitle, 'string' ); ?>
								</h6>
							<?php } ?>

							<h2 class="title">
								<?php echo wp_kses( $counter_box_1_element_title, 'string' ); ?>
							</h2>

							<?php if ( ! empty( $counter_box_1_element_description ) ) { ?>
								<p>
									<?php echo wp_kses( $counter_box_1_element_description, 'string' ); ?>
								</p>
							<?php } ?>
						</div>
					<?php } ?>

					<?php
					$animation_time = 200;
					if ( ! empty( $counter_box_1_element_item ) ) {
						$item_arr = $counter_box_1_element_item;
						foreach ( $item_arr as $item_key => $item_value ) {
							$animation_time += 200;
							?>
							<div class="col-lg-3 col-6 aos-item" data-aos-duration="800"
								data-aos-delay="<?php echo esc_attr( $animation_time ); ?>">
								<div class="icon-bx-wraper style-6 m-b30" <?php if ( ! empty( $item_value['counter_box_1_element_item_number'] ) ) { ?>
										data-name="<?php echo wp_kses( $item_value['counter_box_1_element_item_number'], 'string' ); ?>"
									<?php } ?>>
									<?php if ( ! empty( $item_value['counter_box_1_element_item_number'] ) ) { ?>
										<h2 class="counter">
											<?php echo wp_kses( $item_value['counter_box_1_element_item_number'], 'string' ); ?>
										</h2>
									<?php } ?>

									<?php if ( ! empty( $item_value['counter_box_1_element_item_title'] ) ) { ?>
										<h6 class="title">
											<?php echo wp_kses( $item_value['counter_box_1_element_item_title'], $allowed_html_tag ); ?>
										</h6>
									<?php } ?>
								</div>
							</div>
							<?php
						}
					}
					?>
				</div>
			</div>
		</div>
	</section>
<?php } ?>
