<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$btn_link         = '';
$btn_text         = '';
$anchor_attribute = '';

if ( ! empty( $content_box_4_element_image['id'] ) ) {
	$class = 'col-lg-6 m-b30';
} else {
	$class = 'col-lg-12 m-b30';
}

if ( ! empty( $content_box_4_element_content_link_title ) ) {
	$btn_link         = ! empty( $content_box_4_element_content_link ) ? $content_box_4_element_content_link : '';
	$btn_text         = ! empty( $content_box_4_element_content_link_title ) ? $content_box_4_element_content_link_title : '';
	$anchor_attribute = w3construct_elementor_get_anchor_attribute( $btn_link );
}
?>
<!-- About Us -->
<section class="content-inner-3">
	<div class="container">
		<div class="row align-items-end about-bx3">
			<?php
			if ( ! empty( $content_box_4_element_image['id'] ) && ( 'left' === $content_box_4_element_image_position ) ) {
				$image_url = $content_box_4_element_image['url'];
				?>
				<div class="col-lg-6 m-b30">
					<div class="dz-media">
						<img src="<?php echo esc_url( $image_url ); ?>" class="img1 aos-item" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>" >
					</div>
				</div>
			<?php } ?>
			<div class="<?php echo esc_attr( $class ); ?> p-b30 aos-item">
				<?php if ( ! empty( $content_box_4_element_title ) ) { ?>
					<div class="section-head style-1">
						<h2 class="title">
							<?php echo wp_kses( $content_box_4_element_title, 'string' ); ?>
						</h2>
						<div class="dz-separator style-1 text-primary"></div>
					</div>
				<?php } ?>
				<?php if ( ! empty( $content_box_4_element_description ) ) { ?>
					<p>
						<?php echo wp_kses( $content_box_4_element_description, w3construct_allowed_html_tag() ); ?>
					</p>
				<?php } ?>
				<?php
				if ( ! empty( $content_box_4_element_item ) ) {
					?>
					<div class="history-row m-b30">
						<?php
						foreach ( $content_box_4_element_item as $item ) {
							?>
							<div>
								<h2 class="year"><span class="counter"><?php echo wp_kses( $item['content_box_4_element_item_number'], 'string' ); ?></span>+</h2>
								<span class="text">
									<?php echo wp_kses( $item['content_box_4_element_item_title'], w3construct_allowed_html_tag() ); ?>
								</span>
							</div>
						<?php } ?>
					</div>
				<?php } ?>
				<?php if ( ! empty( $btn_text ) ) { ?>
					<a href="<?php echo esc_url( $btn_link['url'] ); ?>" <?php echo esc_html( $anchor_attribute ); ?> class="btn shadow-primary btn-primary">
						<?php echo esc_html( $btn_text ); ?> <i class="m-l10 las la-plus"></i>
					</a>
				<?php } ?>
			</div>
			<?php
			if ( ! empty( $content_box_4_element_image['id'] ) && ( 'right' === $content_box_4_element_image_position ) ) {
				$image_url = $content_box_4_element_image['url'];
				?>
				<div class="col-lg-6 m-b30">
					<div class="dz-media right">
						<img src="<?php echo esc_url( $image_url ); ?>" class="img1 aos-item" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>" >
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</section>
