<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$image_class = 'dz-media-1';
$class       = '';
$style_class = 'style-1';
$bg_class    = 'line-img';

?>
<section class="section-full content-inner section-title style-2 overflow-hidden bg-light <?php echo esc_attr( $bg_class ); ?>">
	<div class="container">
		<div class="row align-items-center <?php echo esc_attr( $class ); ?>">
			<?php
			if ( ! empty( $content_box_3_element_image['id'] ) && ( 'left' === $content_box_3_element_image_position ) ) {
				$image_url = $content_box_3_element_image['url'];
				?>
				<div class="col-lg-6 m-b30">
					<div class="<?php echo esc_attr( $image_class ); ?> left">
						<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
					</div>
				</div>
			<?php } ?>
			<div class="col-lg-6">
				<?php if ( ! empty( $content_box_3_element_title ) ) { ?>
					<div class="section-head style-1">
						<h2 class="title">
							<?php echo wp_kses( $content_box_3_element_title, w3construct_allowed_html_tag() ); ?>
						</h2>
						<div class="dz-separator style-1 text-primary"></div>
						<?php if ( ! empty( $content_box_3_element_description ) ) { ?>
							<p class="m-b30">
								<?php echo wp_kses( $content_box_3_element_description, 'string' ); ?>
							</p>
						<?php } ?>
					</div>
				<?php } ?>
				<?php
				$animation_time = 1;
				if ( ! empty( $content_box_3_element_item ) ) {
					foreach ( $content_box_3_element_item as $item ) {
						$animation_time += 200;
						?>
					<div class="progress-bx m-b40 aos-item <?php echo esc_attr( $style_class ); ?>" >
						<div class="progress-info">
							<h6 class="title">
								<?php echo wp_kses( $item['content_box_3_element_item_title'], 'string' ); ?>
							</h6>
							<h4 class="progress-value">
								<?php echo wp_kses( $item['content_box_3_element_item_number'], 'string' ); ?>%
							</h4>
						</div>
						<div class="progress">
							<div class="progress-bar" style="width: <?php echo esc_attr( $item['content_box_3_element_item_number'], 'string' ); ?>%" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">
							</div>
						</div>
					</div>
						<?php
					}
				}
				?>
			</div>
			<?php
			if ( ! empty( $content_box_3_element_image ) && ( 'right' === $content_box_3_element_image_position ) ) {
				$image_url = $content_box_3_element_image['url'];
				?>
				<div class="col-lg-6">
					<div class="<?php echo esc_attr( $image_class ); ?> right">
						<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</section>
