<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

?>

<!-- Our Strategy -->
<section
	class="section-full dz-content-bx style-2
	<?php
	if ( 'right' === $content_box_2_element_image_position ) {
		echo 'right';
	}
	?>
	">
	<div class="dz-content-inner bg-gray dz-lazy-background"
	<?php
	if ( ! empty( $content_box_2_element_bg_img['id'] ) ) {
		echo esc_attr( dz_get_lazy_loading_bg_img( $content_box_2_element_bg_img['id'], 'full', '' ) );
	}
	?>
	>
		<div class="container">
			<div class="row">
				<?php
				if ( ! empty( $content_box_2_element_image['id'] ) && 'left' === $content_box_2_element_image_position ) {
					?>
					<div class="col-lg-6 aos-item" data-aos-duration="800" data-aos-delay="400">
						<div class="content-media">
							<?php dz_get_image( $content_box_2_element_image['id'], 'full', array( 'alt' => esc_attr__( 'Image', 'w3construct' ) ), '' ); ?>
						</div>
					</div>
				<?php } ?>

				<div class="col-lg-6 content-inner-1 content-inside aos-item" data-aos-duration="800"
					data-aos-delay="200">
					<div class="section-head style-1">
						<?php if ( ! empty( $content_box_2_element_subtitle ) ) { ?>
							<h6 class="sub-title text-primary">
								<?php echo wp_kses( $content_box_2_element_subtitle, 'string' ); ?>
							</h6>
						<?php } ?>

						<?php if ( ! empty( $content_box_2_element_title ) ) { ?>
							<h2 class="title m-b20">
								<?php echo wp_kses( $content_box_2_element_title, 'string' ); ?>
							</h2>
						<?php } ?>

						<?php if ( ! empty( $content_box_2_element_description ) ) { ?>
							<p>
								<?php echo wp_kses( $content_box_2_element_description, 'string' ); ?>
							</p>
						<?php } ?>
					</div>


					<?php
					if ( ! empty( $content_box_2_element_item ) ) {
						$item_arr = $content_box_2_element_item;

						foreach ( $item_arr as $item_key => $item_value ) {
							?>
							<div class="progress-bx style-2 m-b40">
								<div class="progress-info">
									<h4 class="title ">
										<?php echo wp_kses( $item_value['content_box_2_element_item_title'], 'string' ); ?>
									</h4>
									<h4 class="progress-value ">
										<?php echo wp_kses( $item_value['content_box_2_element_item_number']['size'], 'string' ); ?>%
									</h4>
								</div>
								<div class="progress">
									<div class="progress-bar"
										style="width: <?php echo wp_kses( $item_value['content_box_2_element_item_number']['size'], 'string' ); ?>%"
										role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
								</div>
							</div>
							<?php
						}
					}
					?>
				</div>

				<?php
				if ( ! empty( $content_box_2_element_image['id'] ) && 'right' === $content_box_2_element_image_position ) {
					?>
					<div class="col-lg-6 aos-item" data-aos-duration="800" data-aos-delay="400">
						<div class="content-media">
							<?php dz_get_image( $content_box_2_element_image['id'], 'full', array( 'alt' => esc_attr__( 'Image', 'w3construct' ) ), '' ); ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</section>
