<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$btn_link         = '';
$btn_text         = '';
$anchor_attribute = '';
if ( ! empty( $content_box_1_element_link_title ) ) {
	$btn_link = ! empty( $content_box_1_element_link ) ? $content_box_1_element_link : '';
	$btn_text = ! empty( $content_box_1_element_link_title ) ? $content_box_1_element_link_title : '';

	$anchor_attribute = w3construct_elementor_get_anchor_attribute( $btn_link );
}
$allowed_html_tag = w3construct_allowed_html_tag();
?>

<!-- About Us -->
<section class="content-inner-2">
	<div class="container">
		<div class="row align-items-center about-bx1">
			<?php
			if ( ! empty( $content_box_1_element_image['id'] ) && 'left' === $content_box_1_element_img_position ) {
				$image_url = $content_box_1_element_image['url'];
				?>
				<div class="col-lg-6 m-lg-b30">
					<div class="dz-media">
						<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>"
							class="aos-item" data-aos-duration="800" data-aos-delay="400">
						<div class="year-exp aos-item" data-aos-duration="800" data-aos-delay="500">
							<?php if ( ! empty( $content_box_1_element_year ) ) { ?>
								<h2 class="year text-primary">
									<?php echo wp_kses( $content_box_1_element_year, 'string' ); ?>
								</h2>
							<?php } ?>

							<?php if ( ! empty( $content_box_1_element_year_title ) ) { ?>
								<h4 class="text">
									<?php echo wp_kses( $content_box_1_element_year_title, $allowed_html_tag ); ?>
								</h4>
							<?php } ?>
						</div>
					</div>
				</div>
				<?php
			}
			?>
			<div class="col-lg-6 aos-item" data-aos-duration="1500" data-aos-delay="800">
				<div class="section-head style-1">
					<?php if ( ! empty( $content_box_1_element_title ) ) { ?>
						<h2 class="title text-uppercase">
							<?php echo wp_kses( $content_box_1_element_title, 'string' ); ?>
						</h2>
					<?php } ?>
				</div>

				<?php
				if ( ! empty( $content_box_1_element_description ) ) {
					echo wp_kses( $content_box_1_element_description, $allowed_html_tag );
				}
				?>
				<?php
				if ( ! empty( $content_box_1_element_item ) ) {
					$item_arr = $content_box_1_element_item;

					?>
					<div class="row">
						<?php foreach ( $item_arr as $item_key => $item_value ) { ?>
							<div class="col-md-6">
								<div class="about-text-bx">
									<?php if ( ! empty( $item_value['content_box_1_element_item_title'] ) ) { ?>
										<h4>
											<?php echo wp_kses( $item_value['content_box_1_element_item_title'], 'string' ); ?>
										</h4>
									<?php } ?>

									<?php if ( ! empty( $item_value['content_box_1_element_item_description'] ) ) { ?>
										<p>
											<?php echo wp_kses( $item_value['content_box_1_element_item_description'], 'string' ); ?>
										</p>
									<?php } ?>
								</div>
							</div>
						<?php } ?>

					</div>
				<?php } ?>

				<?php if ( ! empty( $btn_text ) ) { ?>
					<a href="<?php echo esc_url( $btn_link['url'] ); ?>" <?php echo esc_html( $anchor_attribute ); ?>
						class="btn shadow-primary btn-primary">
						<?php echo esc_html( $btn_text ); ?>
					</a>
				<?php } ?>
			</div>

			<?php
			if ( ! empty( $content_box_1_element_image['id'] ) && 'right' === $content_box_1_element_img_position ) {
				$image_url = $content_box_1_element_image['url'];
				?>
				<div class="col-lg-6 m-lg-b30">
					<div class="dz-media right">
						<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>"
							class="aos-item" data-aos-duration="800" data-aos-delay="400">
						<div class="year-exp aos-item" data-aos-duration="800" data-aos-delay="500">
							<?php if ( ! empty( $content_box_1_element_year ) ) { ?>
								<h2 class="year text-primary">
									<?php echo wp_kses( $content_box_1_element_year, 'string' ); ?>
								</h2>
							<?php } ?>

							<?php if ( ! empty( $content_box_1_element_year_title ) ) { ?>
								<h4 class="text">
									<?php echo wp_kses( $content_box_1_element_year_title, $allowed_html_tag ); ?>
								</h4>
							<?php } ?>
						</div>
					</div>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</section>
<!-- About Us -->
