<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

global $w3construct_option;

$theme_options          = w3construct_get_theme_option();
$comingsoon_launch_date = w3construct_set( $theme_options, 'comingsoon_launch_date' );
$social_link_target     = w3construct_set( $theme_options, 'social_link_target' );
$site_logo_icon         = w3construct_set( $w3construct_option, 'site_logo_icon' );
$comingsoon_page_title  = w3construct_set( $w3construct_option, 'comingsoon_page_title' );
$comingsoon_page_url    = w3construct_set( $w3construct_option, 'comingsoon_page_url' );
$comingsoon_bg          = w3construct_set( $w3construct_option, 'comingsoon_bg' );
$allowed_html_tags      = w3construct_set( $w3construct_option, 'allowed_html_tags' );


$date = '';
if ( ! empty( $comingsoon_launch_date ) ) {
	$date = date( 'd F Y', strtotime( $comingsoon_launch_date ) );
}
?>
<div class="dz-coming-soon style-4 wow fadeIn" data-wow-duration="0.80s" data-wow-delay="0.50s">
	<div class="sidenav-menu">
		<?php if ( ! empty( $site_logo_icon ) ) { ?>
			<div class="logo">
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
					<img src="<?php echo esc_url( $site_logo_icon ); ?>" alt="<?php bloginfo( 'name' ); ?>" /></a>
			</div>
		<?php } ?>

		<ul class="dz-social-icon">
			<?php
			$social_arr = w3construct_author_social_arr();
			foreach ( $social_arr as $social_key => $social ) {

				$social_link = w3construct_get_opt( 'social_' . $social_key . '_url' );

				if ( ! empty( $social_link ) ) {
					echo wp_kses( '<li class="wow fadeInRight" data-wow-duration="1.5s" data-wow-delay="1.0s"><a href="' . esc_url( $social_link ) . '" target="' . $social_link_target . '" class="' . esc_attr( $social['text'] ) . '">' . esc_attr( $social['text'] ) . '</a></li>', w3construct_allowed_html_tag() );
				}
			}
			?>
		</ul>
	</div>
	<div class="clearfix dz-coming-bx">
		<div class="dz-content">
			<h2 class="dz-title ml2 wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="1.5s">
				<span>
					<?php echo wp_kses( $comingsoon_page_title, $allowed_html_tags ); ?>
				</span>
			</h2>
			<div class="countdown" data-date="<?php echo esc_attr( $date ); ?>">
				<div class="date wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="1.0s">
					<span class="days time"></span>
					<span>
						<?php echo esc_html__( 'Days', 'w3construct' ); ?>
					</span>
				</div>
				<div class="date wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="1.3s">
					<span class="hours time"></span>
					<span>
						<?php echo esc_html__( 'Hours', 'w3construct' ); ?>
					</span>
				</div>
				<div class="date wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="1.6s">
					<span class="mins time"></span>
					<span>
						<?php echo esc_html__( 'Minutes', 'w3construct' ); ?>
					</span>
				</div>
				<div class="date wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="1.9s">
					<span class="secs time"></span>
					<span>
						<?php echo esc_html__( 'Second', 'w3construct' ); ?>
					</span>
				</div>
			</div>
			<div class="dz-coming-btn wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="2.2s">
				<?php if ( ! empty( $comingsoon_page_url ) ) { ?>
					<a href="<?php echo esc_url( $comingsoon_page_url ); ?>"
						class="btn btn-primary openbtn m-r10 black btn-rounded">
						<?php echo esc_html__( 'GET IN TOUCH', 'w3construct' ); ?>
					</a>
				<?php } ?>

			</div>
		</div>
	</div>
	<?php if ( ! empty( $comingsoon_bg ) ) { ?>
		<div class="slider-box">
			<img src="<?php echo esc_url( $comingsoon_bg ); ?>" alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>" />
		</div>
	<?php } ?>
</div>
