<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$btn_link         = '';
$btn_text         = '';
$anchor_attribute = '';

if ( ! empty( $call_to_action_1_element_content_link_title ) ) {
	$btn_link         = ! empty( $call_to_action_1_element_content_link ) ? $call_to_action_1_element_content_link : '';
	$btn_text         = ! empty( $call_to_action_1_element_content_link_title ) ? $call_to_action_1_element_content_link_title : '';
	$anchor_attribute = w3construct_elementor_get_anchor_attribute( $btn_link );
}
?>
<section class="content-inner-2">
	<div class="container">
		<div class="row">
			<?php if ( ! empty( $call_to_action_1_element_title ) ) { ?>
				<div class="col-lg-6">
					<div class="section-head style-1">
						<h2 class="title">
							<?php echo wp_kses( $call_to_action_1_element_title, 'string' ); ?>
						</h2>
					</div>
				</div>
			<?php } ?>
			<div class="col-lg-6">
				<?php if ( ! empty( $call_to_action_1_element_description ) ) { ?>
					<p>
						<?php echo wp_kses( $call_to_action_1_element_description, w3construct_allowed_html_tag() ); ?>
					</p>
				<?php } ?>			
				<?php if ( ! empty( $btn_text ) ) { ?>
					<a href="<?php echo esc_url( $btn_link['url'] ); ?>" <?php echo esc_html( $anchor_attribute ); ?> class="btn-link style-2">
						<?php echo esc_html( $btn_text ); ?> <i class="m-l5 las la-plus"></i>
					</a>
				<?php } ?>
			</div>
		</div>
	</div>
</section>
