<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$current_page        = $GLOBALS['w3construct_query_result']['current_page'];
$posts_per_page      = $GLOBALS['w3construct_query_result']['posts_per_page'];
$current_post_number = ( ( $current_page * $posts_per_page ) - $posts_per_page ) + 1;
$show_column         = $GLOBALS['w3construct_query_result']['show_column'];
$show_share          = $GLOBALS['w3construct_query_result']['show_share'];
$posts_w3            = $GLOBALS['w3construct_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */

if ( 'column_2' === $show_column ) {
	$class = 'col-lg-6 col-sm-6';
} elseif ( 'column_3' === $show_column ) {
	$class = 'col-lg-4 col-sm-6';
} else {
	$class = 'col-lg-3 col-sm-6';
}

foreach ( $posts_w3 as $post_w3 ) {

	$post_id_w3 = $post_w3->ID;
	$post_title = ( has_post_thumbnail() ) ? w3construct_trim( $post_w3->post_title, 7 ) : $post_w3->post_title;
	$excerpt    = $post_w3->post_excerpt;
	$content    = $post_w3->post_content;

	/* implement post layout icons on listing post */
	$post_setting     = get_post_meta( $post_id_w3, '_post_settings', true );
	$author_name      = get_the_author_meta( 'display_name', $post_w3->post_author );
	$is_featured_post = isset( $post_setting['is_featured_post'] ) ? $post_setting['is_featured_post'] : 0;
	$views_arr        = get_post_meta( $post_id_w3, '_views_count' );
	$views            = ( isset( $views_arr[0] ) ) ? $views_arr[0] : 0;
	$no_image_class   = ( ! has_post_thumbnail() ) ? 'no-image-box' : '';
	$designation      = w3construct_get_post_meta( $post_id_w3, 'team_designation' );
	$team_social_data = w3construct_get_team_social_link( $post_id_w3 );
	?>
<!-- Team -->

<div id="post-<?php the_ID(); ?>" <?php echo esc_attr( post_class( $no_image_class . ' ' . $class ) ); ?>>
	<div class="dz-team style-2 text-center m-b30 overlay-shine ">
		<?php if ( has_post_thumbnail( $post_id_w3 ) ) { ?>
			<div class="dz-media" tabindex="0">
				<img src="<?php echo esc_url( get_the_post_thumbnail_url( $post_w3 ) ); ?>" alt="<?php echo esc_attr( get_the_title( $post_id_w3 ) ); ?>" >
				<?php
				if ( 'yes' === $show_share ) {
					if ( $team_social_data['any_fill'] ) {
						?>
						<ul class="team-social">
							<?php
							foreach ( $team_social_data['data'] as $key => $value ) {
								if ( ! empty( $value['url'] ) ) {
									?>
								<li>
									<a target="_blank" class="<?php echo esc_attr( $value['class'] ); ?>" href="<?php echo esc_url( $value['url'] ); ?>"></a>
								</li>
									<?php
								}
							}
							?>
						</ul>
						<?php
					}
				}
				?>
			</div>
		<?php } ?>
		<div class="dz-content m-t20">
			<h6 class="dz-position line text-primary">
				<?php echo esc_html( $designation ); ?>
			</h6>
			<h5 class="dz-name">
				<?php echo esc_html( get_the_title( $post_id_w3 ) ); ?>
			</h5>
		</div>
	</div>
</div>
	<?php
}
wp_reset_postdata();
