<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$current_page        = $GLOBALS['w3construct_query_result']['current_page'];
$posts_per_page      = $GLOBALS['w3construct_query_result']['posts_per_page'];
$current_post_number = ( ( $current_page * $posts_per_page ) - $posts_per_page ) + 1;
$title_text_limit    = $GLOBALS['w3construct_query_result']['title_text_limit'];
$show_column         = $GLOBALS['w3construct_query_result']['show_column'];
$posts_w3            = $GLOBALS['w3construct_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */

if ( 'column_2' === $show_column ) {
	$class = 'col-lg-6 col-sm-6';
} elseif ( 'column_3' === $show_column ) {
	$class = 'col-lg-4 col-sm-6';
} else {
	$class = 'col-lg-3 col-sm-6';
}

$allowed_html_tag = w3construct_allowed_html_tag();

foreach ( $posts_w3 as $post_data ) {

	$post_id_w3        = $post_data->ID;
	$post_title        = ( 0 !== $title_text_limit ) ? w3construct_trim( $post_data->post_title, $title_text_limit ) : w3construct_trim( $post_data->post_title, 8 );
	$excerpt           = $post_data->post_excerpt;
	$content           = $post_data->post_content;
	$short_description = w3construct_short_description( $excerpt, $content, $title_text_limit );
	/* implement post layout icons on listing post */
	$post_setting   = get_post_meta( $post_id_w3, '_post_settings', true );
	$no_image_class = ( ! has_post_thumbnail() ) ? 'no-image-box' : '';
	$icon_type      = w3construct_get_post_meta( $post_id_w3, 'service_icon_type' );
	$icon_type      = ( ! empty( $icon_type ) ) ? $icon_type : 'fontawesome';
	$icon           = w3construct_get_post_meta( $post_id_w3, 'service_icon_' . $icon_type );
	?>
<!-- service -->

<div id="post-<?php the_ID(); ?>" <?php echo esc_attr( post_class( $class . ' ' . $no_image_class ) ); ?> >
	<div class="icon-bx-wraper style-10 m-b30 p-a30 box-hover" data-name="1.">
		<div class="icon-bx-sm m-b20">
			<a href="javascript:void(0);" class="icon-cell">
				<div class="icon-lg">
					<span class="icon-cell text-primary">
						<?php
						if ( ( 'svg' === $icon_type ) && ! empty( $icon ) ) {

							echo wp_kses( $icon, $allowed_html_tag );
							?>
							<?php
						} else {
							?>
							<i class="<?php echo esc_attr( $icon ); ?>"></i>
							<?php
						}
						?>
					</span>
				</div>
			</a>
		</div>
		<h4 class="title m-b10"><a href="<?php echo esc_url( get_the_permalink( $post_id_w3 ) ); ?>">
				<?php echo esc_html( $post_title ); ?>
			</a>
		</h4>
		<p><?php echo esc_html( $short_description ); ?></p>
	</div>
</div>
	<?php
}
wp_reset_postdata();
