<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$current_page        = $GLOBALS['w3construct_query_result']['current_page'];
$posts_per_page      = $GLOBALS['w3construct_query_result']['posts_per_page'];
$title_text_limit    = $GLOBALS['w3construct_query_result']['title_text_limit'];
$side_bar            = $GLOBALS['w3construct_query_result']['side_bar'];
$current_post_number = ( ( $current_page * $posts_per_page ) - $posts_per_page ) + 1;


$posts_w3 = $GLOBALS['w3construct_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */

foreach ( $posts_w3 as $post_w3 ) {

	$post_id_w3        = $post_w3->ID;
	$post_title        = ( 0 !== $title_text_limit ) ? w3construct_trim( $post_w3->post_title, $title_text_limit ) : $post_w3->post_title;
	$excerpt           = $post_w3->post_excerpt;
	$content           = $post_w3->post_content;
	$short_description = ( 0 !== $title_text_limit ) ? w3construct_short_description( $excerpt, $content, $title_text_limit ) : $excerpt;

	/* implement post layout icons on listing post */
	$post_setting     = get_post_meta( $post_id_w3, '_post_settings', true );
	$author_name      = get_the_author_meta( 'display_name', $post_w3->post_author );
	$is_featured_post = isset( $post_setting['is_featured_post'] ) ? $post_setting['is_featured_post'] : 0;


	$views_arr = get_post_meta( $post_id_w3, '_views_count' );
	$views     = ( isset( $views_arr[0] ) ) ? $views_arr[0] : 0;

	$no_image_class = ( ! has_post_thumbnail() ) ? 'no-image-box' : '';
	?>

	<div id="post-<?php the_ID(); ?>" <?php echo esc_attr( post_class( 'dz-card blog-half style-1 m-b50 aos-item ' . $no_image_class ) ); ?> data-aos-duration="1000" data-aos-delay="200">

		<?php if ( has_post_thumbnail( $post_id_w3 ) ) { ?>
			<div class="dz-media">
				<?php echo get_the_post_thumbnail( $post_w3, 'w3construct_555x400' ); ?>
			</div>
			<?php
		}
		?>
		<div class="dz-info">
			<div class="dz-meta">
				<ul>
					<li class="post-date">
						<?php echo esc_html( get_the_date( '', $post_w3 ) ); ?>
					</li>
					<li class="post-user">
						<?php esc_html_e( 'By', 'w3construct' ); ?> <a
							href="<?php echo esc_url( get_author_posts_url( $post_w3->post_author ) ); ?>">
							<?php echo esc_html( $author_name ); ?>
						</a>
					</li>
				</ul>
			</div>
			<h3 class="dz-title">
				<a href="<?php echo esc_url( get_the_permalink( $post_id_w3 ) ); ?>">
					<?php echo esc_html( $post_title ); ?>
				</a>
			</h3>
			<div class="dz-post-text text">
				<p>
					<?php echo esc_html( $short_description ); ?>
				</p>
			</div>
			<a href="<?php echo esc_url( get_the_permalink( $post_id_w3 ) ); ?>" class="btn-link">
				<?php echo esc_html__( 'Read More', 'w3construct' ); ?>
			</a>
		</div>
	</div>
	<?php
}
wp_reset_postdata();
?>
