<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$current_page        = $GLOBALS['w3construct_query_result']['current_page'];
$posts_per_page      = $GLOBALS['w3construct_query_result']['posts_per_page'];
$title_text_limit    = $GLOBALS['w3construct_query_result']['title_text_limit'];
$side_bar            = $GLOBALS['w3construct_query_result']['side_bar'];
$current_post_number = ( ( $current_page * $posts_per_page ) - $posts_per_page ) + 1;
$posts_w3            = $GLOBALS['w3construct_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */

if ( 'No_Sidebar' === $side_bar ) {
	$col_classes = 'col-xl-6 col-lg-6 card-container';
} else {
	$col_classes = 'col-xl-12 col-lg-12 card-container';
}


foreach ( $posts_w3 as $post_w3 ) {

	$post_id_w3        = $post_w3->ID;
	$post_title        = ( 0 !== $title_text_limit ) ? w3construct_trim( $post_w3->post_title, $title_text_limit ) : $post_w3->post_title;
	$excerpt           = $post_w3->post_excerpt;
	$content           = $post_w3->post_content;
	$short_description = w3construct_short_description( $excerpt, $content, 40 );


	$post_layout = w3construct_dzbase()->get_meta( 'post_layout' );

	/* implement post layout icons on listing post */
	$post_setting       = get_post_meta( $post_id_w3, '_post_settings', true );
	$is_featured_post   = isset( $post_setting['is_featured_post'] ) ? $post_setting['is_featured_post'] : 0;
	$author_name        = get_the_author_meta( 'display_name', $post_w3->post_author );
	$views_arr          = get_post_meta( $post_id_w3, '_views_count' );
	$views              = ( isset( $views_arr[0] ) ) ? $views_arr[0] : 0;
	$post_type_w3_video = w3construct_dzbase()->get_meta( 'post_type_video' );
	$media_class        = ( 'video_post' === $post_layout ) ? 'post-video' : '';
	$no_image_class     = ( ! has_post_thumbnail() ) ? 'no-image-box' : '';
	?>

	<div id="post-<?php the_ID(); ?>" <?php echo esc_attr( post_class( $col_classes . ' ' . $no_image_class ) ); ?>>
		<div class="dz-card blog-grid style-1 m-b50 aos-item" data-aos-duration="1000" data-aos-delay="200">
			<?php
			if ( 'slider_post_1' === $post_layout ) {
				$post_type_w3_gallery1 = w3construct_dzbase()->get_meta( 'post_type_gallery1' );

				?>
				<div class="dz-media">

					<?php
					if ( ! empty( $post_type_w3_gallery1 ) ) {
						$post_type_w3_gallery1 = explode( ',', $post_type_w3_gallery1 );
						?>
						<div class="swiper-container post-swiper">
							<div class="swiper-wrapper">
								<?php
								foreach ( $post_type_w3_gallery1 as $image_id ) {
									?>
									<div class="swiper-slide">
										<img src="<?php echo esc_url( wp_get_attachment_image_url( $image_id, 'large' ) ); ?>"
											alt="<?php echo esc_attr__( 'Image', 'w3construct' ); ?>">
									</div>
									<?php
								}
								?>
							</div>
							<div class="prev-post-swiper-btn"><i class="la fa-angle-left"></i></div>
							<div class="next-post-swiper-btn"><i class="la fa-angle-right"></i></div>
						</div>
						<?php
					}
					?>
				</div>
				<?php
			} else {
				?>

				<?php
				if ( has_post_thumbnail( $post_id_w3 ) ) {
					?>
					<div class="dz-media <?php echo esc_attr( $media_class ); ?>">

						<a href="<?php echo esc_url( get_permalink( $post_id_w3 ) ); ?>">
							<?php echo get_the_post_thumbnail( $post_w3, 'large' ); ?>
							<?php
							if ( 'video_post' === $post_layout ) {
								if ( ! empty( $post_type_w3_video ) ) {
									$video_id   = w3construct_get_youtube_video_id( $post_type_w3_video );
									$video_link = 'https: //www.youtube.com/watch?v = ' . $video_id;
									?>
									<a href="<?php echo esc_url( $video_link ); ?>" class="popup-youtube">
										<div class="post-video-icon">
											<i class="fa fa-play"></i>
										</div>
									</a>
									<?php
								}
							}
							?>
						</a>
					</div>
					<?php
				}
			}
			?>

			<div class="dz-info">
				<div class="dz-meta">
					<ul>
						<li class="post-date">
							<?php echo esc_html( get_the_date( '', $post_w3 ) ); ?>
						</li>
						<li class="post-user">
							<?php esc_html_e( 'By', 'w3construct' ); ?> <a
								href="<?php echo esc_url( get_author_posts_url( $post_w3->post_author ) ); ?>">
								<?php echo esc_html( $author_name ); ?>
							</a>
						</li>
					</ul>
				</div>
				<h3 class="dz-title">
					<a href="<?php echo esc_url( get_the_permalink( $post_id_w3 ) ); ?>">
						<?php echo esc_html( $post_title ); ?>
					</a>
				</h3>
				<div class="dz-post-text text">
					<p>
						<?php echo esc_html( $short_description ); ?>
					</p>
				</div>
				<a href="<?php echo esc_url( get_the_permalink( $post_id_w3 ) ); ?>" class="btn-link">
					<?php echo esc_html__( 'Read More', 'w3construct' ); ?>
				</a>
			</div>
		</div>

	</div>
	<?php
}
wp_reset_postdata();

