<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$current_page        = $GLOBALS['w3construct_query_result']['current_page'];
$posts_per_page      = $GLOBALS['w3construct_query_result']['posts_per_page'];
$current_post_number = ( ( $current_page * $posts_per_page ) - $posts_per_page ) + 1;
$title_text_limit    = $GLOBALS['w3construct_query_result']['title_text_limit'];
$show_link           = $GLOBALS['w3construct_query_result']['show_link'];
$read_more_setting   = $GLOBALS['w3construct_query_result']['read_more_setting'];
$posts_w3            = $GLOBALS['w3construct_query_result']['posts']; /*NOTE - DO NOT PUT THIS LINE ABOVE OTHERWISE IT WILL GIVE NOTICE */
$allowed_html_tag    = w3construct_allowed_html_tag();


foreach ( $posts_w3 as $post_w3 ) {

	if ( $current_post_number <= 2 ) {
		$classes = 'col-lg-6 col-sm-6 m-b30';
	} else {
		$classes = 'col-lg-4 col-sm-6 m-b30';
	}

	$post_id_w3 = $post_w3->ID;
	$post_title = ( 0 !== $title_text_limit ) ? w3construct_trim( $post->post_title, 7 ) : $post->post_title;

	/* implement post layout icons on listing post */
	$post_setting     = get_post_meta( $post_id_w3, '_post_settings', true );
	$author_name      = get_the_author_meta( 'display_name', $post->post_author );
	$is_featured_post = isset( $post_setting['is_featured_post'] ) ? $post_setting['is_featured_post'] : 0;
	$cat_arr          = get_the_terms( $post_id_w3, 'portfolio-category' );
	$cat_slug_arr     = array_column( $cat_arr, 'slug' );
	$cat_slugs        = implode( ' ', $cat_slug_arr );
	$views_arr        = get_post_meta( $post_id_w3, '_views_count' );
	$views            = ( isset( $views_arr[0] ) ) ? $views_arr[0] : 0;
	$post_thumbnail   = get_the_post_thumbnail_url( $post_id_w3 );
	$no_image_class   = ( ! has_post_thumbnail( $post_id_w3 ) ) ? 'no-image-box' : '';


	?>

<!-- Portfolio -->

<div id="post-<?php echo esc_attr( $post_id_w3 ); ?>" <?php echo esc_attr( post_class( 'aos-item' . $no_image_class . ' ' . $classes ) ); ?>  data-aos-duration="1000" data-aos-delay="200">
	<div class="dz-box overlay style-2">
		<div class="dz-media" <?php if ( ! empty( $post_thumbnail ) ) { ?>
		style="background-image: url(<?php echo esc_url( $post_thumbnail ); ?>)"<?php } ?>>
			<?php if ( 'lightbox' === $read_more_setting ) { ?>
				<span tabindex="0" data-exthumbimage="<?php echo esc_url( get_the_post_thumbnail_url( $post_id_w3, 'thumbnail' ) ); ?>" data-src="<?php echo esc_url( get_the_post_thumbnail_url( $post_id_w3, 'full' ) ); ?>" class="view-btn lightimg" title="<?php echo esc_attr( $post_title ); ?>"></span>
			<?php } elseif ( 'link_to_detail' === $read_more_setting ) { ?>
					<a href="<?php echo esc_url( get_the_permalink( $post_id_w3 ) ); ?>"><span class="view-btn" title="<?php echo esc_attr( $post_title ); ?>"></span></a>
			<?php } ?>
		</div>
		<div class="dz-info">
			<span class="line"></span>
			<div>
				<h4 class="title">
					<?php if ( 'yes' === $show_link ) { ?>
						<a href="<?php echo esc_url( get_the_permalink( $post_id_w3 ) ); ?>">
							<?php echo wp_kses( get_the_title( $post_id_w3 ), 'string' ); ?>
						</a>
					<?php } else { ?>
						<a href="javascript:void(0);">
							<?php echo wp_kses( get_the_title( $post_id_w3 ), 'string' ); ?>
						</a>
					<?php } ?>
				</h4>
				<?php if ( ! empty( $cat_arr ) ) { ?>
					<h6 class="sub-title text-primary">
						<?php echo wp_kses( w3construct_get_cpt_category( $cat_arr ), $allowed_html_tag ); ?>
					</h6>
				<?php } ?>
			</div>
		</div>
	</div>
</div>
	<?php
	++$current_post_number; }
	wp_reset_postdata();
