<?php
/**
 * Helper functions for the theme: Get theme option based on its ID.
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 *
 * @param  string $opt_id Required. The option ID.
 * @param  mixed $default Optional. Default value if the option is not found or not yet saved.
 */

if ( ! function_exists( 'w3construct_get_opt' ) ) {
	/**
	 * Get a theme option based on its ID.
	 *
	 * @param string $opt_id Required. The option ID.
	 * @param mixed  $default Optional. Default value if the option is not found or not yet saved.
	 *
	 * @return mixed The value of the theme option, or the default value if not found.
	 */
	function w3construct_get_opt( $opt_id, $default = false ) {
		$opt_name = w3construct_get_opt_name();
		if ( empty( $opt_name ) ) {
			return $default;
		}
		if ( ! isset( $opt_name ) || ! isset( $opt_name[ $opt_id ] ) ) {
			$options = get_option( $opt_name );
		} else {
			$options = ${$opt_name};
		}
		if ( ! isset( $options ) || ! isset( $options[ $opt_id ] ) || '' === $options[ $opt_id ] ) {
			return $default;
		}
		if ( is_array( $options[ $opt_id ] ) && is_array( $default ) ) {
			foreach ( $options[ $opt_id ] as $key => $value ) {
				if ( isset( $default[ $key ] ) && '' === $value ) {
					$options[ $opt_id ][ $key ] = $default[ $key ];
				}
			}
		}

		return $options[ $opt_id ];
	}
}

if ( ! function_exists( 'w3construct_get_page_opt' ) ) {
	/**
	 * Get theme option based on its id.
	 *
	 * @param  string $opt_id Required. the option id.
	 * @param  mixed  $default Optional. Default if the option is not found or not yet saved.
	 *                         If not set, false will be used.
	 *
	 * @return mixed
	 */
	function w3construct_get_page_opt( $opt_id, $default = false ) {
		$page_opt_name = w3construct_get_page_opt_name();
		if ( empty( $page_opt_name ) ) {
			return $default;
		}
		$id = get_the_ID();
		if ( ! is_archive() && is_home() ) {
			if ( ! is_front_page() ) {
				$page_for_posts = get_option( 'page_for_posts' );
				$id             = $page_for_posts;
			}
		}

		$options = ! empty( $id ) ? get_post_meta( intval( $id ), $opt_id, true ) : $default;
		return $options;
	}
}

if ( ! function_exists( 'w3construct_get_post_opt' ) ) {
	/**
	 * Get theme option based on its id.
	 *
	 * @param  string $opt_id Required. the option id.
	 * @param  mixed  $default Optional. Default if the option is not found or not yet saved.
	 *                         If not set, false will be used.
	 *
	 * @return mixed
	 */
	function w3construct_get_post_opt( $opt_id, $default = false ) {
		$post_opt_name = w3construct_get_post_opt_name();
		if ( empty( $post_opt_name ) ) {
			return $default;
		}
		$id = get_the_ID();
		if ( ! is_archive() && is_home() ) {
			if ( ! is_front_page() ) {
				$page_for_posts = get_option( 'page_for_posts' );
				$id             = $page_for_posts;
			}
		}

		$options = ! empty( $id ) ? get_post_meta( intval( $id ), $opt_id, true ) : $default;
		return $options;
	}
}

if ( ! function_exists( 'w3construct_get_opt_name' ) ) {
	/**
	 * Get opt_name for Redux Framework options instance args and for
	 * getting option value.
	 *
	 * @return string
	 */
	function w3construct_get_opt_name() {
		return apply_filters( 'w3construct_opt_name', 'w3construct_theme_options' );
	}
}

if ( ! function_exists( 'w3construct_get_page_opt_name' ) ) {
	/**
	 * Get opt_name for Redux Framework options instance args and for
	 * getting option value.
	 *
	 * @return string
	 */
	function w3construct_get_page_opt_name() {
		return apply_filters( 'w3construct_page_opt_name', 'w3construct_page_options' );
	}
}

if ( ! function_exists( 'w3construct_get_post_opt_name' ) ) {
	/**
	 * Get opt_name for Redux Framework options instance args and for
	 * getting option value.
	 *
	 * @return string
	 */
	function w3construct_get_post_opt_name() {
		return apply_filters( 'w3construct_post_opt_name', 'w3construct_post_options' );
	}
}
