<?php
/**
 * Theme Information
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

if ( ! function_exists( 'w3construct_page_template_options' ) ) {
	/**
	 * W3construct_page_template_options
	 *
	 * @return array  An array containing page template options.
	 */
	function w3construct_page_template_options() {

		$page_templates = array(
			'landing'     => array(
				array(
					'title' => esc_html__( 'W3Construct Home 1', 'w3construct' ),
					'id'    => 'landing_style_1',
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/landing_style_1.png',
					'param' => array(),
				),
			),
			'coming'      => array(
				array(
					'title' => esc_html__( 'Comingsoon', 'w3construct' ),
					'id'    => 'coming_style_1',
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/coming-soon.png',
					'param' => array(),
				),
			),
			'maintenance' => array(
				array(
					'title' => esc_html__( 'Maintenance', 'w3construct' ),
					'id'    => 'maintenance_style_1',
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/site-down-for-maintain.png',
					'param' => array(),
				),
			),
			'error'       => array(
				array(
					'title' => esc_html__( 'Error', 'w3construct' ),
					'id'    => 'error_style_1',
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-template/error-404.png',
					'param' => array(),
				),
			),
		);
		return $page_templates;
	}
}

if ( ! function_exists( 'w3construct_post_layouts_options' ) ) {
	/**
	 * Function to retrieve post layouts options.
	 *
	 * This function retrieves options related to post layouts and returns them.
	 *
	 * @return array An array containing post layout options.
	 */
	function w3construct_post_layouts_options() {

		$post_layouts = array(
			array(
				'id'           => 'standard',
				'layout_param' => array(
					'title' => esc_html__( 'Standard', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-layout/standard-post.png',
				),
				'param'        => array(),
			),
		);
		return $post_layouts;
	}
}

if ( ! function_exists( 'w3construct_header_style_options' ) ) {
	/**
	 * Function to retrieve header style options.
	 *
	 * This function retrieves options related to header styles and returns them.
	 *
	 * @return array An array containing header style options.
	 */
	function w3construct_header_style_options() {
		$header_styles = array(
			array(
				'id'        => 'header-1',
				'img_param' => array(
					'title' => esc_html__( 'Style - Normal', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/header/header-1.png',
				),
				'param'     => array(
					'class'                     => '',
					'social_link'               => 0,
					'search'                    => 0,
					'call_to_action_button'     => 0,
					'social_links'              => 6,
					'top_bar'                   => 0,
					'header_theme'              => 1,
					'informative_fields_header' => 3,
				),
			),
		);
		return $header_styles;
	}
}

if ( ! function_exists( 'w3construct_footer_style_options' ) ) {
	/* Foote Layouts Options */
	/**
	 * Retrieve footer style options.
	 *
	 * This function retrieves options related to footer styles and returns them.
	 *
	 * @return array An array containing footer style options.
	 */
	function w3construct_footer_style_options() {
		$footer_styles = array(
			array(
				'title'     => esc_html__( 'Footer 1', 'w3construct' ),
				'id'        => 'footer_template_1',
				'img_param' => array(
					'title' => esc_html__( 'Footer 1', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer-1.png',
				),
				'param'     => array(
					'social_link'       => 1,
					'copyright'         => 1,
					'powered_by'        => 0,
					'sections'          => 1,
					'bg_image'          => 1,
					'informative_field' => 0,
				),
			),
			array(
				'title'     => esc_html__( 'Footer 2', 'w3construct' ),
				'id'        => 'footer_template_2',
				'img_param' => array(
					'title' => esc_html__( 'Footer 2', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/footer/footer-2.png',
				),
				'param'     => array(
					'social_link'       => 1,
					'copyright'         => 1,
					'powered_by'        => 0,
					'sections'          => 1,
					'bg_image'          => 0,
					'informative_field' => 0,
				),
			),
		);

		return $footer_styles;
	}
}

if ( ! function_exists( 'w3construct_sidebar_layout_options' ) ) {
	/* Sidebar Layouts Options*/
	/**
	 * Retrieve sidebar layout options.
	 *
	 * This function retrieves options related to sidebar layouts and returns them.
	 *
	 * @return array An array containing sidebar layout options.
	 */
	function w3construct_sidebar_layout_options() {

		$sidebar_layout = array(
			array(
				'id'            => 'full',
				'sidebar_param' => array(
					'title' => esc_html__( 'Full Width', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-full.png',
				),
				'param'         => array(),
			),
			array(
				'id'            => 'left',
				'sidebar_param' => array(
					'title' => esc_html__( 'Left Side', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-left.png',
				),
				'param'         => array(),
			),
			array(
				'id'            => 'right',
				'sidebar_param' => array(
					'title' => esc_html__( 'Right Side', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/sidebar/sidebar-right.png',
				),
				'param'         => array(),
			),
		);

		return $sidebar_layout;
	}
}

if ( ! function_exists( 'w3construct_post_wrapper_options' ) ) {
	/* Post Box/Wrapper Style Options */
	/**
	 * Retrieve post wrapper options.
	 *
	 * This function retrieves options related to post wrappers and returns them.
	 *
	 * @return array An array containing post wrapper options.
	 */
	function w3construct_post_wrapper_options() {

		$post_wrapper_layout = array(
			array(
				'id'        => 'post_box_1',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 1', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-1.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_2',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 2', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-2.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_3',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 3', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-3.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_4',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 4', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-4.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_5',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 5', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-5.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_6',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 6', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-6.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_7',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 7', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-7.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_8',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 8', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-8.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_9',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 9', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-9.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_box_10',
				'img_param' => array(
					'title' => esc_html__( 'Post Box 10', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-box/box-10.png',
				),
				'param'     => array(),
			),
		);

		return $post_wrapper_layout;
	}
}

if ( ! function_exists( 'w3construct_post_listing_options' ) ) {
	/* Post Listing Style Options */
	/**
	 * Retrieve post listing options.
	 *
	 * This function retrieves options related to post listings and returns them.
	 *
	 * @return array An array containing post listing options.
	 */
	function w3construct_post_listing_options() {
		/* post listing/collage style */
		$post_listing_layout = array(
			array(
				'id'            => 'post_listing_1',
				'listing_param' => array(
					'title' => esc_html__( 'Post Listing 1', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-1.png',
				),
				'param'         => array(),
			),
			array(
				'id'            => 'post_listing_2',
				'listing_param' => array(
					'title' => esc_html__( 'Post Listing 2', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-2.png',
				),
				'param'         => array(),
			),
			array(
				'id'            => 'team_listing_1',
				'listing_param' => array(
					'title' => esc_html__( 'Team Listing 1', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-3.png',
				),
				'param'         => array(),
			),
			array(
				'id'            => 'portfolio_listing_1',
				'listing_param' => array(
					'title' => esc_html__( 'Portfolio Listing 1', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-4.png',
				),
				'param'         => array(),
			),
			array(
				'id'            => 'service_listing_1',
				'listing_param' => array(
					'title' => esc_html__( 'Post Listing 5', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-listing/layout-5.png',
				),
				'param'         => array(),
			),
		);

		return $post_listing_layout;
	}
}

if ( ! function_exists( 'w3construct_post_tiles_options' ) ) {
	/* Post Tiles Style Options */
	/**
	 * Retrieve post tiles options.
	 *
	 * This function retrieves options related to post tiles and returns them.
	 *
	 * @return array An array containing post tiles options.
	 */
	function w3construct_post_tiles_options() {

		$post_tile_layout = array(
			array(
				'id'        => 'post_tile_1',
				'img_param' => array(
					'title' => esc_html__( 'Post Tile 1', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-tiles/post_tile-1.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'post_tile_2',
				'img_param' => array(
					'title' => esc_html__( 'Post Tile 2', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-tiles/post_tile-2.png',
				),
				'param'     => array(),
			),
		);
		return $post_tile_layout;
	}
}

if ( ! function_exists( 'w3construct_page_banner_options' ) ) {
	/* Page Banner Style Options */
	/**
	 * Retrieve post tiles options.
	 *
	 * This function retrieves options related to post tiles and returns them.
	 *
	 * @return array An array containing post tiles options.
	 */
	function w3construct_page_banner_options() {
		$page_banner_style = array(
			array(
				'id'           => 'page_banner_big',
				'banner_param' => array(
					'title' => esc_html__( 'Fit to Screen', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-big.png',
				),
				'param'        => array(),
			),
			array(
				'id'           => 'page_banner_medium',
				'banner_param' => array(
					'title' => esc_html__( 'Banner Medium', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-medium.png',
				),
				'param'        => array(),
			),
			array(
				'id'           => 'page_banner_small',
				'banner_param' => array(
					'title' => esc_html__( 'Banner Small', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-small.png',
				),
				'param'        => array(),
			),
			array(
				'id'           => 'page_banner_custom',
				'banner_param' => array(
					'title' => esc_html__( 'Custom Height', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/page-banner/page-banner-small.png',
				),
				'param'        => array(),
			),
		);
		return $page_banner_style;
	}
}

if ( ! function_exists( 'w3construct_post_banner_options' ) ) {
	/**
	 * Retrieve post banner options.
	 *
	 * This function retrieves options related to post banners and returns them as an array.
	 *
	 * @return array An array containing post banner options.
	 */
	function w3construct_post_banner_options() {
		$post_banners = array(
			array(
				'id'                => 'post_banner_v1',
				'post_banner_param' => array(
					'title' => esc_html__( 'Post Banner 1', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v1.png',
				),
				'param'             => array(
					'limit'     => array( 2, 5 ),
					'category'  => true,
					'type'      => array( 'all', 'featured', 'most-visited', 'most-liked' ),
					'post_with' => array( 'all', 'images-only', 'without' ),
				),
			),
			array(
				'id'                => 'post_banner_v2',
				'post_banner_param' => array(
					'title' => esc_html__( 'Post Banner 2', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v2.png',
				),
				'param'             => array(
					'limit'     => array( 3, 12 ),
					'category'  => true,
					'type'      => array( 'all', 'featured', 'most-visited', 'most-liked' ),
					'post_with' => array( 'all', 'images-only', 'without' ),
				),
			),
			array(
				'id'                => 'post_banner_v3',
				'post_banner_param' => array(
					'title' => esc_html__( 'Post Banner 3', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/post-banner/post-slider-v3.png',
				),
				'param'             => array(
					'limit'     => array( 3, 12 ),
					'category'  => true,
					'type'      => array( 'all', 'featured', 'most-visited', 'most-liked' ),
					'post_with' => array( 'all', 'images-only', 'without' ),
				),
			),
		);
		return $post_banners;
	}
}

if ( ! function_exists( 'w3construct_theme_layout_options' ) ) {
	/** Theme Layout Options */
	function w3construct_theme_layout_options() {
		$theme_layouts = array(
			array(
				'id'        => 'theme_layout_1',
				'img_param' => array(
					'title' => esc_html__( 'Full', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/full-width.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'theme_layout_2',
				'img_param' => array(
					'title' => esc_html__( 'Box', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/boxed.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => 'theme_layout_3',
				'img_param' => array(
					'title' => esc_html__( 'Frame', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/theme-layout/frame.png',
				),
				'param'     => array(),
			),
		);

		return $theme_layouts;
	}
}

if ( ! function_exists( 'w3construct_theme_color_background_options' ) ) {
	/** Theme Color Background Options */
	function w3construct_theme_color_background_options() {
		$theme_color_background = array(
			array(
				'id'        => '#d37b46',
				'img_param' => array(
					'title' => esc_html__( 'Brown', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/brown.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => '#76c381',
				'img_param' => array(
					'title' => esc_html__( 'Green', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/green.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => '#e281ef',
				'img_param' => array(
					'title' => esc_html__( 'Pink', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/pink.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => '#fb4848',
				'img_param' => array(
					'title' => esc_html__( 'Red', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/red.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => '#008080',
				'img_param' => array(
					'title' => esc_html__( 'Cyan', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/cyan.png',
				),
				'param'     => array(),
			),
			array(
				'id'        => '#f8ca00',
				'img_param' => array(
					'title' => esc_html__( 'Yellow', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-color/yellow.png',
				),
				'param'     => array(),
			),
		);

		return $theme_color_background;
	}
}

if ( ! function_exists( 'w3construct_theme_image_background_options' ) ) {
	/** Theme Image Background Options */
	function w3construct_theme_image_background_options() {
		$theme_image_background = array(
			array(
				'id'    => 'bg_img_1',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-image/bg_img_1.jpg',
				'param' => array(),
			),
		);

		return $theme_image_background;
	}
}

if ( ! function_exists( 'w3construct_theme_pattern_background_options' ) ) {
	/** Theme Pattern Background Options */
	function w3construct_theme_pattern_background_options() {
		$theme_pattern_background = array(
			array(
				'id'    => 'bg_pattern_1',
				'title' => esc_html__( 'Pattern Name 1', 'w3construct' ),
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/bg-pattern/bg_pattern_1.jpg',
				'param' => array(),
			),
		);

		return $theme_pattern_background;
	}
}

if ( ! function_exists( 'w3construct_theme_color_options' ) ) {
	/** Page Loader Options */
	function w3construct_theme_color_options() {
		$theme_color = array(
			array(
				'id'           => 'brown',
				'layout_param' => array(
					'title' => esc_html__( 'Standard Brown', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/sorrell-brown.png',
				),
				'color'        => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
				'param'        => array(),
			),
			array(
				'id'           => 'green',
				'layout_param' => array(
					'title' => esc_html__( 'Green', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/pistachio.png',
				),
				'color'        => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
				'param'        => array(),
			),
			array(
				'id'           => 'red',
				'layout_param' => array(
					'title' => esc_html__( 'Red', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/pink.png',
				),
				'color'        => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
				'param'        => array(),
			),
			array(
				'id'           => 'sky_blue',
				'layout_param' => array(
					'title' => esc_html__( 'Sky Blue', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/fountain_blue.png',
				),
				'color'        => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
				'param'        => array(),
			),
			array(
				'id'           => 'apricot',
				'layout_param' => array(
					'title' => esc_html__( 'Apricot', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/apricot.png',
				),
				'color'        => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
				'param'        => array(),
			),
			array(
				'id'           => 'pink',
				'layout_param' => array(
					'title' => esc_html__( 'Pink', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/orchid.png',
				),
				'color'        => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
				'param'        => array(),
			),
			array(
				'id'           => 'yellow',
				'layout_param' => array(
					'title' => esc_html__( 'Yellow', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/tulip_tree.png',
				),
				'color'        => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
				'param'        => array(),
			),
			array(
				'id'           => 'purple',
				'layout_param' => array(
					'title' => esc_html__( 'Purple', 'w3construct' ),
					'img'   => get_template_directory_uri() . '/dz-inc/assets/images/skins/true_v.png',
				),
				'color'        => array( '#5f0ee1', '#decaff', '#ffffff', '#3f3f3f', '#666666' ),
				'param'        => array(),
			),
		);
		return $theme_color;
	}
}

if ( ! function_exists( 'w3construct_page_loader_options' ) ) {
	/** Page Loader Options */
	function w3construct_page_loader_options() {
		$page_loader = array(
			array(
				'title' => esc_html__( 'Loading 1', 'w3construct' ),
				'id'    => 'loading1',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading1.gif',
				'param' => array(),
			),
			array(
				'title' => esc_html__( 'Loading 2', 'w3construct' ),
				'id'    => 'loading2',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading2.svg',
				'param' => array(),
			),
			array(
				'title' => esc_html__( 'Loading 3', 'w3construct' ),
				'id'    => 'loading3',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading3.svg',
				'param' => array(),
			),
			array(
				'title' => esc_html__( 'Loading 4', 'w3construct' ),
				'id'    => 'loading4',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading4.svg',
				'param' => array(),
			),
			array(
				'title' => esc_html__( 'Loading 5', 'w3construct' ),
				'id'    => 'loading5',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading5.svg',
				'param' => array(),
			),
			array(
				'title' => esc_html__( 'Loading 6', 'w3construct' ),
				'id'    => 'loading6',
				'img'   => get_template_directory_uri() . '/dz-inc/assets/images/loading-images/loading6.svg',
				'param' => array(),
			),
		);
		return $page_loader;
	}
}

if ( ! function_exists( 'w3construct_sort_by_options' ) ) {
	/** Sorting Options */
	function w3construct_sort_by_options() {
		$sort_by = array(
			'date_asc'     => esc_html__( 'Date ASC', 'w3construct' ),
			'date_desc'    => esc_html__( 'Date DESC', 'w3construct' ),
			'title_asc'    => esc_html__( 'Title ASC', 'w3construct' ),
			'title_desc'   => esc_html__( 'Title DESC', 'w3construct' ),
			'most_visited' => esc_html__( 'Most Visited', 'w3construct' ),
		);

		return $sort_by;
	}
}

if ( ! function_exists( 'w3construct_link_target_options' ) ) {
	/** Button Link Target Options */
	function w3construct_link_target_options() {
		$link_target = array(
			'_blank'  => esc_html__( 'Opens the link in a new tab.', 'w3construct' ),
			'_parent' => esc_html__( 'Opens the link in the parent frame.', 'w3construct' ),
			'_self'   => esc_html__( 'Open the link in the current frame.', 'w3construct' ),
			'_top'    => esc_html__( 'Opens the link in the top-most frame.', 'w3construct' ),
		);
		return $link_target;
	}
}

if ( ! function_exists( 'w3construct_adsence_size_options' ) ) {
	/** Advertisement Banner Size Options */
	function w3construct_adsence_size_options() {
		$adsence_size = array(
			'auto'       => esc_html__( 'Auto', 'w3construct' ),
			'120 x 90'   => esc_html__( '120 x 90', 'w3construct' ),
			'120 x 240'  => esc_html__( '120 x 240', 'w3construct' ),
			'120 x 600'  => esc_html__( '120 x 600', 'w3construct' ),
			'125 x 125'  => esc_html__( '125 x 125', 'w3construct' ),
			'160 x 90'   => esc_html__( '160 x 90', 'w3construct' ),
			'160 x 600'  => esc_html__( '160 x 600', 'w3construct' ),
			'180 x 90'   => esc_html__( '180 x 90', 'w3construct' ),
			'180 x 150'  => esc_html__( '180 x 150', 'w3construct' ),
			'200 x 90'   => esc_html__( '200 x 90', 'w3construct' ),
			'200 x 200'  => esc_html__( '200 x 200', 'w3construct' ),
			'234 x 60'   => esc_html__( '234 x 60', 'w3construct' ),
			'250 x 250'  => esc_html__( '250 x 250', 'w3construct' ),
			'320 x 100'  => esc_html__( '320 x 100', 'w3construct' ),
			'300 x 250'  => esc_html__( '300 x 250', 'w3construct' ),
			'300 x 600'  => esc_html__( '300 x 600', 'w3construct' ),
			'300 x 1050' => esc_html__( '300 x 1050', 'w3construct' ),
			'320 x 50'   => esc_html__( '320 x 50', 'w3construct' ),
			'336 x 280'  => esc_html__( '336 x 280', 'w3construct' ),
			'360 x 300'  => esc_html__( '360 x 300', 'w3construct' ),
			'435 x 300'  => esc_html__( '435 x 300', 'w3construct' ),
			'468 x 15'   => esc_html__( '468 x 15', 'w3construct' ),
			'468 x 60'   => esc_html__( '468 x 60', 'w3construct' ),
			'640 x 165'  => esc_html__( '640 x 165', 'w3construct' ),
			'640 x 190'  => esc_html__( '640 x 190', 'w3construct' ),
			'640 x 300'  => esc_html__( '640 x 300', 'w3construct' ),
			'728 x 15'   => esc_html__( '728 x 15', 'w3construct' ),
			'728 x 90'   => esc_html__( '728 x 90', 'w3construct' ),
			'970 x 90'   => esc_html__( '970 x 90', 'w3construct' ),
			'970 x 250'  => esc_html__( '970 x 250', 'w3construct' ),
			'240 x 400'  => esc_html__( '240 x 400 - Regional ad sizes', 'w3construct' ),
			'250 x 360'  => esc_html__( '250 x 360 - Regional ad sizes', 'w3construct' ),
			'580 x 400'  => esc_html__( '580 x 400 - Regional ad sizes', 'w3construct' ),
			'750 x 100'  => esc_html__( '750 x 100 - Regional ad sizes', 'w3construct' ),
			'750 x 200'  => esc_html__( '750 x 200 - Regional ad sizes', 'w3construct' ),
			'750 x 300'  => esc_html__( '750 x 300 - Regional ad sizes', 'w3construct' ),
			'980 x 120'  => esc_html__( '980 x 120 - Regional ad sizes', 'w3construct' ),
			'930 x 180'  => esc_html__( '930 x 180 - Regional ad sizes', 'w3construct' ),
		);

		return $adsence_size;
	}
}
if ( ! function_exists( 'w3construct_social_link_options' ) ) {
	/** Social Link Options */
	function w3construct_social_link_options() {

		$social_links = array(
			'facebook'       => array(
				'id'    => 'facebook',
				'title' => 'Facebook',
			),
			'twitter'        => array(
				'id'    => 'twitter',
				'title' => 'Twitter',
			),
			'linkedin'       => array(
				'id'    => 'linkedin',
				'title' => 'Linkedin',
			),
			'instagram'      => array(
				'id'    => 'instagram',
				'title' => 'Instagram',
			),
			'behance'        => array(
				'id'    => 'behance',
				'title' => 'Behance',
			),
			'whatsapp'       => array(
				'id'    => 'whatsapp',
				'title' => 'WhatsApp',
			),
			'skype'          => array(
				'id'    => 'skype',
				'title' => 'Skype',
			),
			'pinterest'      => array(
				'id'    => 'pinterest',
				'title' => 'Pinterest',
			),
			'vimeo'          => array(
				'id'    => 'vimeo',
				'title' => 'Vimeo',
			),
			'youtube'        => array(
				'id'    => 'youtube',
				'title' => 'Youtube',
			),
			'tumblr'         => array(
				'id'    => 'tumblr',
				'title' => 'Tumblr',
			),
			'rss'            => array(
				'id'    => 'rss',
				'title' => 'Rss',
			),
			'yelp'           => array(
				'id'    => 'yelp',
				'title' => 'Yelp',
			),
			'tripadvisor'    => array(
				'id'    => 'tripadvisor',
				'title' => 'Tripadvisor',
			),
			'blogger'        => array(
				'id'    => 'blogger',
				'title' => 'Blogger',
			),
			'delicious'      => array(
				'id'    => 'delicious',
				'title' => 'Delicious',
			),
			'digg'           => array(
				'id'    => 'digg',
				'title' => 'Digg',
			),
			'dribbble'       => array(
				'id'    => 'dribbble',
				'title' => 'Dribbble',
			),
			'flickr'         => array(
				'id'    => 'flickr',
				'title' => 'Flickr',
			),
			'lastfm'         => array(
				'id'    => 'lastfm',
				'title' => 'Lastfm',
			),
			'paypal'         => array(
				'id'    => 'paypal',
				'title' => 'Paypal',
			),
			'reddit'         => array(
				'id'    => 'reddit',
				'title' => 'Reddit',
			),
			'share'          => array(
				'id'    => 'share',
				'title' => 'Share',
			),
			'soundcloud'     => array(
				'id'    => 'soundcloud',
				'title' => 'Soundcloud',
			),
			'spotify'        => array(
				'id'    => 'spotify',
				'title' => 'Spotify',
			),
			'stack-overflow' => array(
				'id'    => 'stack-overflow',
				'title' => 'Stack Overflow',
			),
			'steam'          => array(
				'id'    => 'steam',
				'title' => 'Steam',
			),
			'stumbleupon'    => array(
				'id'    => 'stumbleupon',
				'title' => 'Stumbleupon',
			),
			'telegram'       => array(
				'id'    => 'telegram',
				'title' => 'Telegram',
			),
			'twitch'         => array(
				'id'    => 'twitch',
				'title' => 'Twitch',
			),
			'vk'             => array(
				'id'    => 'vk',
				'title' => 'VKontakte',
			),
			'windows'        => array(
				'id'    => 'windows',
				'title' => 'Windows',
			),
			'wordpress'      => array(
				'id'    => 'wordpress',
				'title' => 'WordPress',
			),
			'yahoo'          => array(
				'id'    => 'yahoo',
				'title' => 'Yahoo',
			),
		);

		return $social_links;
	}
}

if ( ! function_exists( 'w3construct_social_share_options' ) ) {
	/** Social Share Options */
	function w3construct_social_share_options() {

		$social_share = array(
			'facebook'  => array(
				'id'    => 'facebook',
				'title' => 'Facebook',
			),
			'twitter'   => array(
				'id'    => 'twitter',
				'title' => 'Twitter',
			),
			'linkedin'  => array(
				'id'    => 'linkedin',
				'title' => 'Linkedin',
			),
			'pinterest' => array(
				'id'    => 'pinterest',
				'title' => 'Pinterest',
			),
			'tumblr'    => array(
				'id'    => 'tumblr',
				'title' => 'Tumblr',
			),
			'digg'      => array(
				'id'    => 'digg',
				'title' => 'Digg',
			),
			'reddit'    => array(
				'id'    => 'reddit',
				'title' => 'Reddit',
			),
		);

		return $social_share;
	}
}

if ( ! function_exists( 'w3construct_banner_type' ) ) {
	/** Button Link Target Options */
	function w3construct_banner_type() {
		$banner_type = array(
			'image' => esc_html__( 'Image Type Banner', 'w3construct' ),
		);

		return $banner_type;
	}
}

if ( ! function_exists( 'w3construct_page_banner_layout_options' ) ) {
	/** Page Banner Layout Style Options */
	function w3construct_page_banner_layout_options() {
		/** Post listing/collage style */
		$page_banner_layout = array(
			array(
				array(
					'id'            => 'banner_layout_1',
					'listing_param' => array(
						'title' => esc_html__( 'Banner Layout 1', 'w3construct' ),
						'img'   => get_template_directory_uri() . '/dz-inc/assets/images/banner-layout/banner-layout-1.png',
					),
					'param'         => array(),
				),
				array(
					'id'            => 'banner_layout_2',
					'listing_param' => array(
						'title' => esc_html__( 'Banner Layout 2', 'w3construct' ),
						'img'   => get_template_directory_uri() . '/dz-inc/assets/images/banner-layout/banner-layout-2.png',
					),
					'param'         => array(),
				),
				array(
					'id'            => 'banner_layout_3',
					'listing_param' => array(
						'title' => esc_html__( 'Banner Layout 3', 'w3construct' ),
						'img'   => get_template_directory_uri() . '/dz-inc/assets/images/banner-layout/banner-layout-3.png',
					),
					'param'         => array(),
				),
				array(
					'id'            => 'banner_layout_4',
					'listing_param' => array(
						'title' => esc_html__( 'Banner Layout 4', 'w3construct' ),
						'img'   => get_template_directory_uri() . '/dz-inc/assets/images/banner-layout/banner-layout-4.png',
					),
					'param'         => array(),
				),
			),
		);
		return $page_banner_layout;
	}
}

