<?php
/**
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

if ( ! class_exists( 'ReduxFramework' ) ) {
	return;
}

if ( ! class_exists( 'W3Construct_Redux_Framework_Config' ) ) {

	/**
	 * This class represents the configuration for the W3Construct Redux Framework.
	 * It provides settings and options for configuring the framework.
	 */
	class W3Construct_Redux_Framework_Config {
		/**
		 * Args
		 *
		 * @var array
		 */
		public $args = array();
		/**
		 * Sections
		 *
		 * @var array
		 */
		public $sections = array();
		/**
		 * The theme property stores the theme information for this configuration.
		 * This determines the visual appearance of the application.
		 *
		 * @var string
		 */
		/**
		 * Theme
		 *
		 * @var [type]
		 */
		public $theme;
		/**
		 * Redux_framework
		 *
		 * @var [type]
		 */
		public $redux_framework;
		/**
		 * Page_template_o
		 *
		 * @var [type]
		 */
		public $page_template_options;
		/**
		 * Coming_template
		 *
		 * @var [type]
		 */
		public $coming_template_options;
		/**
		 * Maintenance_tem
		 *
		 * @var [type]
		 */
		public $maintenance_template_options;
		/**
		 * Error_template_
		 *
		 * @var [type]
		 */
		public $error_template_options;
		/**
		 * Header_style_op
		 *
		 * @var [type]
		 */
		public $header_style_options;
		/**
		 * Footer_style_op
		 *
		 * @var [type]
		 */
		public $footer_style_options;
		/**
		 * Post_layouts_op
		 *
		 * @var [type]
		 */
		public $post_layouts_options;
		/**
		 * Sidebar_layout_
		 *
		 * @var [type]
		 */
		public $sidebar_layout_options;
		/**
		 * Page_banner_opt
		 *
		 * @var [type]
		 */
		public $page_banner_options;
		/**
		 * Post_banner_opt
		 *
		 * @var [type]
		 */
		public $post_banner_options;
		/**
		 * Theme_layout_op
		 *
		 * @var [type]
		 */
		public $theme_layout_options;
		/**
		 * Theme_color_bac
		 *
		 * @var [type]
		 */
		public $theme_color_background_options;
		/**
		 * Theme_image_bac
		 *
		 * @var [type]
		 */
		public $theme_image_background_options;
		/**
		 * Theme_pattern_b
		 *
		 * @var [type]
		 */
		public $theme_pattern_background_options;
		/**
		 * Theme_color_opt
		 *
		 * @var [type]
		 */
		public $theme_color_options;
		/**
		 * Page_loader_opt
		 *
		 * @var [type]
		 */
		public $page_loader_options;
		/**
		 * Sort_by_options
		 *
		 * @var [type]
		 */
		public $sort_by_options;
		/**
		 * Link_target_opt
		 *
		 * @var [type]
		 */
		public $link_target_options;
		/**
		 * Social_link_opt
		 *
		 * @var [type]
		 */
		public $social_link_options;
		/**
		 * Banner_type
		 *
		 * @var [type]
		 */
		public $banner_type;
		/**
		 * Page_banner_lay
		 *
		 * @var [type]
		 */
		public $page_banner_layout_options;
		/**
		 * Social_share_op
		 *
		 * @var [type]
		 */
		public $social_share_options;
		/**
		 * W3construct_fontaw
		 *
		 * @var [type]
		 */
		public $w3construct_fontawesome_icon;

		/**
		 * __construct
		 */
		public function __construct() {
			/** Option Variable assigning values */
			$this->page_template_options            = w3construct_get_page_template_options();
			$this->coming_template_options          = w3construct_get_coming_template_options();
			$this->maintenance_template_options     = w3construct_get_maintenance_template_options();
			$this->header_style_options             = w3construct_get_header_style_options();
			$this->footer_style_options             = w3construct_get_footer_style_options();
			$this->post_layouts_options             = w3construct_get_post_layouts_options();
			$this->sidebar_layout_options           = w3construct_get_sidebar_layout_options();
			$this->page_banner_options              = w3construct_get_page_banner_options();
			$this->page_banner_layout_options       = w3construct_get_page_banner_layout_options();
			$this->post_banner_options              = w3construct_get_post_banner_options();
			$this->theme_layout_options             = w3construct_get_theme_layout_options();
			$this->theme_color_background_options   = w3construct_get_theme_color_background_options();
			$this->theme_image_background_options   = w3construct_get_theme_image_background_options();
			$this->theme_pattern_background_options = w3construct_get_theme_pattern_background_options();
			$this->theme_color_options              = w3construct_get_theme_color_options();
			$this->page_loader_options              = w3construct_get_page_loader_options();
			$this->sort_by_options                  = w3construct_get_sort_by_options();
			$this->link_target_options              = w3construct_get_link_target_options();
			$this->social_link_options              = w3construct_get_social_link_options();
			$this->social_share_options             = w3construct_get_social_share_options();
			$this->banner_type                      = w3construct_banner_type();
			$this->w3construct_fontawesome_icon     = w3construct_get_fontawesome_icon();
			/** End Option Variable assigning values */

			/* Just for demo purposes. Not needed per say. */
			$this->theme = wp_get_theme();

			/* Set the default arguments */
			$this->set_arguments();

			/* array of widgets */
			$this->w3construct_get_wp_widgets();

			/* Create the sections and fields */
			$this->set_sections();

			/* default theme options */
			if ( ! isset( $this->args['opt_name'] ) ) { /* No errors please */
				return;
			}
			$this->redux_framework = new ReduxFramework( $this->sections, $this->args );
		}

		/**
		 * All the possible arguments for Redux.
		 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
		 */
		public function set_arguments() {
			$theme    = wp_get_theme(); /* For use with some settings. Not necessary. */
			$opt_name = w3construct_get_opt_name();

			$this->args = array(

				/* TYPICAL -> Change these values as you need/desire */
				'opt_name'             => $opt_name,
				/* This is where your data is stored in the database and also becomes your global variable name. */
				'display_name'         => $theme->get( 'Name' ),
				/* Name that appears at the top of your panel */
				'display_version'      => $theme->get( 'Version' ),
				/* Version that appears at the top of your panel */
				'menu_type'            => class_exists( 'W3Construct_Menu_Handle' ) ? 'submenu' : 'menu',
				/* Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only) */
				'allow_sub_menu'       => true,
				/* Show the sections below the admin menu item or not */
				'menu_title'           => esc_html__( 'Theme Options', 'w3construct' ),
				'page_title'           => esc_html__( 'Theme Options', 'w3construct' ),

				/*
				* You will need to generate a Google API key to use this feature.
				* Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
				*/
				'google_api_key'       => '',
				/* Set it you want google fonts to update weekly. A google_api_key value is required. */
				'google_update_weekly' => false,
				/* Must be defined to add google fonts to the typography module */
				'async_typography'     => false,

				/*
				* Use a asynchronous font on the front end or font string.
				* 'disable_google_fonts_link' => true,  Disable this in case you want to create your own google fonts loader
				*/
				'admin_bar'            => false,
				/* Show the panel pages on the admin bar */
				'admin_bar_icon'       => 'dashicons-admin-generic',
				/* Choose an icon for the admin bar menu */
				'admin_bar_priority'   => 50,
				/* Choose an priority for the admin bar menu */
				'global_variable'      => '',
				/* Set a different name for your global variable other than the opt_name */
				'dev_mode'             => true,
				/* Show the time the page took to load, etc */
				'update_notice'        => true,
				/* If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo */
				'customizer'           => false,

				/*
				* Enable basic customizer support
				* 'open_expanded'     => true, Allow you to start the panel in an expanded way initially.
				* 'disable_save_warn' => true, Disable the save warning when a user changes a field
				*/
				'show_options_object'  => false,
				/* OPTIONAL -> Give you extra features */
				'page_priority'        => null,
				/* Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning. */
				'page_parent'          => class_exists( 'W3Construct_Menu_Handle' ) ? $theme->get( 'TextDomain' ) : '',
				/* For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters */
				'page_permissions'     => 'manage_options',
				/* Permissions needed to access the options panel. */
				'menu_icon'            => '',
				/* Specify a custom URL to an icon */
				'last_tab'             => '',
				/* Force your panel to always open to a specific tab (by id) */
				'page_icon'            => 'icon-themes',
				/* Icon displayed in the admin panel next to your menu_title */
				'page_slug'            => 'theme-options',
				/* Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided */
				'save_defaults'        => true,
				/* On load save the defaults to DB before user clicks save or not */
				'default_show'         => false,
				/* If true, shows the default value next to each field that is not the default value. */
				'default_mark'         => '',
				/* What to print by the field's title if the value shown is default. Suggested: * */
				'show_import_export'   => true,

				/**
				 * Shows the Import/Export panel when not used as a field.
				 * CAREFUL -> These options are for advanced use only
				 */
				'transient_time'       => 60 * MINUTE_IN_SECONDS,
				'output'               => true,
				/* Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output */
				'output_tag'           => false,

				/**
				* Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
				* 'footer_credit'     => '',   Disable the footer credit of Redux. Please leave if you can help it.
				* FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
				*/
				'database'             => '',
				/* possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning! */
				'use_cdn'              => true,

				/*
				* If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
				* HINTS
				*/
				'hints'                => array(
					'icon'          => 'el el-question-sign',
					'icon_position' => 'right',
					'icon_color'    => '#1085e4',
					'icon_size'     => '10',
					'tip_style'     => array(
						'color'   => '#1085e4',
						'shadow'  => true,
						'rounded' => false,
						'style'   => '',
					),
					'tip_position'  => array(
						'my' => 'top left',
						'at' => 'bottom right',
					),
					'tip_effect'    => array(
						'show' => array(
							'effect'   => 'slide',
							'duration' => '500',
							'event'    => 'mouseover',
						),
						'hide' => array(
							'effect'   => 'slide',
							'duration' => '500',
							'event'    => 'click mouseleave',
						),
					),
				),
				'templates_path'       => class_exists( 'DzThemeSupport' ) ? DZ_TH_ROOT . 'templates/redux/' : '',
			);
		}

		/**
		 * Retrieves the widgets in progress for a custom widget list query.
		 *
		 * @return array An array of widgets in progress.
		 */
		public function w3construct_get_wp_widgets_in_progress() {

			global $wpdb;
			$table       = $wpdb->prefix . 'options';
			$attr_prefix = 'widget_';
			$result      = $wpdb->get_row(
				$wpdb->prepare(
					"SELECT `option_id`, `option_name` FROM %s WHERE `option_name` LIKE %s AND `option_name` !== 'sidebars_widgets' ORDER BY `option_id` ASC",
					$table,
					'%' . $wpdb->esc_like( $attr_prefix ) . '%' // Properly escape and include wildcards.
				)
			);
			$all_widgets = array();

			foreach ( $result as $widget ) {
				$all_widgets[ $widget->option_name ] = ucwords( str_replace( '_', ' ', $widget->option_name ) );
			}

			return $all_widgets;
		}

		/**
		 * Escapes a SQL name.
		 *
		 * @param string $name The SQL name to escape.
		 * @return str_replace The escaped SQL name.
		 */
		public function esc_sql_name( $name ) {
			return str_replace( "'", ' ', $name );
		}

		/**
		 * W3construct_get_wp_widgets
		 *
		 * @return $all_widgets
		 */
		public function w3construct_get_wp_widgets() {
			global $wpdb;
			$attr_prefix = 'widget_';

			$result      = $wpdb->get_results(
				$wpdb->prepare(
					"SELECT `option_id`, `option_name` FROM {$wpdb->prefix}options WHERE `option_name` LIKE %s AND `option_name` != 'sidebars_widgets' ORDER BY `option_id` ASC",
					'%' . $attr_prefix . '%' // Properly escape and include wildcards.
				)
			);
			$all_widgets = array();

			foreach ( $result as $widget ) {
				$all_widgets[ $widget->option_name ] = ucwords( str_replace( '_', ' ', $widget->option_name ) );
			}
			return $all_widgets;
		}

		/**
		 * All the possible sections for Redux.
		 */
		public function set_sections() {

			/**
			* 1. General Settings
			*/
			$this->sections[] = array(
				'title'  => esc_html__( 'General Settings', 'w3construct' ),
				'desc'   => esc_html__( 'General Settings is a global setting that will affects all the pages of you website. From here you can make changes globaly. The setting will apply if there is no individual sttings.', 'w3construct' ),
				'icon'   => 'el-icon-home',
				'fields' => array(
					array(
						'id'       => 'website_status',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Website Status', 'w3construct' ),
						'subtitle' => esc_html__( 'Clock on the option tabs to change the status of your website.', 'w3construct' ),
						'desc'     => esc_html__( 'Select option tabs to change the status.', 'w3construct' ),
						'options'  => array(
							'live_mode'        => esc_html__( 'Live', 'w3construct' ),
							'comingsoon_mode'  => esc_html__( 'Coming Soon', 'w3construct' ),
							'maintenance_mode' => esc_html__( 'Site Down For Maintenance', 'w3construct' ),
						),
						'default'  => 'live_mode',
						'hint'     => array(
							'title'   => esc_html__( 'Status', 'w3construct' ),
							'content' => esc_html__( '1. Live status indicate that your website is available and operational.', 'w3construct' ) . '<br><br>' . esc_html__( '2. Coming Soon status show your website visitors that you are working on your website for making it better.', 'w3construct' ) . '<br><br>' . esc_html__( '3. Maintenance mode show your website visitors that you are working on your website for making it better.', 'w3construct' ),
						),
					),

					array(
						'id'       => 'coming_soon_template',
						'type'     => 'image_select',
						'height'   => '100',
						'title'    => esc_html__( 'Coming Soon Template', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose the template for Coming Soon page. (Default : 1).', 'w3construct' ),
						'desc'     => esc_html__( 'Click on the icon to change the template.', 'w3construct' ),
						'options'  => $this->coming_template_options,
						'default'  => 'coming_style_1',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'comingsoon_mode',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Hint Title', 'w3construct' ),
							'content' => esc_html__( 'Choose the coming soon template design as you want to show.', 'w3construct' ),
						),
					),
					array(
						'id'       => 'comingsoon_launch_date',
						'type'     => 'date',
						'title'    => esc_html__( 'Coming soon Date', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'comingsoon_mode',
						),
					),
					array(
						'id'       => 'comingsoon_bg',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Coming Soon Page Background', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'comingsoon_mode',
						),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/bg8.jpg',
						),
					),
					array(
						'id'       => 'comingsoon_page_title',
						'type'     => 'text',
						'title'    => esc_html__( 'Comingsoon Soon Page Title', 'w3construct' ),
						'desc'     => esc_html__( 'Default Comingsoon Soon page title.', 'w3construct' ),
						'default'  => 'WE ARE DOING GREAT, <br>ALMOST DONE...',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'comingsoon_mode',
						),
					),
					array(
						'id'       => 'comingsoon_page_url',
						'type'     => 'text',
						'url'      => true,
						'title'    => esc_html__( 'Comingsoon Soon Page Button Url', 'w3construct' ),
						'desc'     => esc_html__( 'Enter Comingsoon Soon Page Button Url', 'w3construct' ),
						'default'  => '',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'comingsoon_mode',
						),
					),

					array(
						'id'       => 'maintenance_template',
						'type'     => 'image_select',
						'height'   => '100',
						'title'    => esc_html__( 'Maintenance Template', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose the template for Maintenance page. (Default : 1).', 'w3construct' ),
						'desc'     => esc_html__( 'Click on the icon to change the template.', 'w3construct' ),
						'options'  => $this->maintenance_template_options,
						'default'  => 'maintenance_style_1',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'maintenance_mode',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Hint Title', 'w3construct' ),
							'content' => esc_html__( 'Choose the maintenance template design as you want to show.', 'w3construct' ),
						),
					),

					array(
						'id'       => 'maintenance_bg',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Background Image', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'maintenance_mode',
						),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/under-construct.jpg',
						),
					),
					array(
						'id'       => 'maintenance_icon',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Maintenance Icon', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'maintenance_mode',
						),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/logo.png',
						),
					),
					array(
						'id'       => 'maintenance_title',
						'type'     => 'textarea',
						'title'    => esc_html__( 'Maintenance Page Title', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'maintenance_mode',
						),
						'default'  => esc_html__( 'Site Is Down', 'w3construct' ) . ' <br/>' . esc_html__( 'For Maintenance', 'w3construct' ),
					),
					array(
						'id'       => 'maintenance_desc',
						'type'     => 'textarea',
						'title'    => esc_html__( 'Maintenance Page Description', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'maintenance_mode',
						),
						'default'  => esc_html__( 'This is the Technical Problems Page.', 'w3construct' ) . ' <br/>' . esc_html__( 'Or any other page.', 'w3construct' ),
					),
					array(
						'id'       => 'logo_type',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Logo Type', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose the logo type', 'w3construct' ),
						'desc'     => esc_html__( 'Click o the tab to change the logo type.', 'w3construct' ),
						'options'  => array(
							'image_logo' => esc_html__( 'Image Logo', 'w3construct' ),
							'text_logo'  => esc_html__( 'Text Logo', 'w3construct' ),
						),
						'default'  => 'image_logo',
						'hint'     => array(
							'title'   => esc_html__( 'Choose Logo Type:', 'w3construct' ),
							'content' => esc_html__( '1. Image Logo will be the .pmg / .jpg type. This setting affects all the site pages.', 'w3construct' ) . '<br><br>' . esc_html__( '2. Text Logo will the text type. This setting affects all the site pages.', 'w3construct' ),
						),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'blog_page_title',
						'type'     => 'text',
						'title'    => esc_html__( 'Blog Page Title', 'w3construct' ),
						'desc'     => esc_html__( 'Default blog page title.', 'w3construct' ),
						'default'  => esc_html__( 'Blog', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'page_loading_on',
						'type'     => 'switch',
						'title'    => esc_html__( 'Page Loading', 'w3construct' ),
						'subtitle' => esc_html__( 'Click on the tab to Enable / Disable the page loading setting.', 'w3construct' ),
						'desc'     => esc_html__( 'Once you click on disable, This setting affects all the site pages.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => false,
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),

					array(
						'id'       => 'show_social_icon',
						'type'     => 'switch',
						'title'    => esc_html__( 'Social Icon', 'w3construct' ),
						'subtitle' => esc_html__( 'Click on the tab to Enable / Disable the social icon setting.', 'w3construct' ),
						'desc'     => esc_html__( 'Once you click on disable, This setting affects all the site pages.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => false,
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'show_breadcrumb',
						'type'     => 'switch',
						'title'    => esc_html__( 'Breadcrumb Area', 'w3construct' ),
						'subtitle' => esc_html__( 'Click on the tab to Enable / Disable the website breadcrumb.', 'w3construct' ),
						'desc'     => esc_html__( 'Once you click on disable, This setting affects all the site pages.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => true,
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Select Breadcrumb Area:', 'w3construct' ),
							'content' => esc_html__( 'This breadcrumb option only works when page level banner Theme Settings option selected. This option will not work when custom settings selected.', 'w3construct' ),
						),
					),
					array(
						'id'       => 'show_login_registration',
						'type'     => 'switch',
						'title'    => esc_html__( 'Login / Register', 'w3construct' ),
						'subtitle' => esc_html__( 'Click on the tab to Enable / Disable the login / register button / likns.', 'w3construct' ),
						'desc'     => esc_html__( 'Once you click on disable, This setting affects all the site pages.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => false,
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Login/Register Visible', 'w3construct' ),
							'content' => esc_html__( 'This is show in top bar.', 'w3construct' ),
						),
					),
					array(
						'id'       => 'show_sidebar',
						'type'     => 'switch',
						'title'    => esc_html__( 'Sidebar', 'w3construct' ),
						'subtitle' => esc_html__( 'Click on the tab to Enable / Disable the sidebar.', 'w3construct' ),
						'desc'     => esc_html__( 'Once you click on disable, This setting affects all the site pages.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => true,
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'map_api_key',
						'type'     => 'text',
						'title'    => esc_html__( 'Map Api Key', 'w3construct' ),
						'desc'     => esc_html__( 'Input an API key to enable map.', 'w3construct' ),
						'default'  => '',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_phone_icon',
						'type'     => 'text',
						'url'      => true,
						'title'    => esc_html__( 'Site Phone Icon', 'w3construct' ),
						'default'  => 'las la-phone-volume',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_phone_title',
						'type'     => 'text',
						'title'    => esc_html__( 'Site Phone Title', 'w3construct' ),
						'subtitle' => esc_html__( 'Show in header top ', 'w3construct' ),
						'default'  => esc_html__( 'Call Now ', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_phone_number',
						'type'     => 'textarea',
						'title'    => esc_html__( 'Phone Number', 'w3construct' ),
						'subtitle' => esc_html__( 'Show in header top ', 'w3construct' ),
						'default'  => '+91-1234567890',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_address_icon',
						'type'     => 'text',
						'url'      => true,
						'title'    => esc_html__( 'Site Address Icon', 'w3construct' ),
						'default'  => 'las la-map-marker',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_address_title',
						'type'     => 'text',
						'title'    => esc_html__( 'Site Address Title', 'w3construct' ),
						'subtitle' => esc_html__( 'Show in header top ', 'w3construct' ),
						'default'  => esc_html__( 'Location', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_address',
						'type'     => 'textarea',
						'title'    => esc_html__( 'Address', 'w3construct' ),
						'subtitle' => esc_html__( 'Show in header top ', 'w3construct' ),
						'default'  => '6701 Democracy Blvd, Suite 300, USA',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_email_icon',
						'type'     => 'text',
						'url'      => true,
						'title'    => esc_html__( 'Site Email Icon', 'w3construct' ),
						'default'  => 'las la-envelope-open',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_email_title',
						'type'     => 'text',
						'title'    => esc_html__( 'Site Email Title', 'w3construct' ),
						'subtitle' => esc_html__( 'Show in header top ', 'w3construct' ),
						'default'  => esc_html__( 'Email', 'w3construct' ),
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
					array(
						'id'       => 'site_email',
						'type'     => 'textarea',
						'title'    => esc_html__( 'Email', 'w3construct' ),
						'subtitle' => esc_html__( 'Show in header top ', 'w3construct' ),
						'default'  => 'info@example.com',
						'required' => array(
							0 => 'website_status',
							1 => 'equals',
							2 => 'live_mode',
						),
					),
				),
			);

			/**--------------------------------------------------------------
			* 2. Logo Settings
			/*--------------------------------------------------------------*/
			$this->sections[] = array(
				'title'  => esc_html__( 'Logo Settings', 'w3construct' ),
				'icon'   => 'el el-cog-alt',
				'fields' => array(
					array(
						'id'       => 'favicon',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Favicon', 'w3construct' ),
						'subtitle' => esc_html__( 'Select favicon image.', 'w3construct' ),
						'desc'     => esc_html__( 'Upload favicon image.', 'w3construct' ),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/favicon.png',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Favicon', 'w3construct' ),
							'content' => esc_html__( 'From here you can upload an image. This setting affects all the site pages.', 'w3construct' ),
						),
					),
					array(
						'id'       => 'logo_text',
						'type'     => 'text',
						'title'    => esc_html__( 'Logo Text', 'w3construct' ),
						'subtitle' => esc_html__( 'Name your text logo.', 'w3construct' ),
						'default'  => get_bloginfo( 'name' ),
					),
					array(
						'id'       => 'tag_line',
						'type'     => 'text',
						'title'    => esc_html__( 'Tag Line', 'w3construct' ),
						'subtitle' => esc_html__( 'Name a tagline for the text logo.', 'w3construct' ),
						'default'  => get_bloginfo( 'description' ),
					),
					array(
						'id'       => 'logo_title',
						'type'     => 'text',
						'title'    => esc_html__( 'Logo Title', 'w3construct' ),
						'subtitle' => esc_html__( 'Title attribute for the logo. This attribute specifies extra information about the logo. Most browsers will show a tooltip with this text on logo hover.', 'w3construct' ),
						'default'  => get_bloginfo( 'name' ),
					),
					array(
						'id'       => 'logo_alt',
						'type'     => 'text',
						'title'    => esc_html__( 'Logo Alt', 'w3construct' ),
						'subtitle' => esc_html__( 'Alt attribute for the logo. This is the alternative text if the logo cannot be displayed. It`s useful for SEO and generally is the name of the site.', 'w3construct' ),
						'default'  => get_bloginfo( 'name' ),
					),
					array(
						'id'     => 'logo-section-start',
						'type'   => 'section',
						'title'  => esc_html__( 'Site Logo Setting', 'w3construct' ),
						'indent' => true,
					),
					array(
						'id'       => 'site_logo_icon',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Logo Icon', 'w3construct' ),
						'subtitle' => esc_html__( 'Upload your logo Icon(272 x 90px) .png or .jpg', 'w3construct' ),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/logo-icon.png',
						),
					),
					array(
						'id'       => 'site_logo',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Logo', 'w3construct' ),
						'subtitle' => esc_html__( 'Upload your logo (272 x 90px) .png or .jpg', 'w3construct' ),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/logo.png',
						),
					),
					array(
						'id'       => 'site_other_logo',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Other Logo', 'w3construct' ),
						'subtitle' => esc_html__( 'Upload your logo (272 x 90px) .png or .jpg', 'w3construct' ),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/logo-white.png',
						),
					),
					array(
						'id'     => 'logo-section-end',
						'type'   => 'section',
						'indent' => false,
					),
				),
			);

			/**--------------------------------------------------------------
			* 3. Header Settings
			/*--------------------------------------------------------------*/
			$header_social_links    = array();
			$header_social_defaults = array();

			foreach ( $this->social_link_options as $social_link ) {

				$link_value = w3construct_get_opt( 'social_' . $social_link['id'] . '_url' );

				if ( ! empty( $link_value ) ) {
					$header_social_links[ $social_link['id'] ]    = $social_link['title'];
					$header_social_defaults[ $social_link['id'] ] = false;
				}
			}

			$header_style_options          = w3construct_header_style_options();
			$header_aditional_array        = array();
			$mobile_header_aditional_array = array();
			foreach ( $header_style_options as $header ) {
				$header_id                = $header['id'];
				$header_social_defaults_1 = $header_social_defaults;
				$header_search_on         = w3construct_set( $header['param'], 'search', false );
				$social_link              = w3construct_set( $header['param'], 'social_link', false );
				$header_top_bar           = w3construct_set( $header['param'], 'top_bar', false );
				$header_location_on       = w3construct_set( $header['param'], 'location', false );
				$call_to_action_button    = w3construct_set( $header['param'], 'call_to_action_button', 0 );
				$total_links              = w3construct_set( $header['param'], 'social_links', 0 );
				if ( $total_links > 0 ) {
					$i = 1;
					foreach ( $header_social_links as $key => $value ) {
						if ( $i <= $total_links ) {
							$header_social_defaults_1[ $key ] = 1;
						} else {
							$header_social_defaults_1[ $key ] = 0;
						}
						$i++;
					}
				}
				$header_aditional_array[] = array(
					'id'       => $header_id . '_information',
					'type'     => 'info',
					'style'    => 'success',
					'title'    => esc_html__( 'Header Information!', 'w3construct' ),
					'icon'     => 'el-icon-info-sign',
					'desc'     => $header_id . ' ' . esc_html__( 'header settings display here.', 'w3construct' ),
					'required' => array(
						0 => 'header_style',
						1 => 'equals',
						2 => $header_id,
					),
				);

				if ( $header_top_bar > 0 ) {
					$header_aditional_array[] = array(
						'id'       => $header_id . '_top_bar_on',
						'type'     => 'switch',
						'title'    => esc_html__( 'Top Bar', 'w3construct' ),
						'subtitle' => esc_html__( 'Show or hide the top bar.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => $header_top_bar,
						'required' => array(
							0 => 'header_style',
							1 => 'equals',
							2 => $header_id,
						),
					);
				}
				$header_aditional_array[] = array(
					'id'       => $header_id . '_social_link_on',
					'type'     => 'switch',
					'title'    => esc_html__( 'Social Link', 'w3construct' ),
					'subtitle' => esc_html__( 'Show or hide the hader social link option.', 'w3construct' ),
					'on'       => esc_html__( 'Enabled', 'w3construct' ),
					'off'      => esc_html__( 'Disabled', 'w3construct' ),
					'default'  => $social_link,
					'required' => array(
						array(
							0 => 'header_style',
							1 => 'equals',
							2 => $header_id,
						),
					),
				);

				if ( ! empty( $header_social_links ) ) {
					$header_aditional_array[] = array(
						'id'       => $header_id . '_social_links',
						'type'     => 'checkbox',
						'title'    => esc_html__( 'Choose for this Header', 'w3construct' ),
						'subtitle' => esc_html__( 'No validation ca	n be done on this field type', 'w3construct' ),
						'desc'     => esc_html__( 'This is the description field, again good for additional info.', 'w3construct' ),
						/* Must provide key => value pairs for multi checkbox options */
						'options'  => $header_social_links,
						/* See how std has changed? you also don't need to specify opts that are 0. */
						'default'  => $header_social_defaults_1,
						'required' => array(
							array(
								0 => 'header_style',
								1 => 'equals',
								2 => $header_id,
							),
							array(
								0 => $header_id . '_social_link_on',
								1 => 'equals',
								2 => 1,
							),
						),
					);
				}
				if ( $call_to_action_button > 0 ) {
					for ( $i = 1; $i <= $call_to_action_button; $i++ ) {
						$header_aditional_array[] = array(
							'id'       => $header_id . '_button_' . $i . '_text',
							'type'     => 'text',
							'title'    => esc_html__( 'Button ', 'w3construct' ) . $i . esc_html__( ' Text', 'w3construct' ),
							'default'  => '',
							'required' => array(
								0 => 'header_style',
								1 => 'equals',
								2 => $header_id,
							),
						);
						$header_aditional_array[] = array(
							'id'       => $header_id . '_button_' . $i . '_url',
							'type'     => 'text',
							'title'    => esc_html__( 'Button ', 'w3construct' ) . $i . esc_html__( ' URL', 'w3construct' ),
							'default'  => '',
							'required' => array(
								0 => 'header_style',
								1 => 'equals',
								2 => $header_id,
							),
						);
						$header_aditional_array[] = array(
							'id'       => $header_id . '_button_' . $i . '_target',
							'type'     => 'select',
							'title'    => esc_html__( 'Choose Button ', 'w3construct' ) . $i . esc_html__( ' Target', 'w3construct' ),
							'options'  => $this->link_target_options,
							'default'  => '_self',
							'required' => array(
								0 => 'header_style',
								1 => 'equals',
								2 => $header_id,
							),
						);
					}
				}

				$mobile_header_aditional_array[] = array(
					'id'       => $header_id . '_mobile_social_link_on',
					'type'     => 'switch',
					'title'    => esc_html__( 'Header Social Link', 'w3construct' ),
					'subtitle' => esc_html__( 'Show or hide the hader social link option.', 'w3construct' ),
					'on'       => esc_html__( 'Enabled', 'w3construct' ),
					'off'      => esc_html__( 'Disabled', 'w3construct' ),
					'default'  => $social_link,
					'required' => array(
						0 => 'header_style',
						1 => 'equals',
						2 => $header_id,
					),
				);

				/******Header Related Fields */
			}

			$header_default_option = array(
				'title'  => esc_html__( 'Header Settings', 'w3construct' ),
				'desc'   => esc_html__( 'Describe header settings here.....................', 'w3construct' ),
				'icon'   => 'fa fa-header',
				'fields' => array(
					array(
						'id'       => 'header_style',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Header Style', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose header style. White header is set as default header for all theme.', 'w3construct' ),
						'options'  => $this->header_style_options,
						'default'  => 'header-1',
						'hint'     => array(
							array(
								'title'   => 'Hint Title',
								'content' => esc_html__( 'This is the content of the tool-tip', 'w3construct' ),
							),
						),
					),

					array(
						'id'       => 'header_about_on',
						'type'     => 'switch',
						'title'    => esc_html__( 'About Section', 'w3construct' ),
						'subtitle' => esc_html__( 'Show or hide the About Section.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => false,
					),
					array(
						'id'       => 'header_about_title',
						'type'     => 'text',
						'title'    => esc_html__( 'About Title', 'w3construct' ),
						'default'  => esc_html__( 'ABOUT US', 'w3construct' ),
						'required' => array(
							0 => 'header_about_on',
							1 => 'equals',
							2 => 1,
						),
					),

					array(
						'id'       => 'header_about_desc',
						'type'     => 'textarea',
						'title'    => esc_html__( 'About Description', 'w3construct' ),
						'default'  => esc_html__( 'Aliquam erat volutpat. Nunc erat massa, porttitor vel egestas sit amet, tristique at massa. Donec posuere odio neque, in ultricies lorem aliquet eu. Donec venenatis libero a nulla placerat egestas.', 'w3construct' ),
						'required' => array(
							0 => 'header_about_on',
							1 => 'equals',
							2 => 1,
						),
					),
					array(
						'id'       => 'header_about_url',
						'type'     => 'text',
						'title'    => esc_html__( 'About Button Url', 'w3construct' ),
						'default'  => '',
						'required' => array(
							0 => 'header_about_on',
							1 => 'equals',
							2 => 1,
						),
					),
					array(
						'id'       => 'header_sticky_on',
						'type'     => 'switch',
						'title'    => esc_html__( 'Sticky Header', 'w3construct' ),
						'subtitle' => esc_html__( 'Header will be sticked when applicable.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => false,
					),
					array(
						'id'     => 'mobile_section_start',
						'type'   => 'section',
						'title'  => esc_html__( 'Mobile Device Options', 'w3construct' ),
						'indent' => false,
					),
					array(
						'id'       => 'mobile_header_login_on',
						'type'     => 'switch',
						'title'    => esc_html__( 'Login', 'w3construct' ),
						'subtitle' => esc_html__( 'Show or hide the header login option.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => false,
					),
					array(
						'id'       => 'mobile_header_register_on',
						'type'     => 'switch',
						'title'    => esc_html__( 'Register', 'w3construct' ),
						'subtitle' => esc_html__( 'Show or hide the header register option.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => false,
					),
				),
			);

			array_splice( $header_default_option['fields'], 5, 0, $header_aditional_array );
			$mobile_field_position = count( $header_default_option['fields'] );
			array_splice( $header_default_option['fields'], $mobile_field_position, 0, $mobile_header_aditional_array );

			$this->sections[] = $header_default_option;

			/**--------------------------------------------------------------
			* 4. Footer
			/*--------------------------------------------------------------*/
			$all_widgets             = $this->w3construct_get_wp_widgets();
			$footer_setting_fields[] = array(
				'id'      => 'footer_on',
				'type'    => 'switch',
				'title'   => esc_html__( 'Footer', 'w3construct' ),
				'on'      => esc_html__( 'Enabled', 'w3construct' ),
				'off'     => esc_html__( 'Disabled', 'w3construct' ),
				'default' => true,
			);

			$footer_setting_fields[] = array(
				'id'       => 'footer_style',
				'type'     => 'image_select',
				'title'    => esc_html__( 'Footer Template', 'w3construct' ),
				'subtitle' => esc_html__( 'Choose a template for the footer.', 'w3construct' ),
				'options'  => $this->footer_style_options,
				'default'  => 'footer_template_2',
				'required' => array(
					0 => 'footer_on',
					1 => 'equals',
					2 => '1',
				),
			);

			$footer_setting_fields[]     = array(
				'id'       => 'footer_top_on',
				'type'     => 'switch',
				'title'    => esc_html__( 'Footer Top On', 'w3construct' ),
				'on'       => esc_html__( 'Enabled', 'w3construct' ),
				'off'      => esc_html__( 'Disabled', 'w3construct' ),
				'default'  => false,
				'required' => array(
					0 => 'footer_style',
					1 => 'equals',
					2 => 'footer_template_3',
				),
			);
			$footer_setting_fields[]     = array(
				'id'       => 'footer_bottom_on',
				'type'     => 'switch',
				'title'    => esc_html__( 'Footer Bottom On', 'w3construct' ),
				'on'       => esc_html__( 'Enabled', 'w3construct' ),
				'off'      => esc_html__( 'Disabled', 'w3construct' ),
				'default'  => false,
				'required' => array(
					0 => 'footer_style',
					1 => 'equals',
					2 => 'footer_template_3',
				),
			);
			$footer_style_options        = w3construct_footer_style_options();
			$total_footer                = count( $this->footer_style_options );
			$footer_block                = array();
			$footer_block['All Widgets'] = $all_widgets;

			foreach ( $footer_style_options as $key => $footer ) {
				$footer_id          = $footer['id'];
				$informative_fields = w3construct_set( $footer['param'], 'informative_field', 0 );
				$bg_image           = w3construct_set( $footer['param'], 'bg_image', 0 );
				if ( $bg_image > 0 ) {
					$footer_setting_fields[] = array(
						'id'       => $footer_id . '_bg_image',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Footer Image', 'w3construct' ),
						'subtitle' => esc_html__( 'Show or hide the image.', 'w3construct' ),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/background/pattern3.png',
						),
						'required' => array(
							0 => 'footer_style',
							1 => 'equals',
							2 => $footer_id,
						),
					);
				}

				if ( $informative_fields > 0 ) {
					for ( $i = 1; $i <= $informative_fields; $i++ ) {
						$footer_setting_fields[] = array(
							'id'       => $footer_id . '_info_field_' . $i . '_logo',
							'type'     => 'media',
							'title'    => esc_html__( 'Logo ', 'w3construct' ) . $i,
							'default'  => '',
							'required' => array(
								array(
									0 => 'footer_style',
									1 => 'equals',
									2 => $footer_id,
								),
								array(
									0 => 'footer_company_info_on',
									1 => 'equals',
									2 => '1',
								),
							),
						);
						$footer_setting_fields[] = array(
							'id'       => $footer_id . '_info_field_' . $i . '_contact',
							'type'     => 'textarea',
							'title'    => esc_html__( 'Contact ', 'w3construct' ) . $i,
							'default'  => '',
							'required' => array(
								array(
									0 => 'footer_style',
									1 => 'equals',
									2 => $footer_id,
								),
								array(
									0 => 'footer_company_info_on',
									1 => 'equals',
									2 => '1',
								),
							),
						);
						$footer_setting_fields[] = array(
							'id'       => $footer_id . '_info_field_' . $i . '_address',
							'type'     => 'textarea',
							'title'    => esc_html__( 'Address ', 'w3construct' ) . $i,
							'default'  => '',
							'required' => array(
								array(
									0 => 'footer_style',
									1 => 'equals',
									2 => $footer_id,
								),
								array(
									0 => 'footer_company_info_on',
									1 => 'equals',
									2 => '1',
								),
							),
						);
					}
				}
			}

			$footer_setting_fields[] = array(
				'id'       => 'footer_copyright_text',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Copyright Text', 'w3construct' ),
				'subtitle' => esc_html__( 'Write footer copyright text here.', 'w3construct' ),
				'default'  => esc_html__( 'Copyright © 2024', 'w3construct' ) . "<a href='https://w3itexperts.com/' class='text-primary' target='_blank'> W3ITXPERTS </a>" . esc_html__( ' All rights reserved.', 'w3construct' ),
				'required' => array(
					0 => 'footer_on',
					1 => 'equals',
					2 => '1',
				),
			);

			$this->sections[] = array(
				'title'  => esc_html__( 'Footer Settings', 'w3construct' ),
				'desc'   => esc_html__( 'The footer uses widgets to show information. Here you can customize the number of layouts. In order to add widgets to the footer go to footer widgets section and drag widget to the footer block (s).', 'w3construct' ) . '<br><br>' . esc_html__( 'Footer blocks are change according to footer templates.', 'w3construct' ),
				'icon'   => 'fa fa-home',
				'fields' => $footer_setting_fields,
			);

			/**--------------------------------------------------------------
			* 5. Menu Settings
			/*--------------------------------------------------------------*/
			$this->sections[] = array(
				'title'  => esc_html__( 'Menu Settings', 'w3construct' ),
				'icon'   => 'el el-cog',
				'fields' => array(
					array(
						'id'       => 'scroll_menu_pages',
						'type'     => 'select',
						'data'     => 'pages',
						'multi'    => true,
						'title'    => esc_html__( 'Choose Scroll Menu Pages', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Page For One Page Menus', 'w3construct' ),
					),

					array(
						'id'       => 'center_scroll_menu_pages',
						'type'     => 'select',
						'data'     => 'pages',
						'multi'    => true,
						'title'    => esc_html__( 'Choose Scroll Menu Pages (Center Logo)', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Page For Center Logo One Page Menus', 'w3construct' ),
					),
				),
			);

			/**--------------------------------------------------------------
			* 5. Post Setting
			/*--------------------------------------------------------------*/
			$this->sections[] = array(
				'title' => esc_html__( 'Post Settings', 'w3construct' ),
				'icon'  => 'fa fa-newspaper-o',
			);

			$this->sections[] = array(
				'title'      => esc_html__( 'General Settings', 'w3construct' ),
				'desc'       => esc_html__( 'This option will work on all new post and edit post sections. On new post page we will display only Post Layout Selection , all other settings will be applicable from here.', 'w3construct' ),
				'subsection' => true,
				'icon'       => 'fa fa-gear',
				'fields'     => array(
					array(
						'id'       => 'post_general_layout',
						'type'     => 'image_select',
						'height'   => '100',
						'title'    => esc_html__( 'Single Post Layout (PRO)', 'w3construct' ),
						'subtitle' => esc_html__( 'Select a layout for post page.', 'w3construct' ),
						'desc'     => esc_html__( 'Click on the template icon to select. You pro version for more 9 layouts.', 'w3construct' ),
						'options'  => $this->post_layouts_options,
						'default'  => 'standard',
						'hint'     => array(
							'title'   => esc_html__( 'How it Works?', 'w3construct' ),
							'content' => esc_html__( 'Once you select the template from here the template will apply for default post page.', 'w3construct' ),
						),
					),

					array(
						'id'      => 'date_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Date', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),
					array(
						'id'      => 'comment_count_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Comment Count', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),
					array(
						'id'      => 'comment_view_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Comment View', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),

					array(
						'id'      => 'post_view_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Post View', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => false,
					),
					array(
						'id'      => 'post_start_view',
						'type'    => 'text',
						'title'   => esc_html__( 'Post Start View', 'w3construct' ),
						'default' => '',
						'desc'    => esc_html__( 'Enter only number.', 'w3construct' ),
						'hint'    => array(
							'title'   => esc_html__( 'Post Views', 'w3construct' ),
							'content' => esc_html__( 'We will display view count by adding this number in original post views. It will help to build post reputation on blog.', 'w3construct' ),
						),
					),
					array(
						'id'      => 'author_box_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Author Box', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => false,
					),
					array(
						'id'      => 'category_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Category', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),

					array(
						'id'      => 'pre_next_post_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Previous & Next Post', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),
					array(
						'id'      => 'featured_img_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Featured Image', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),

					array(
						'id'      => 'related_post_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Related Post', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => false,
					),
					array(
						'id'       => 'show_image_on_post_list',
						'type'     => 'switch',
						'title'    => esc_html__( 'Show Image On Post List', 'w3construct' ),
						'subtitle' => esc_html__( 'Show feature image on post listing in admin panel.', 'w3construct' ),
						'on'       => esc_html__( 'Enabled', 'w3construct' ),
						'off'      => esc_html__( 'Disabled', 'w3construct' ),
						'default'  => false,
					),
					array(
						'id'      => 'post_general_banner_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Post Banner', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => false,
					),
					array(
						'id'       => 'post-general-img-banner-section-start',
						'type'     => 'section',
						'title'    => esc_html__( 'Banner Setting', 'w3construct' ),
						'indent'   => true,
						'required' => array(
							0 => 'post_general_banner_on',
							1 => 'equals',
							2 => 1,
						),
					),
					array(
						'id'       => 'post_general_banner_height',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Post Banner Height', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose the height for all tag page banner. Default : Small Banner', 'w3construct' ),
						'height'   => '40',
						'options'  => $this->page_banner_options,
						'default'  => 'page_banner_small',
					),

					array(
						'id'            => 'post_general_banner_custom_height',
						'type'          => 'slider',
						'title'         => esc_html__( 'Post Banner Custom Height', 'w3construct' ),
						'desc'          => esc_html__( 'Height description. Min: 100, max: 800', 'w3construct' ),
						'default'       => w3construct_get_opt( 'post_general_banner_height' ),
						'min'           => 100,
						'max'           => 800,
						'display_value' => 'text',
						'required'      => array(
							0 => 'post_general_banner_height',
							1 => 'equals',
							2 => 'page_banner_custom',
						),
					),
					array(
						'id'       => 'post_general_banner',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Post Banner Image', 'w3construct' ),
						'subtitle' => esc_html__( 'Enter page banner image. It will work as default banner image for all pages', 'w3construct' ),
						'desc'     => esc_html__( 'Upload banner image.', 'w3construct' ),
						'default'  => '',
					),
					array(
						'id'       => 'post-general-img-banner-section-end',
						'type'     => 'section',
						'indent'   => false,
						'required' => array(
							0 => 'post_general_banner_on',
							1 => 'equals',
							2 => 1,
						),
					),

					array(
						'id'       => 'post_bg_image_custom',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Custom Post Background Image', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose custom background image for post single page.', 'w3construct' ),
						'desc'     => esc_html__( 'Upload background image.', 'w3construct' ),
						'default'  => array(
							'url' => '',
						),
						'required' => array(
							0 => 'post_background_type',
							1 => 'equals',
							2 => 'custom',
						),
					),
				),
			);

			/**--------------------------------------------------------------
			* 6. Page Setting
			/*--------------------------------------------------------------*/

			$this->sections[] = array(
				'title' => esc_html__( 'Page Settings', 'w3construct' ),
				'icon'  => 'fa fa-file',
			);

			$this->sections[] = array(
				'title'      => esc_html__( 'General Settings', 'w3construct' ),
				'icon'       => 'fa fa-gear',
				'desc'       => '',
				'subsection' => true,
				'fields'     => array(
					array(
						'id'      => 'page_general_banner_on',
						'type'    => 'switch',
						'title'   => esc_html__( 'Page Banner', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),
					array(
						'id'       => 'page_general_banner_type',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Page Banner Type', 'w3construct' ),
						'options'  => $this->banner_type,
						'default'  => 'image',
						'required' => array(
							0 => 'page_general_banner_on',
							1 => 'equals',
							2 => '1',
						),
					),
					array(
						'id'       => 'general-img-banner-section-start',
						'type'     => 'section',
						'title'    => esc_html__( 'Image Banner Setting', 'w3construct' ),
						'indent'   => true,
						'required' => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'image',
						),
					),
					array(
						'id'       => 'page_general_banner_height',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Page Banner Height', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose the height for all tag page banner. Default : Medium Banner', 'w3construct' ),
						'height'   => '40',
						'options'  => $this->page_banner_options,
						'default'  => 'page_banner_medium',
						'required' => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'image',
						),
					),

					array(
						'id'            => 'page_general_banner_custom_height',
						'type'          => 'slider',
						'title'         => esc_html__( 'Post Banner Custom Height', 'w3construct' ),
						'desc'          => esc_html__( 'Height description. Min: 100, max: 800', 'w3construct' ),
						'default'       => w3construct_get_opt( 'page_general_banner_height' ),
						'min'           => 100,
						'max'           => 800,
						'display_value' => 'text',
						'required'      => array(
							0 => 'page_general_banner_height',
							1 => 'equals',
							2 => 'page_banner_custom',
						),
					),

					array(
						'id'       => 'page_general_banner',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Page Banner Image', 'w3construct' ),
						'subtitle' => esc_html__( 'Enter page banner image. It will work as default banner image for all pages', 'w3construct' ),
						'desc'     => esc_html__( 'Upload banner image.', 'w3construct' ),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/bnr8.jpg',
						),
						'required' => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'image',
						),
					),
					array(
						'id'     => 'general-img-banner-section-end',
						'type'   => 'section',
						'indent' => false,
					),
					array(
						'id'       => 'general-post-banner-section-start',
						'type'     => 'section',
						'title'    => esc_html__( 'Post Banner Setting', 'w3construct' ),
						'indent'   => true,
						'required' => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'       => 'page_general_no_of_post',
						'type'     => 'text',
						'title'    => esc_html__( 'Number of Posts', 'w3construct' ),
						'subtitle' => esc_html__( 'Enter number of post. Default : 3', 'w3construct' ),
						'default'  => '3',
						'required' => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'       => 'general_post_banner_layout',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Post Banner Layout', 'w3construct' ),
						'subtitle' => esc_html__( 'Select banner layout. Default : Full Banner', 'w3construct' ),
						'options'  => $this->post_banner_options,
						'default'  => 'post_banner_v1',
						'required' => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'       => 'page_general_banner_cat',
						'type'     => 'select',
						'multi'    => true,
						'data'     => 'terms',
						'args'     => array(
							'taxonomies' => 'category',
						),
						'title'    => esc_html__( 'Post Category', 'w3construct' ),
						'subtitle' => esc_html__( 'Select post category. It will work as default banner for all pages', 'w3construct' ),
						'desc'     => esc_html__( 'Allow you to select multiple categories.', 'w3construct' ),
						'default'  => '',
						'required' => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'           => 'page_general_post_type',
						'type'         => 'button_set',
						'title'        => esc_html__( 'Post Type', 'w3construct' ),
						'options'      => array(
							'all'      => esc_html__( 'All', 'w3construct' ),
							'featured' => esc_html__( 'Featured', 'w3construct' ),
						),
						'default'      => 'all',
						'force_output' => true,
						'required'     => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'       => 'page_general_items_with',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Items With', 'w3construct' ),
						'options'  => array(
							'with_any_type'          => esc_html__( 'Any Type', 'w3construct' ),
							'with_featured_image'    => esc_html__( 'With Featured Image', 'w3construct' ),
							'without_featured_image' => esc_html__( 'Without Featured Iimage', 'w3construct' ),
						),
						'default'  => 'with_any_type',
						'required' => array(
							0 => 'page_general_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'     => 'general-post-banner-section-end',
						'type'   => 'section',
						'indent' => false,
					),
					array(
						'id'     => 'general-sidebar-section-start',
						'type'   => 'section',
						'title'  => esc_html__( 'Sidebar Setting', 'w3construct' ),
						'indent' => true,
					),
					array(
						'id'      => 'page_general_show_sidebar',
						'type'    => 'switch',
						'title'   => esc_html__( 'Sidebar', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),
					array(
						'id'       => 'page_general_sidebar_layout',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Sidebar Layout', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose the layout for page. (Default : Right Side).', 'w3construct' ),
						'options'  => $this->sidebar_layout_options,
						'default'  => 'right',
						'required' => array(
							0 => 'page_general_show_sidebar',
							1 => 'equals',
							2 => '1',
						),
					),
					array(
						'id'       => 'page_general_sidebar',
						'type'     => 'select',
						'data'     => 'sidebars',
						'title'    => esc_html__( 'Sidebar', 'w3construct' ),
						'subtitle' => esc_html__( 'Select sidebar for all pages', 'w3construct' ),
						'default'  => 'dz_blog_sidebar',
						'required' => array(
							0 => 'page_general_sidebar_layout',
							1 => 'equals',
							2 => array(
								'right',
								'left',
							),
						),
					),
					array(
						'id'     => 'general-sidebar-section-end',
						'type'   => 'section',
						'indent' => false,
					),
					array(
						'id'           => 'page_general_paging',
						'type'         => 'button_set',
						'title'        => esc_html__( 'Pagination', 'w3construct' ),
						'options'      => array(
							'default'   => esc_html__( 'Default', 'w3construct' ),
							'load_more' => esc_html__( 'Load More', 'w3construct' ),
						),
						'default'      => 'default',
						'force_output' => true,
					),
				),
			);

			$default_pages_data = array(
				'page_author'   => array(
					'top_desc' => 'The author template is shown when a user clicks on the author in the front end of the site.',
					'id'       => 'author',
					'title'    => 'Author',
					'icon'     => 'fa fa-user',
				),
				'page_category' => array(
					'top_desc' => 'When a user requests a page or post that doesn`t exists, WordPress will use this template.',
					'id'       => 'category',
					'title'    => 'Category',
					'icon'     => 'fa fa-list-alt',
				),
				'page_search'   => array(
					'top_desc' => 'Set the default layout for all the categories.',
					'id'       => 'search',
					'title'    => 'Search',
					'icon'     => 'fa fa-search',
				),
				'page_archive'  => array(
					'top_desc' => 'This template is used by WordPress to generate the archives. By default WordPress generates daily, monthly and yearly archives.',
					'id'       => 'archive',
					'title'    => 'Archive',
					'icon'     => 'fa fa-archive',
				),
				'page_tag'      => array(
					'top_desc' => 'Set the default layout for all the categories.',
					'id'       => 'tag',
					'title'    => 'Tag',
					'icon'     => 'fa fa-tags',
				),
			);
			foreach ( $default_pages_data as $key => $page_data ) {

				$pg_desc    = $page_data['top_desc'];
				$pg_id      = $page_data['id'];
				$pg_name    = $page_data['title'];
				$pg_icon    = $page_data['icon'];
				$pg_sidebar = ! empty( $page_data['sidebar'] ) ? $page_data['sidebar'] : 'dz_blog_sidebar';

				if ( 'page_cmsoon' === $key ) {
					$page_templates = $this->coming_template_options;
				} elseif ( 'page_maintenance' === $key ) {
					$page_templates = $this->maintenance_template_options;
				} else {
					$page_templates = $this->page_template_options;
				}

				$page_default_settings = array();
				$page_sorting          = array();
				$page_pagination       = array();
				$page_default_settings = array(
					array(
						'id'           => $pg_id . '_page_title',
						'type'         => 'text',
						'title'        => esc_html( $pg_name ) . esc_html__( ' Title', 'w3construct' ),
						'default'      => $pg_name . esc_html__( ' : ', 'w3construct' ),
						'force_output' => true,
					),
					array(
						'id'      => $pg_id . '_page_banner_on',
						'type'    => 'switch',
						'title'   => esc_html( $pg_name ) . esc_html__( ' Banner', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),

					array(
						'id'       => $pg_id . '_page_banner_type',
						'type'     => 'button_set',
						'title'    => esc_html( $pg_name ) . esc_html__( ' Banner Type', 'w3construct' ),
						'options'  => $this->banner_type,
						'default'  => 'image',
						'required' => array(
							0 => $pg_id . '_page_banner_on',
							1 => 'equals',
							2 => '1',
						),
					),
					array(
						'id'       => $pg_id . '-img-banner-section-start',
						'type'     => 'section',
						'title'    => esc_html__( 'Image Banner Setting', 'w3construct' ),
						'indent'   => true,
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'image',
						),
					),
					array(
						'id'       => $pg_id . '_page_banner_height',
						'type'     => 'image_select',
						'title'    => esc_html( $pg_name ) . esc_html__( ' Banner Height', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose the height for page banner. Default : Medium Banner', 'w3construct' ),
						'height'   => '40',
						'options'  => $this->page_banner_options,
						'default'  => 'page_banner_medium',
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'image',
						),
					),
					array(
						'id'            => $pg_id . '_page_banner_custom_height',
						'type'          => 'slider',
						'title'         => esc_html( $pg_name ) . esc_html__( ' Banner Custom Height', 'w3construct' ),
						'desc'          => esc_html__( 'Hight description. Min: 100, max: 800', 'w3construct' ),
						'default'       => '',
						'min'           => 100,
						'max'           => 800,
						'display_value' => 'text',
						'required'      => array(
							0 => $pg_id . '_page_banner_height',
							1 => 'equals',
							2 => 'page_banner_custom',
						),
					),

					array(
						'id'       => $pg_id . '_page_banner',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html( $pg_name ) . esc_html__( ' Banner Image', 'w3construct' ),
						'subtitle' => esc_html__( 'Enter page banner image. It will work as default banner image for the page.', 'w3construct' ),
						'desc'     => esc_html__( 'Upload banner image.', 'w3construct' ),
						'default'  => array(
							'url' => get_template_directory_uri() . '/assets/images/bnr8.jpg',
						),
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'image',
						),
					),
					array(
						'id'       => $pg_id . '_page_banner_hide',
						'type'     => 'checkbox',
						'title'    => esc_html__( 'Don`t use banner image for this page', 'w3construct' ),
						'default'  => '0',
						'desc'     => esc_html__( 'Check if you don`t want to use banner image', 'w3construct' ),
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'image',
						),
						'hint'     => array(
							'content' => esc_html__( 'If we don`t have suitable image then we can hide current or default banner images and show only banner container with theme default color.', 'w3construct' ),
						),
					),
					array(
						'id'     => $pg_id . '-img-banner-section-end',
						'type'   => 'section',
						'indent' => false,
					),
					array(
						'id'       => $pg_id . '-post-banner-section-start',
						'type'     => 'section',
						'title'    => esc_html( $pg_name ) . esc_html__( ' Banner Setting', 'w3construct' ),
						'indent'   => true,
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'       => $pg_id . '_page_no_of_post',
						'type'     => 'text',
						'title'    => esc_html__( 'Number of Posts', 'w3construct' ),
						'subtitle' => esc_html__( 'Enter number of post. Default : 3', 'w3construct' ),
						'default'  => '3',
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'       => $pg_id . '_post_banner_layout',
						'type'     => 'image_select',
						'title'    => esc_html( $pg_name ) . esc_html__( ' Banner Layout', 'w3construct' ),
						'subtitle' => esc_html__( 'Select banner layout. Default : Full Banner', 'w3construct' ),
						'options'  => $this->post_banner_options,
						'default'  => 'post_banner_v1',
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'       => $pg_id . '_page_banner_cat',
						'type'     => 'select',
						'multi'    => true,
						'data'     => 'terms',
						'args'     => array(
							'taxonomies' => 'category',
						),
						'title'    => esc_html__( 'Post Category', 'w3construct' ),
						'subtitle' => esc_html__( 'Select post category. It will work as default banner for the page.', 'w3construct' ),
						'desc'     => esc_html__( 'Allow you to select multiple categories.', 'w3construct' ),
						'default'  => '',
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'           => $pg_id . '_page_post_type',
						'type'         => 'button_set',
						'title'        => esc_html__( 'Post Type', 'w3construct' ),
						'options'      => array(
							'all'      => esc_html__( 'All', 'w3construct' ),
							'featured' => esc_html__( 'Featured', 'w3construct' ),
						),
						'default'      => 'all',
						'force_output' => true,
						'required'     => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'       => $pg_id . '_page_items_with',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Items With', 'w3construct' ),
						'options'  => array(
							'with_any_type'          => esc_html__( 'Any Type', 'w3construct' ),
							'with_featured_image'    => esc_html__( 'With Featured Image', 'w3construct' ),
							'without_featured_image' => esc_html__( 'Without Featured Iimage', 'w3construct' ),
						),
						'default'  => 'with_any_type',
						'required' => array(
							0 => $pg_id . '_page_banner_type',
							1 => 'equals',
							2 => 'post',
						),
					),
					array(
						'id'     => $pg_id . '-post-banner-section-end',
						'type'   => 'section',
						'indent' => false,
					),
				);

				$page_sorting       = array(
					array(
						'id'     => $pg_id . '-sidebar-section-start',
						'type'   => 'section',
						'title'  => esc_html__( 'Sidebar Setting', 'w3construct' ),
						'indent' => true,
					),
					array(
						'id'      => $pg_id . '_page_show_sidebar',
						'type'    => 'switch',
						'title'   => esc_html__( 'Sidebar', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => true,
					),
					array(
						'id'       => $pg_id . '_page_sidebar_layout',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Sidebar Layout', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose the layout for the page. (Default : Right Side).', 'w3construct' ),
						'options'  => $this->sidebar_layout_options,
						'default'  => 'right',
						'required' => array(
							0 => $pg_id . '_page_show_sidebar',
							1 => 'equals',
							2 => '1',
						),
					),
					array(
						'id'       => $pg_id . '_page_sidebar',
						'type'     => 'select',
						'data'     => 'sidebars',
						'title'    => esc_html__( 'Sidebar', 'w3construct' ),
						'subtitle' => esc_html__( 'Select sidebar for the page.', 'w3construct' ),
						'default'  => $pg_sidebar,
						'required' => array(
							0 => $pg_id . '_page_sidebar_layout',
							1 => 'equals',
							2 => array(
								'right',
								'left',
							),
						),
					),
					array(
						'id'     => $pg_id . '-sidebar-section-end',
						'type'   => 'section',
						'indent' => false,
					),
				);
				$final_page_options = array_merge( $page_default_settings, $page_sorting, $page_pagination );

				$this->sections[] = array(
					'title'      => $pg_name . esc_html__( ' Page', 'w3construct' ),
					'icon'       => $pg_icon,
					'desc'       => '',
					'subsection' => true,
					'fields'     => $final_page_options,
				);
			}

			$this->sections[] = array(
				'title'      => esc_html__( '404 Page', 'w3construct' ),
				'icon'       => 'fa fa-warning',
				'desc'       => '',
				'subsection' => true,
				'fields'     => array(
					array(
						'id'           => 'error_page_title',
						'type'         => 'text',
						'title'        => esc_html__( 'Page Title', 'w3construct' ),
						'default'      => esc_html__( '404', 'w3construct' ),
						'force_output' => true,
					),
					array(
						'id'       => 'error_page_template',
						'type'     => 'image_select',
						'height'   => '80',
						'title'    => esc_html__( '404 Template', 'w3construct' ),
						'subtitle' => esc_html__( 'Select a template for the page.', 'w3construct' ),
						'options'  => array(
							'error_style_1' => get_template_directory_uri() . '/dz-inc/assets/images/page-template/error-404.png',
						),
						'default'  => 'error_style_1',
					),
					array(
						'id'      => 'error_page_text',
						'type'    => 'textarea',
						'title'   => esc_html__( '404 Page Text', 'w3construct' ),
						'default' => esc_html__( 'We are sorry. But the page you are looking for cannot be found.', 'w3construct' ),
					),
					array(
						'id'      => 'error_page_button_text',
						'type'    => 'text',
						'title'   => esc_html__( '404 Page Button Text', 'w3construct' ),
						'default' => esc_html__( 'BACK TO HOMEPAGE', 'w3construct' ),
					),
				),
			);

			/**--------------------------------------------------------------
			* 10. Theme Setting
			/*--------------------------------------------------------------*/
			$this->sections[] = array(
				'title' => esc_html__( 'Theme Settings', 'w3construct' ),
				'icon'  => 'el el-cogs',
			);

			$this->sections[] = array(
				'title'      => esc_html__( 'Color & Design', 'w3construct' ),
				'icon'       => 'fa fa-pencil',
				'subsection' => true,
				'fields'     => array(
					array(
						'id'       => 'page_loader_type',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Page Loader Type', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Loader Type.', 'w3construct' ),
						'desc'     => esc_html__( 'Choose Loading Image', 'w3construct' ),
						'options'  => array(
							'loading_image'   => esc_html__( 'Loading Image', 'w3construct' ),
							'advanced_loader' => esc_html__( 'Advanced Page Loader', 'w3construct' ),
						),
						'default'  => 'loading_image',
						'hint'     => array(
							'title'   => esc_html__( 'Write title text here', 'w3construct' ),
							'content' => esc_html__( 'Write content text here.', 'w3construct' ),
						),
					),
					array(
						'id'       => 'page_loader_image',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Loading Image (Gif)', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Gif Image.', 'w3construct' ),
						'desc'     => esc_html__( 'Choose Gif Image.', 'w3construct' ),
						'options'  => $this->page_loader_options,
						'default'  => 'loading1',
						'height'   => '35',
						'hint'     => array(
							'title'   => esc_html__( 'Loading Image (Gif)', 'w3construct' ),
							'content' => esc_html__( 'Choose Gif Image.', 'w3construct' ),
						),
						'required' => array(
							0 => 'page_loader_type',
							1 => 'equals',
							2 => 'loading_image',
						),
					),
					array(
						'id'       => 'custom_page_loader_image',
						'type'     => 'media',
						'url'      => true,
						'title'    => esc_html__( 'Custom Loading Image (Gif)', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Custom Loading Gif Image.', 'w3construct' ),
						'desc'     => esc_html__( 'Choose Gif Image', 'w3construct' ),
						'hint'     => array(
							'title'   => esc_html__( 'Custom Loading Image (Gif)', 'w3construct' ),
							'content' => esc_html__( 'Choose Gif Image.', 'w3construct' ),
						),
						'required' => array(
							0 => 'page_loader_type',
							1 => 'equals',
							2 => 'loading_image',
						),
					),
					array(
						'id'       => 'advanced_page_loader_image',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Advanced Loading Image', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Advanced Loading Image (Gif)', 'w3construct' ),
						'desc'     => esc_html__( 'Choose Advanced Loading Image', 'w3construct' ),
						'options'  => array(
							'loading1' => get_template_directory_uri() . '/dz-inc/assets/images/advanced-loading-images/loading1.gif',
							'loading2' => get_template_directory_uri() . '/dz-inc/assets/images/advanced-loading-images/loading2.gif',
						),
						'default'  => 'loading1',
						'height'   => '60',
						'hint'     => array(
							'title'   => esc_html__( 'Advanced Loading Image (Gif)', 'w3construct' ),
							'content' => esc_html__( 'Choose Advanced Loading Image', 'w3construct' ),
						),
						'required' => array(
							0 => 'page_loader_type',
							1 => 'equals',
							2 => 'advanced_loader',
						),
					),
					array(
						'id'       => 'advanced_page_loader_title',
						'type'     => 'text',
						'title'    => esc_html__( 'Page Loader Title', 'w3construct' ),
						'desc'     => esc_html__( 'Input the title for the page Loader.', 'w3construct' ),
						'default'  => esc_html__( 'Your Wait Is Going To Finish', 'w3construct' ),
						'required' => array(
							array(
								0 => 'page_loader_type',
								1 => 'equals',
								2 => 'advanced_loader',
							),
							array(
								0 => 'advanced_page_loader_image',
								1 => 'equals',
								2 => 'loading1',
							),
						),
					),
					array(
						'id'       => 'theme_layout',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Theme Layout', 'w3construct' ),
						'subtitle' => esc_html__( 'Choose theme layout.', 'w3construct' ),
						'desc'     => esc_html__( 'Click in the image icon to select the theme layout (Default : Full Width).', 'w3construct' ),
						'options'  => $this->theme_layout_options,
						'height'   => '80',
						'default'  => 'theme_layout_1',
						'hint'     => array(
							'title'   => esc_html__( 'How it Works?', 'w3construct' ),
							'content' => esc_html__( '1. Full Width: the web pages will be full width as shown in the image.', 'w3construct' ) . '<br><br>' . esc_html__( '2. Boxed: with the box layout the padding will be applied on two sides (Left, Right) of the page.', 'w3construct' ) . '<br><br>' . esc_html__( '3. Frame: with the frame layout the padding will be applied on all sides (Top, Right, Bottom, Left) of the page.', 'w3construct' ),
						),
					),
					array(
						'id'            => 'boxed_layout_bg_pattern_padding',
						'type'          => 'slider',
						'title'         => esc_html__( 'Padding', 'w3construct' ),
						'desc'          => esc_html__( 'Padding description. Min: 10, max: 100, default value: 20', 'w3construct' ),
						'default'       => 20,
						'min'           => 10,
						'max'           => 100,
						'display_value' => 'text',
						'required'      => array(
							array(
								0 => 'theme_layout',
								1 => 'equals',
								2 => 'theme_layout_3',
							),
						),
					),
					array(
						'id'       => 'body_boxed_bg_type',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Background Type', 'w3construct' ),
						'subtitle' => esc_html__( 'Select the background type.', 'w3construct' ),
						'desc'     => esc_html__( 'Click on the tab to choose background type', 'w3construct' ),
						'options'  => array(
							'bg_type_color'   => esc_html__( 'Type Color', 'w3construct' ),
							'bg_type_image'   => esc_html__( 'Type Image', 'w3construct' ),
							'bg_type_pattern' => esc_html__( 'Type Pattern', 'w3construct' ),
						),
						'default'  => 'bg_type_color',
						'hint'     => array(
							'title'   => esc_html__( 'How it Works?', 'w3construct' ),
							'content' => esc_html__( '1. Type Color: page background will be type color.', 'w3construct' ) . '<br><br>' . esc_html__( '2. Type Image: page background will be type image.', 'w3construct' ) . '<br><br>' . esc_html__( '3. Type Pattern: page background will be type pattern.', 'w3construct' ),
						),
						'required' => array(
							0 => 'theme_layout',
							1 => 'equals',
							2 => array(
								'theme_layout_2',
								'theme_layout_3',
							),
						),
					),
					array(
						'id'       => 'boxed_layout_bg_color',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Background Color', 'w3construct' ),
						'subtitle' => esc_html__( 'Select background color', 'w3construct' ),
						'desc'     => esc_html__( 'Click on the image icon to choose background color.', 'w3construct' ),
						'options'  => $this->theme_color_background_options,
						'height'   => '35',
						'default'  => 'bg_color_1',
						'hint'     => array(
							'title'   => esc_html__( 'Write title text here', 'w3construct' ),
							'content' => esc_html__( 'Write content text here.', 'w3construct' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_color',
						),
					),
					array(
						'id'       => 'boxed_layout_custom_bg_color',
						'type'     => 'color_rgba',
						'title'    => 'Custom Background Color',
						'subtitle' => esc_html__( '(Optional) Choose background color as gradient color.', 'w3construct' ),
						'default'  => array(
							'color' => '',
							'alpha' => 1,
						),
						'options'  => array(
							'show_input'             => true,
							'show_initial'           => true,
							'show_alpha'             => true,
							'show_palette'           => false,
							'show_palette_only'      => false,
							'show_selection_palette' => true,
							'max_palette_size'       => 10,
							'allow_empty'            => true,
							'clickout_fires_change'  => false,
							'choose_text'            => 'Choose',
							'cancel_text'            => 'Cancel',
							'show_buttons'           => true,
							'use_extended_classes'   => true,
							'palette'                => null,
							'input_text'             => 'Select Color',
						),
						'hint'     => array(
							'title'   => esc_html__( 'How it Works?', 'w3construct' ),
							'content' => esc_html__( '1. Click on Select Color button content text here.', 'w3construct' ) . '<br><br>' . esc_html__( '2. Select the color as you want and click on Choose.', 'w3construct' ) . '<br><br>' . esc_html__( '3. On top/bottom of the panel, click on Save Changes button.', 'w3construct' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_color',
						),
					),
					array(
						'id'       => 'boxed_layout_bg_image',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Background Image', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Background Image', 'w3construct' ),
						'desc'     => esc_html__( 'Choose Background Image', 'w3construct' ),
						'options'  => $this->theme_image_background_options,
						'height'   => '35',
						'default'  => 'bg_img_1',
						'hint'     => array(
							'title'   => esc_html__( 'Background Image', 'w3construct' ),
							'content' => esc_html__( 'Choose Background Image.', 'w3construct' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_image',
						),
					),
					array(
						'id'       => 'boxed_layout_custom_bg_image',
						'type'     => 'media',
						'url'      => true,
						'height'   => '35',
						'title'    => esc_html__( 'Custom Background Image', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Custom Background Image.', 'w3construct' ),
						'desc'     => esc_html__( 'Choose Custom Background Image.', 'w3construct' ),
						'default'  => array(
							'url' => '',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Custom Background Image', 'w3construct' ),
							'content' => esc_html__( 'Choose Custom Background Image.', 'w3construct' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_image',
						),
					),
					array(
						'id'       => 'boxed_layout_bg_pattern',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Background Pattern', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Background Pattern.', 'w3construct' ),
						'desc'     => esc_html__( 'Choose Background Pattern.', 'w3construct' ),
						'options'  => $this->theme_pattern_background_options,
						'default'  => 'bg_pattern_1',
						'height'   => '35',
						'hint'     => array(
							'title'   => esc_html__( 'Background Pattern', 'w3construct' ),
							'content' => esc_html__( 'Choose Background Pattern.', 'w3construct' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_pattern',
						),
					),
					array(
						'id'       => 'boxed_layout_custom_bg_pattern',
						'type'     => 'media',
						'url'      => true,
						'width'    => '35',
						'height'   => '35',
						'title'    => esc_html__( 'Custom Background Pattern', 'w3construct' ),
						'subtitle' => esc_html__( 'Select Custom Background Pattern.', 'w3construct' ),
						'desc'     => esc_html__( 'Choose Custom Background Pattern.', 'w3construct' ),
						'default'  => array(
							'url' => '',
						),
						'hint'     => array(
							'title'   => esc_html__( 'Custom Background Pattern', 'w3construct' ),
							'content' => esc_html__( 'Choose Custom Background Pattern.', 'w3construct' ),
						),
						'required' => array(
							0 => 'body_boxed_bg_type',
							1 => 'equals',
							2 => 'bg_type_pattern',
						),
					),
				),
			);

			$theme_fonts = array(
				'Font & Sizes' => array(
					'id'      => 'general',
					'title'   => 'General Fonts',
					'heading' => 'General Settings',
					'desc'    => 'When a user requests a page or post that doesn`t exist, WordPress will use this template.',
				),
			);

			foreach ( $theme_fonts as $key => $font ) {
				$font_id      = $font['id'];
				$font_title   = $font['title'];
				$font_heading = $font['heading'];
				$font_desc    = $font['desc'];

				$this->sections[] = array(
					'title'      => $key,
					'heading'    => $font_heading,
					'desc'       => $font_desc,
					'icon'       => 'el-icon-text-width',
					'subsection' => true,
					'fields'     => array(
						array(
							'id'      => $font_id . '_font',
							'type'    => 'button_set',
							'title'   => $font_title,
							'options' => array(
								'Open-Sans'   => esc_html__( 'Default', 'w3construct' ),
								'Google-Font' => esc_html__( 'Google Fonts', 'w3construct' ),
							),
							'default' => 'Open-Sans',
						),
						array(
							'id'           => $font_id . '_font_body',
							'type'         => 'typography',
							'title'        => esc_html__( 'Body', 'w3construct' ),
							'subtitle'     => esc_html__( 'This will be the default font for the body tag of your website.', 'w3construct' ),
							'google'       => true,
							'font-backup'  => true,
							'all_styles'   => true,
							'text-align'   => false,
							'color'        => true,
							'output'       => array(
								'body',
							),
							'units'        => 'px',
							'required'     => array(
								0 => $font_id . '_font',
								1 => 'equals',
								2 => 'Google-Font',
							),
							'force_output' => true,
						),
						array(
							'id'           => $font_id . '_font_h1',
							'type'         => 'typography',
							'title'        => esc_html__( 'H1', 'w3construct' ),
							'subtitle'     => esc_html__( 'This will be the default font for all H1 tags of your website.', 'w3construct' ),
							'google'       => true,
							'font-backup'  => true,
							'all_styles'   => true,
							'text-align'   => false,
							'color'        => true,
							'output'       => array(
								'h1',
							),
							'units'        => 'px',
							'required'     => array(
								0 => $font_id . '_font',
								1 => 'equals',
								2 => 'Google-Font',
							),
							'force_output' => true,
						),
						array(
							'id'           => $font_id . '_font_h2',
							'type'         => 'typography',
							'title'        => esc_html__( 'H2', 'w3construct' ),
							'subtitle'     => esc_html__( 'This will be the default font for all H2 tags of your website.', 'w3construct' ),
							'google'       => true,
							'font-backup'  => true,
							'all_styles'   => true,
							'text-align'   => false,
							'color'        => true,
							'output'       => array(
								'h2',
							),
							'units'        => 'px',
							'required'     => array(
								0 => $font_id . '_font',
								1 => 'equals',
								2 => 'Google-Font',
							),
							'force_output' => true,
						),
						array(
							'id'           => $font_id . '_font_h3',
							'type'         => 'typography',
							'title'        => esc_html__( 'H3', 'w3construct' ),
							'subtitle'     => esc_html__( 'This will be the default font for all H3 tags of your website.', 'w3construct' ),
							'google'       => true,
							'font-backup'  => true,
							'all_styles'   => true,
							'text-align'   => false,
							'color'        => true,
							'output'       => array(
								'h3',
							),
							'units'        => 'px',
							'required'     => array(
								0 => $font_id . '_font',
								1 => 'equals',
								2 => 'Google-Font',
							),
							'force_output' => true,
						),
						array(
							'id'           => $font_id . '_font_h4',
							'type'         => 'typography',
							'title'        => esc_html__( 'H4', 'w3construct' ),
							'subtitle'     => esc_html__( 'This will be the default font for all H4 tags of your website.', 'w3construct' ),
							'google'       => true,
							'font-backup'  => true,
							'all_styles'   => true,
							'text-align'   => false,
							'color'        => true,
							'output'       => array(
								'h4',
							),
							'units'        => 'px',
							'required'     => array(
								0 => $font_id . '_font',
								1 => 'equals',
								2 => 'Google-Font',
							),
							'force_output' => true,
						),
						array(
							'id'           => $font_id . '_font_h5',
							'type'         => 'typography',
							'title'        => esc_html__( 'H5', 'w3construct' ),
							'subtitle'     => esc_html__( 'This will be the default font for all H5 tags of your website.', 'w3construct' ),
							'google'       => true,
							'font-backup'  => true,
							'all_styles'   => true,
							'text-align'   => false,
							'color'        => true,
							'output'       => array(
								'h5',
							),
							'units'        => 'px',
							'required'     => array(
								0 => $font_id . '_font',
								1 => 'equals',
								2 => 'Google-Font',
							),
							'force_output' => true,
						),
						array(
							'id'           => $font_id . '_font_h6',
							'type'         => 'typography',
							'title'        => esc_html__( 'H6', 'w3construct' ),
							'subtitle'     => esc_html__( 'This will be the default font for all H6 tags of your website.', 'w3construct' ),
							'google'       => true,
							'font-backup'  => true,
							'all_styles'   => true,
							'text-align'   => false,
							'color'        => true,
							'output'       => array(
								'h6',
							),
							'units'        => 'px',
							'required'     => array(
								0 => $font_id . '_font',
								1 => 'equals',
								2 => 'Google-Font',
							),
							'force_output' => true,
						),
						array(
							'id'           => $font_id . '_font_p_tag',
							'type'         => 'typography',
							'title'        => esc_html__( 'P (Paragraph Text)', 'w3construct' ),
							'subtitle'     => esc_html__( 'This will be the default font for all P tags of your website.', 'w3construct' ),
							'google'       => true,
							'font-backup'  => true,
							'all_styles'   => true,
							'text-align'   => false,
							'color'        => true,
							'output'       => array(
								'p',
							),
							'units'        => 'px',
							'required'     => array(
								0 => $font_id . '_font',
								1 => 'equals',
								2 => 'Google-Font',
							),
							'force_output' => true,
						),
					),
				);
			}

			/**--------------------------------------------------------------
			* 11. Social Setting
			/*--------------------------------------------------------------*/
			$this->sections[] = array(
				'title' => esc_html__( 'Social Setting', 'w3construct' ),
				'icon'  => 'el el-twitter',
			);

			$social_link_fields[] = array(
				'id'      => 'social_link_target',
				'type'    => 'select',
				'title'   => esc_html__( 'Choose Social Link Target', 'w3construct' ),
				'options' => $this->link_target_options,
				'default' => '_blank',
			);

			foreach ( $this->social_link_options as $social_link ) {

				$sl_id                = $social_link['id'];
				$sl_title             = $social_link['title'];
				$social_link_fields[] = array(
					'id'       => 'social_' . $sl_id . '_url',
					'type'     => 'text',
					'title'    => $sl_title . esc_html__( ' URL', 'w3construct' ),
					'subtitle' => esc_html__( 'Link to : ', 'w3construct' ) . $sl_title,
					'default'  => '',
				);
			}

			$this->sections[] = array(
				'title'      => esc_html__( 'Social Link', 'w3construct' ),
				'icon'       => 'el-icon-facebook',
				'subsection' => true,
				'fields'     => $social_link_fields,
			);

			$social_share_list    = array();
			$social_share_default = array();
			$i                    = 1;
			foreach ( $this->social_share_options as $social_link ) {

				$social_share_list[ $social_link['id'] ] = $social_link['title'];

				if ( $i <= 3 ) {
					$social_share_default[ $social_link['id'] ] = true;
				} else {
					$social_share_default[ $social_link['id'] ] = false;
				}
				$i++;
			}

			$this->sections[] = array(
				'title'      => esc_html__( 'Social Sharing', 'w3construct' ),
				'icon'       => 'el-icon-facebook',
				'subsection' => true,
				'fields'     => array(
					array(
						'id'      => 'social_shaing_on_post',
						'type'    => 'switch',
						'title'   => esc_html__( 'Enable Social Shaing On Post', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => false,
					),
					array(
						'id'      => 'social_shaing_on_page',
						'type'    => 'switch',
						'title'   => esc_html__( 'Enable Social Shaing On Page', 'w3construct' ),
						'on'      => esc_html__( 'Enabled', 'w3construct' ),
						'off'     => esc_html__( 'Disabled', 'w3construct' ),
						'default' => false,
					),
					array(
						'id'       => 'share_sort_link',
						'type'     => 'sortable',
						'title'    => esc_html__( 'Social Sharing', 'w3construct' ),
						'subtitle' => esc_html__( 'Select active social share links and sort them with drag and drop.', 'w3construct' ),
						'mode'     => 'checkbox',
						'options'  => $social_share_list,
						'default'  => $social_share_default,
					),
				),
			);

			/**--------------------------------------------------------------
			* 12. Custom Script Setting
			/*--------------------------------------------------------------*/
			$this->sections[] = array(
				'title' => esc_html__( 'Custom Script', 'w3construct' ),
				'icon'  => 'el el-list-alt',
			);

			$this->sections[] = array(
				'title'      => esc_html__( 'Custom Script', 'w3construct' ),
				'icon'       => 'el el-list-alt',
				'subsection' => true,
				'fields'     => array(
					array(
						'id'       => 'body_class',
						'type'     => 'text',
						'title'    => esc_html__( 'Body Class(s)', 'w3construct' ),
						'subtitle' => esc_html__( 'You can add one or more classes on theme body element. If you need more than one class, add them with a space between them.', 'w3construct' ),
						'desc'     => esc_html__( 'Ex: body-class-1 body-class-2', 'w3construct' ),
					),
					array(
						'id'       => 'css_editor',
						'type'     => 'ace_editor',
						'title'    => esc_html__( 'CSS Code', 'w3construct' ),
						'subtitle' => esc_html__( 'Paste your CSS code here.', 'w3construct' ),
						'mode'     => 'css',
						'theme'    => 'monokai',
					),
					array(
						'id'       => 'js_editor',
						'type'     => 'ace_editor',
						'title'    => esc_html__( 'Javascript Code', 'w3construct' ),
						'subtitle' => esc_html__( 'Paste your JS code here.', 'w3construct' ),
						'mode'     => 'javascript',
						'theme'    => 'chrome',
					),
					array(
						'id'       => 'html_editor',
						'type'     => 'ace_editor',
						'title'    => esc_html__( 'HTML Code', 'w3construct' ),
						'subtitle' => esc_html__( 'Paste your HTML code here.', 'w3construct' ),
						'mode'     => 'html',
						'theme'    => 'chrome',
					),
				),
			);

			$this->sections[] = array(
				'title'      => esc_html__( 'Analytic Code', 'w3construct' ),
				'icon'       => 'el-icon-edit',
				'subsection' => true,
				'fields'     => array(
					array(
						'id'       => 'site_header_code',
						'type'     => 'textarea',
						'theme'    => 'chrome',
						'title'    => esc_html__( 'Header Custom Codes', 'w3construct' ),
						'subtitle' => esc_html__( 'It will insert the code to wp_head hook.', 'w3construct' ),
					),
					array(
						'id'       => 'site_footer_code',
						'type'     => 'textarea',
						'theme'    => 'chrome',
						'title'    => esc_html__( 'Footer Custom Codes', 'w3construct' ),
						'subtitle' => esc_html__( 'It will insert the code to wp_footer hook.', 'w3construct' ),
					),
				),
			);

			/**--------------------------------------------------------------
			* 15. Advance Settings
			/*--------------------------------------------------------------*/
			$this->sections[] = array(
				'title' => esc_html__( 'Advance Options', 'w3construct' ),
				'icon'  => 'el el-cogs',
			);

			$advance_setting_sidebar_fields[] = array(
				'id'       => 'new_sidebar_input',
				'type'     => 'multi_text',
				'title'    => esc_html__( 'Sidebar Name', 'w3construct' ),
				'subtitle' => esc_html__( 'Name your sidebar!', 'w3construct' ),
				'desc'     => esc_html__( 'Enter the text only. ', 'w3construct' ) . '<a href="' . admin_url( 'widgets.php' ) . '" target="_blank">' . esc_html__( 'Click Here.', 'w3construct' ) . '</a>' . esc_html__( ' to check your sidebars', 'w3construct' ),
				'hint'     => array(
					'title'   => esc_html__( 'What to Do?', 'w3construct' ),
					'content' => esc_html__( '1. Once you named your sidebar click on the Save Changes button @ the top of the panel.', 'w3construct' ) . '<br><br>' . esc_html__( '2. After save changes please just refresh the page, you will see the sidebar listed below.', 'w3construct' ),
				),
			);

			$sidebars_widgets = get_option( 'sidebars_widgets' );

			if ( ! empty( $sidebars_widgets ) ) {
				$i = 1;
				foreach ( $sidebars_widgets as $key => $value ) {
					$key_ext   = substr( $key, 3 );
					$key_rep1  = str_replace( '-', ' ', $key_ext );
					$key_rep2  = str_replace( '-', '_', $key_ext );
					$dz_widget = ucfirst( $key_rep1 );

					if ( strpos( $key, 'dz-' ) === 0 ) {
						$advance_setting_sidebar_fields[] = array(
							'id'    => 'avail_sidebar_' . $key_rep2 . '_' . $i,
							'type'  => 'info',
							'style' => 'info',
							'desc'  => esc_html( $dz_widget, 'w3construct' ),
						);
					}
					$i++;
				}
			}

			$this->sections[] = array(
				'title'      => esc_html__( 'Create Sidebar', 'w3construct' ),
				'icon'       => 'el el-pencil',
				'desc'       => esc_html__( 'Dexignlab gives you the functionality to create your own Sidebars. Default there are three Sidebars as displayed below.', 'w3construct' ),
				'subsection' => true,
				'fields'     => $advance_setting_sidebar_fields,
			);
		}

		/**
		 * Get default theme options
		 *
		 * @param string $key The key for the theme option you want to retrieve.
		 * @param mixed  $default The default value to return if the key doesn't exist.
		 * @return mixed The value of the theme option or the default value.
		 */
		public function w3construct_get_default_option( $key, $default = '' ) {
			if ( empty( $key ) ) {
				return '';
			}
			$options = get_option( w3construct_get_opt_name(), array() );
			$value   = isset( $options[ $key ] ) ? $options[ $key ] : $default;

			return $value;
		}

	}

	global $w3constructthemeoption;

	$w3constructthemeoption = new W3Construct_Redux_Framework_config();
}
