<?php
/**
 * Archive-Ajax Template
 *
 * This file serves as the template for handling AJAX requests related to archiving content.
 *
 * @package     W3Construct
 * @author      Your Name
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$w3construct_options      = w3construct_dzbase()->option();
$w3construct_query_result = get_query_var( 'w3construct_query_result' );

foreach ( $w3construct_query_result->posts as $post_w3 ) {

	/* implement post layout icons on listing post */
	$post_id_w3        = $post_w3->ID;
	$post_setting      = get_post_meta( $post_id_w3, '_post_settings', true );
	$post_layout       = isset( $post_setting['post_layout'] ) ? $post_setting['post_layout'] : '';
	$excerpt           = $post_w3->post_excerpt;
	$content           = $post_w3->post_content;
	$short_description = w3construct_short_description( $excerpt, $content, 20 );
	$views_arr         = get_post_meta( get_the_id(), '_views_count' );
	$views             = ( isset( $views_arr[0] ) ) ? $views_arr[0] : 0;

	$post_layout_class = '';
	if ( 'link_post' === $post_layout ) {
		$post_layout_class = 'fa-link';
	}
	if ( 'audio_post' === $post_layout ) {
		$post_layout_class = 'fa-soundcloud';
	}
	if ( 'video_post' === $post_layout ) {
		$post_layout_class = 'fa-play';
	}
	if ( 'slider_post_1' === $post_layout || 'slider_post_2' === $post_layout ) {
		$post_layout_class = 'fa-picture-o';
	}

	$post_title     = ( has_post_thumbnail() ) ? w3construct_trim( get_the_title( $post_id_w3 ), 7 ) : get_the_title( $post_id_w3 );
	$author_name    = get_the_author_meta( 'display_name', $post_w3->post_author );
	$featured       = get_post_meta( get_the_ID(), 'featured_post' );
	$featured_class = ( ! empty( $featured ) && 1 === $featured[0] ) ? ' featured ' : '';
	$no_image_class = ( ! has_post_thumbnail() ) ? 'no-image' : '';
	?>
	<!-- blog post item -->
	<div id="post-<?php the_ID(); ?>" <?php echo esc_attr( post_class( 'dz-card blog-half style-1 m-b50 aos-item ' . $featured_class . ' ' . $no_image_class ) ); ?> data-aos-duration="1000" data-aos-delay="200">
		<?php if ( has_post_thumbnail( $post_id_w3 ) ) { ?>
			<div class="dz-media">
				<?php echo get_the_post_thumbnail( $post_w3, 'w3construct_555x400' ); ?>
			</div>
		<?php } ?>
		<div class="dz-info">
			<div class="dz-meta">
				<ul>
					<li class="post-date">
						<?php echo esc_html( get_the_date( '', $post_w3 ) ); ?>
					</li>
					<li class="post-user">
						<?php esc_html_e( 'By', 'w3construct' ); ?> <a
							href="<?php echo esc_url( get_author_posts_url( $post_w3->post_author ) ); ?>">
							<?php echo esc_html( $author_name ); ?>
						</a>
					</li>
				</ul>
			</div>
			<h3 class="dz-title">
				<a href="<?php echo esc_url( get_permalink( $post_id_w3 ) ); ?>">
					<?php echo wp_kses( $post_title, w3construct_allowed_html_tag() ); ?>
				</a>
			</h3>
			<div class="dz-post-text text">
				<p>
					<?php echo esc_html( $short_description ); ?>
				</p>
			</div>
			<a href="<?php echo esc_url( get_permalink( $post_id_w3 ) ); ?>" class="btn-link">
				<?php echo esc_html__( 'Read More', 'w3construct' ); ?>
			</a>
		</div>
		<?php
		if ( is_sticky() ) {
			echo '<span class="sticky-icon"><i class="fas fa-thumbtack"></i></span>';
		}
		?>
	</div>
	<!-- End Post -->
	<?php
}
wp_reset_postdata();
