<?php
/**
 * The Template displaying for admin
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$theme             = wp_get_theme();
$theme_name        = $theme->name;
$plugins_w3        = array();
$installed_plugins = get_plugins();
$active_action     = '';
if ( isset( $_GET['plugin_status'] ) ) {
	$active_action = isset( $_GET['plugin_status'] ) ? sanitize_text_field( wp_unslash( $_GET['plugin_status'] ) ) : '';
}

if ( class_exists( 'TGM_Plugin_Activation' ) ) {
	$plugins_w3 = TGM_Plugin_Activation::$instance->plugins;
}

?>

<div class="wrap welcome-wrap dz-wrap">
	<h1 class="hide" style="display:none;"></h1>
	<div class="dz-welcome-inner">
		<nav class="dz-nav-tab-wrapper nav-tab-wrapper">
			<a class="nav-tab" href="<?php echo esc_url( admin_url( 'admin.php?page=w3construct' ) ); ?>">
				<?php echo esc_html__( 'Introduction', 'w3construct' ); ?>
			</a>
			<a class="nav-tab nav-tab-active" href="#">
				<?php echo esc_html__( 'Plugins', 'w3construct' ); ?>
			</a>
			<a class="nav-tab" href="<?php echo esc_url( admin_url( 'admin.php?page=dz-system-status' ) ); ?>">
				<?php echo esc_html__( 'System Status', 'w3construct' ); ?>
			</a>
		</nav>
	</div>

	<div class="dz-demo-wrapper dz-install-plugins">

		<div class="feature-section theme-browser rendered">

			<?php
			foreach ( $plugins_w3 as $plugin ) {

				$class               = '';
				$plugin_status       = '';
				$active_action_class = '';
				$file_path           = $plugin['file_path'];
				$plugin_action       = w3construct_plugin_link( $plugin );

				foreach ( $plugin_action as $action_w3 => $value ) {
					if ( $active_action === $action_w3 ) {
						$active_action_class = ' plugin-' . $active_action . '';
					}
				}
				$is_plug_act = 'is_plugin_active';
				if ( $is_plug_act( $file_path ) ) {
					$plugin_status = 'active';
					$class         = 'active';
				}

				?>
				<div class="theme <?php echo esc_attr( $class . $active_action_class ); ?>">
					<div class="install-plugin-inner">
						<div class="theme-screenshot">
							<img src="<?php echo esc_url( get_template_directory_uri() . '/dz-inc/admin/images/plugins/' . $plugin['slug'] . '.jpg' ); ?>"
								alt="<?php echo esc_attr( $plugin['name'] ); ?>" />

							<?php if ( isset( $plugin_action['update'] ) && $plugin_action['update'] ) { ?>
								<div class="theme-update">
									<?php echo esc_html__( 'Update Available: Version', 'w3construct' ); ?>
									<?php echo esc_attr( $plugin['version'] ); ?>
								</div>
							<?php } ?>
						</div>

						<h3 class="theme-name">
							<?php
							if ( 'active' === $plugin_status ) {
								echo sprintf( '<span>%s</span> ', esc_html__( 'Active:', 'w3construct' ) );
							}
							echo esc_html( $plugin['name'] );
							?>
						</h3>

						<div class="theme-actions">
							<?php
							foreach ( $plugin_action as $action_w3 ) {
								echo wp_kses( ( '' . $action_w3 ), w3construct_allowed_html_tag() );
							}
							?>
						</div>

						<?php if ( isset( $installed_plugins[ $plugin['file_path'] ] ) ) { ?>
							<div class="plugin-info">
								<?php echo esc_html( sprintf( 'Version %s | %s', $installed_plugins[ $plugin['file_path'] ]['Version'], $installed_plugins[ $plugin['file_path'] ]['Author'] ) ); ?>
							</div>
						<?php } ?>

						<?php if ( $plugin['required'] ) { ?>
							<div class="plugin-required">
								<?php esc_html_e( 'Required', 'w3construct' ); ?>
							</div>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
