<?php
/**
 * The Template for displaying default auther page
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

get_header();
global $w3construct_option;

$show_sidebar            = w3construct_set( $w3construct_option, 'show_sidebar' );
$layout                  = w3construct_set( $w3construct_option, 'layout' );
$sidebar                 = w3construct_set( $w3construct_option, 'sidebar' );
$disable_ajax_pagination = w3construct_set( $w3construct_option, 'disable_ajax_pagination' );
$layout                  = ( ! $show_sidebar ) ? 'full' : $layout;

if ( 'full' === $layout || ! is_active_sidebar( $sidebar ) || ! w3construct_is_theme_sidebar_active() ) {
	$layout_class = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12';
} else {
	$layout_class = 'col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12';
}

w3construct_get_banner();
?>
<!-- Author Blog Post -->
<div class="section-full bg-white content-inner">
	<div class="container">
		<div class="row">
			<?php if ( $show_sidebar && 'left' === $layout && is_active_sidebar( $sidebar ) && w3construct_is_theme_sidebar_active() ) { ?>
					<div class="col-lg-4 col-md-12 col-sm-12 col-12">
						<div class="side-bar sticky-top">
							<?php dynamic_sidebar( $sidebar ); ?>
						</div>
					</div>
			<?php } ?>
			<div class="<?php echo esc_attr( $layout_class ); ?>  col-sm-12 col-12" >
				<?php
				if ( have_posts() ) {
					if ( 'load_more' === $disable_ajax_pagination ) {
						get_template_part( 'dz-inc/elements/authors-pages-ajax-posts-element' );
					} else {
						get_template_part( 'dz-inc/elements/authors-pages-pagination-posts-element' );
					}
				} else {
					get_template_part( 'dz-inc/elements/no-record-found-element' );
				}
				?>
			</div>
			<?php if ( $show_sidebar && 'right' === $layout && is_active_sidebar( $sidebar ) && w3construct_is_theme_sidebar_active() ) { ?>
				<div class="col-lg-4 col-md-12 col-sm-12 col-12">
					<div class="side-bar sticky-top">
						<?php dynamic_sidebar( $sidebar ); ?>
					</div>
				</div>
			<?php } ?>	
		</div>
	</div>
</div>
<!-- Author Blog Post End -->
<?php
get_footer();
