(function($) {
/**
* Custom.js File
*
* @package     W3Construct
* @author      W3ITEXPERTS
* @copyright   Copyright (c) 2023, W3Construct
* @link        http://w3construct-wordpress.wprdx.come/demo/
* @since       W3Construct 1.0.1
*/

	
	"use strict";
/**
Core script to handle the entire theme and core functions
**/
var W3Construct = function(){
	/* Search Bar ============ */
	if(typeof w3construct_js_data == 'undefined') {
		var siteUrl = '/';
	}else{
		var siteUrl = w3construct_js_data.template_directory_uri+'/';	
	}
	
	var screenWidth = $( window ).width();
	
	var homeSearch = function() {
		'use strict';
		/* top search in header on click function */
		var quikSearch = jQuery("#quik-search-btn");
		var quikSearchRemove = jQuery("#quik-search-remove");
		
		quikSearch.on('click',function() {
			jQuery('.dz-quik-search').fadeIn(500);
			jQuery('.dz-quik-search').addClass('On');
		});
		
		quikSearchRemove.on('click',function() {
			jQuery('.dz-quik-search').fadeOut(500);
			jQuery('.dz-quik-search').removeClass('On');
		});	
		/* top search in header on click function End*/
	}
	
	/* One Page Layout ============ */
	var onePageLayout = function() {
		'use strict';
		var headerHeight =   parseInt($('.onepage').css('height'), 10);
		
		$(".scroll").unbind().on('click',function(event){
			event.preventDefault();
			
			if (this.hash !== "") {
				var hash = this.hash;	
				var seactionPosition = $(hash).offset().top;
				var headerHeight =   parseInt($('.onepage').css('height'), 10);				
				
				$('body').scrollspy({target: ".navbar", offset: headerHeight+2}); 
				
				var scrollTopPosition = seactionPosition - (headerHeight);
				
				$('html, body').animate({
					scrollTop: scrollTopPosition
				}, 800, function(){
					
				});
			}   
		});
		$('body').scrollspy({target: ".navbar", offset: headerHeight + 2});  
		
		jQuery(window).on('load',function () {
			var checkActive = jQuery("#navbarNavDropdown ul.navbar-left li.menu-item").hasClass('active');
			if(!checkActive)
			{
				jQuery("#navbarNavDropdown ul.navbar-left li:first-child").addClass('active');	
			}
		});
		
		/* One Page Setup */
		if(jQuery('.navbar-nav').length > 0){			
			jQuery(document).on("scroll", pageOnScroll);
			
			var headerFullHeight =   parseInt($('.main-bar').css('height'), 10);			
			/* smoothscroll */
			jQuery('.navbar-nav a[href^="#"]').on('click', function (e) {
				e.preventDefault();
				jQuery(document).off("scroll");
				
				jQuery('.navbar-nav a').each(function () {					
					jQuery(this).parent('li').removeClass('active');
				})				
				jQuery(this).parent('li').addClass('active');
				
				var target = this.hash,
				
				menu = target;
				var $target = $(target);
				
				if($target.length > 0){					
					jQuery('html, body').stop().animate({						
						'scrollTop': $target.offset().top - headerFullHeight
					}, 500, 'swing', function (){
						jQuery(document).on("scroll", pageOnScroll);
					});
				}
			});
		}
	}
	
	var pageOnScroll = function(event){
		
		var scrollPos = jQuery(document).scrollTop();
		jQuery('.navbar-nav-scroll a').each(function () {
			var elementLink = jQuery(this);
			
			var headerFullHeight =   parseInt($('.main-bar').css('height'), 10);
				var refElement = jQuery(elementLink.attr("href"));
		
				if (refElement.length) {
					var contentNav = refElement.offset().top;	
					
					if (contentNav - headerFullHeight <= scrollPos && contentNav + refElement.height() > scrollPos) {				
						jQuery('.navbar-nav-scroll a').parent('li').removeClass("active");
						elementLink.parent('li').addClass("active");
					}else{
						elementLink.parent('li').removeClass("active");
					}
				}			
		});
	}
	
	/* Header Height ============ */
	var handleResizeElement = function(){
		var headerTop = 0;
		var headerNav = 0;
		
		$('.header .sticky-header').removeClass('is-fixed');
		$('.header').removeAttr('style');
		
		if(jQuery('.header .top-bar').length > 0 &&  screenWidth > 991)
		{
			headerTop = parseInt($('.header .top-bar').outerHeight());
		}

		if(jQuery('.header').length > 0 )
		{
			headerNav = parseInt($('.header').height());
			headerNav =	(headerNav == 0)?parseInt($('.header .main-bar').outerHeight()):headerNav;
		}	
		
		var headerHeight = headerNav + headerTop;
		
		jQuery('.header').css('height', headerHeight);
	}
	
	var handleResizeElementOnResize = function(){
		var headerTop = 0;
		var headerNav = 0;
		
		$('.header .sticky-header').removeClass('is-fixed');
		$('.header').removeAttr('style');
		
		
		setTimeout(function(){
			
			if(jQuery('.header .top-bar').length > 0 &&  screenWidth > 991)
			{
				headerTop = parseInt($('.header .top-bar').outerHeight());
			}

			if(jQuery('.header').length > 0 )
			{
				headerNav = parseInt($('.header').height());
				headerNav =	(headerNav == 0)?parseInt($('.header .main-bar').outerHeight()):headerNav;
			}	
			
			var headerHeight = headerNav + headerTop;
			
			jQuery('.header').css('height', headerHeight);
		
		}, 500);
    }
	
	/* Load File ============ */
	var dzTheme = function(){
		'use strict';
		var loadingImage = '<img src="images/loading.gif">';
		jQuery('.dzload').each(function(){
		var dzsrc =   siteUrl + $(this).attr('dzsrc');
			jQuery(this).hide(function(){
				jQuery(this).load(dzsrc, function(){
					jQuery(this).fadeIn('slow');
				}); 
			})
		});
		 
		
		if(screenWidth <= 991 ){
			jQuery('.navbar-nav > li > a, .sub-menu > li > a').unbind().on('click', function(e){
				
				if(jQuery(this).parent('li').has('ul').length > 0){e.preventDefault();}
				
				if(jQuery(this).parent().hasClass('open'))
				{
					jQuery(this).parent().removeClass('open');
				}else{
					if(jQuery(this).hasClass('sub-menu'))
					{
						jQuery(this).parent().addClass('open');
					}else{
						jQuery(this).parent().parent().find('li').removeClass('open');
						jQuery(this).parent().addClass('open');
					}
				}  
			});
			
		}
		
		if(screenWidth <= 991 ){
			
			var menuObj ;
			 jQuery('.navbar-nav > li > a, .sub-menu > li > a, .navbar-nav > li > a > i, .sub-menu > li > a > i')
				.unbind()
				.on({
					click: function(e){
						menuObj = jQuery(this);
						handleMenus(e, menuObj);	
					},
					keypress: function(e){
						if (e.key !== 'Enter') {
							return false;
						}
						menuObj = jQuery(this);
						handleMenus(e, menuObj);	
					},
				});
			jQuery('.tabindex').attr("tabindex","0");	
			function handleMenus(e, menuObj){
				
				if(menuObj.parent('li').has('ul').length > 0){e.preventDefault();}					
					
					if(jQuery('.navbar-nav-scroll').length > 0){						
						jQuery(document).on("scroll", pageOnScroll);					
						var headerFullHeight =   parseInt($('.main-bar').css('height'), 10);						
						
						jQuery('.navbar-nav-scroll a[href^="#"]').on('click', function (e) {
							e.preventDefault();
							jQuery(document).off("scroll");							
							jQuery('.navbar-nav-scroll a').each(function () {								
								menuObj.parent('li').removeClass('active');
							})				
							menuObj.parent('li').addClass('active');							
							var target = e.hash,							
							menu = target;
							var $target = $(target);							
							if($target.length > 0){					
								jQuery('html, body').stop().animate({						
									'scrollTop': $target.offset().top - headerFullHeight
								}, 500, 'swing', function () {
									jQuery(document).on("scroll", pageOnScroll);
								});
							}
						});
					}		

					if(menuObj.closest('li').children('ul').length > 0 ){
						jQuery('.header-nav').removeClass('collapsed').addClass('collapse show');
					}else{
						jQuery('.navbar-toggler').removeClass('open').addClass('collapsed');
						jQuery('.header-nav').removeClass('show');
					}
				
				if(menuObj.parent().hasClass('open')){
					menuObj.parent().removeClass('open');
				}else{
					if(menuObj.hasClass('sub-menu')){
						menuObj.parent().addClass('open');
					}else{
						menuObj.parent().parent().find('li').removeClass('open');
						menuObj.parent().addClass('open');
					}
				}
			}


			//const mobileBlock 			= document.getElementById('MobileMenuBlock');
			const mobileBlock 			= document.getElementById('navbarNavDropdown');
			const navigationToggle 		= document.getElementById('NavigationToggle');
			const focusableElements 	= mobileBlock.querySelectorAll('a, button, [href], input, select, textarea, [tabindex]:not([tabindex="-1"])');
			const firstFocusableElement = focusableElements[0];
			const lastFocusableElement	= focusableElements[focusableElements.length - 1];
			
			jQuery(document).on('keypress, keyup, keydown', function(e){
				
				if (e.key == 'Tab') {
					/* Handle Tab key press */
					if (e.shiftKey) {
					  /* If shift key pressed then move focus to the previous element */
					  if(document.activeElement === navigationToggle){
						e.preventDefault();
						lastFocusableElement.focus();
					  }else if (document.activeElement === firstFocusableElement) {
						e.preventDefault();
						navigationToggle.focus();
					  }
					} else {
					  /* If shift key is not pressed then move focus to the next element */
					  if (document.activeElement === lastFocusableElement) {
						e.preventDefault();
						navigationToggle.focus();
					  }
					}
				}
			});
			
		}else{
			jQuery('.tabindex').removeAttr("tabindex");	
		}
		
		jQuery('.menu-btn, .openbtn').on('click',function(){
			jQuery('.contact-sidebar').addClass('active');
		});
		jQuery('.menu-close').on('click',function(){
			jQuery('.contact-sidebar').removeClass('active');
			jQuery('.menu-btn').removeClass('open');
		});
		
	}
	
	/* Magnific Popup ============ */
	var MagnificPopup = function(){
		'use strict';	
		
		if(jQuery('.mfp-gallery').length > 0)
		{
			/* magnificPopup function */
			jQuery('.mfp-gallery').magnificPopup({
				delegate: '.mfp-link',
				type: 'image',
				tLoading: 'Loading image #%curr%...',
				mainClass: 'mfp-img-mobile',
				gallery: {
					enabled: true,
					navigateByImgClick: true,
					preload: [0,1] /* Will preload 0 - before current, and 1 after the current image */
				},
				image: {
					tError: '<a href="%url%">The image #%curr%</a> could not be loaded.',
					titleSrc: function(item) {
						return item.el.attr('title') + '<small></small>';
					}
				}
			});
			/* magnificPopup function end */
		}
		
		if(jQuery('.mfp-video').length > 0)
		{
			/* magnificPopup for Play video function */		
			jQuery('.mfp-video').magnificPopup({
				type: 'iframe',
				iframe: {
					markup: '<div class="mfp-iframe-scaler">'+
							 '<div class="mfp-close"></div>'+
							 '<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>'+
							 '<div class="mfp-title">Some caption</div>'+
							 '</div>'
				},
				callbacks: {
					markupParse: function(template, values, item) {
						values.title = item.el.attr('title');
					}
				}
			});
			
		}

		if(jQuery('.popup-youtube, .popup-vimeo, .popup-gmaps').length > 0)
		{	
			/* magnificPopup for Play video function end */
			$('.popup-youtube, .popup-vimeo, .popup-gmaps').magnificPopup({
				disableOn: 700,
				type: 'iframe',
				mainClass: 'mfp-fade',
				removalDelay: 160,
				preloader: false,
				fixedContentPos: true
			});
		}		
	}
	
	/* Scroll To Top ============ */
	var scrollTop = function (){
		'use strict';
		var scrollTop = jQuery("button.scroltop");
		/* page scroll top on click function */	
		scrollTop.on('click',function() {
			jQuery("html, body").animate({
				scrollTop: 0
			}, 1000);
			return false;
		})

		jQuery(window).on("scroll", function() {
			var scroll = jQuery(window).scrollTop();
			if (scroll > 900) {
				jQuery("button.scroltop").fadeIn(1000);
			} else {
				jQuery("button.scroltop").fadeOut(1000);
			}
		});
		/* page scroll top on click function end*/
	}
	
	/* Header Fixed ============ */
	var headerFix = function(){
		'use strict';
		/* Main navigation fixed on top  when scroll down function custom */		
		jQuery(window).on('scroll', function () {
			if(jQuery('.sticky-header').length > 0){
				var menu = jQuery('.sticky-header');
				if ($(window).scrollTop() > menu.offset().top) {
					menu.addClass('is-fixed');
					$('.site-header .container > .logo-header .logo').attr('src','images/logo.png');
					$('.site-header .container > .logo-header .logo-2').attr('src','images/logo-2.png');
					$('.site-header .container > .logo-header .logo-3').attr('src','images/logo-3.png');
				} else {
					menu.removeClass('is-fixed');
					$('.site-header .container > .logo-header .logo, .site-header .container > .logo-header .logo-2, .site-header .container > .logo-header .logo-3').attr('src','images/logo-white.png')
				}
			}
		});
		/* Main navigation fixed on top  when scroll down function custom end*/
	}
	
	/* Masonry Box ============ */
	var masonryBox = function(){
		'use strict';
		/* masonry by  = bootstrap-select.min.js */
		if(jQuery('#masonry, .masonry').length > 0) {
			var self = jQuery("#masonry, .masonry");
	 
			if(jQuery('.card-container').length > 0)
			{
				var gutterEnable = self.data('gutter');
				
				var gutter = (self.data('gutter') === undefined)?0:self.data('gutter');
				gutter = parseInt(gutter);
				
				
				var columnWidthValue = (self.attr('data-column-width') === undefined)?'':self.attr('data-column-width');
				if(columnWidthValue != ''){columnWidthValue = parseInt(columnWidthValue);}
				
				 self.imagesLoaded(function () {
					self.masonry({
						gutterWidth: 15,
						isAnimated: true,
						itemSelector: ".card-container",
					});
					
				}); 
			} 
		}
		if(jQuery('.filters').length)
		{
			jQuery(".filters li:first").addClass('active');
			
			jQuery(".filters").on("click", "li", function() {
				jQuery('.filters li').removeClass('active');
				jQuery(this).addClass('active');
				
				var filterValue = $(this).attr("data-filter");
				self.isotope({ filter: filterValue });
			});
		}
		/* masonry by  = bootstrap-select.min.js end */
	}
	
	/* Counter Number ============ */
	var counter = function(){
		if(jQuery('.counter').length)
		{
			jQuery('.counter').counterUp({
				delay: 10,
				time: 3000
			});	
		}
	}
	
	/* Video Popup ============ */
	var handleVideo = function(){
		/* Video responsive function */	
		jQuery('iframe[src*="youtube.com"]').wrap('<div class="embed-responsive embed-responsive-16by9"></div>');
		jQuery('iframe[src*="vimeo.com"]').wrap('<div class="embed-responsive embed-responsive-16by9"></div>');	
		/* Video responsive function end */
	}
	
	/* Gallery Filter ============ */
	var handleFilterMasonary = function(){
		/* gallery filter activation = jquery.mixitup.min.js */ 
		if (jQuery('#image-gallery-mix').length) {
			jQuery('.gallery-filter').find('li').each(function () {
				$(this).addClass('filter');
			});
			jQuery('#image-gallery-mix').mixItUp();
		};
		if(jQuery('.gallery-filter.masonary').length){
			jQuery('.gallery-filter.masonary').on('click','span', function(){
				var selector = $(this).parent().attr('data-filter');
				jQuery('.gallery-filter.masonary span').parent().removeClass('active');
				jQuery(this).parent().addClass('active');
				jQuery('#image-gallery-isotope').isotope({ filter: selector });
				return false;
			});
		}
		/* gallery filter activation = jquery.mixitup.min.js */
	}
	
	/* Resizebanner ============ */
	var handleBannerResize = function(){
		$(".full-height").css("height", $(window).height());
	}
	
	/* BGEFFECT ============ */
	var reposition = function (){
		'use strict';
		var modal = jQuery(this),
		dialog = modal.find('.modal-dialog');
		modal.css('display', 'block');
		
		/* Dividing by two centers the modal exactly, but dividing by three 
		 or four works better for larger screens.  */
		dialog.css("margin-top", Math.max(0, (jQuery(window).height() - dialog.height()) / 2));
	}
	
	var handelResize = function (){
		
		/* Reposition when the window is resized */
		jQuery(window).on('resize', function() {
			jQuery('.modal:visible').each(reposition);
		});
	}
	
		/* Countdown ============ */
	var handleCountDown = function(WebsiteLaunchDate){
		/* Time Countr Down Js */
		if($(".countdown").length)
		{
			var launchDate = jQuery('.countdown').data('date');
			
			if(launchDate != undefined && launchDate != '')
			{
				WebsiteLaunchDate = launchDate;
			}
			
			$('.countdown').countdown({date: WebsiteLaunchDate+' 23:5'}, function() {
				$('.countdown').text('we are live');
			});
		}
		/* Time Countr Down Js End */
	}
	
	/* Website Launch Date */ 
	var WebsiteLaunchDate = new Date();
	var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
	WebsiteLaunchDate.setMonth(WebsiteLaunchDate.getMonth() + 1);
	WebsiteLaunchDate =  WebsiteLaunchDate.getDate() + " " + monthNames[WebsiteLaunchDate.getMonth()] + " " + WebsiteLaunchDate.getFullYear();
	/* Website Launch Date END */ 
	
	
	/* Light Gallery ============ */
	var lightGallery = function (){
		if(($('#lightgallery, .lightgallery').length > 0)){
			$('#lightgallery, .lightgallery').lightGallery({
				selector : '.lightimg',
				loop:true,
				thumbnail:true,
				exThumbImage: 'data-exthumbimage',
				download: false,
				share: false,
			});
		}
	}	

	var boxHover = function(){
		jQuery('.box-hover').on('mouseenter',function(){
			var selector = jQuery(this).parent().parent();
			selector.find('.box-hover').removeClass('active');
			jQuery(this).addClass('active');
		});
	}
	
	var pointerEffect = function(){
		/*  pointer.js was created by OwL for use on websites, and can be found at https://seattleowl.com/pointer. */
		
		if(screenWidth > 991 ){
			const pointer = document.createElement("div")
			pointer.id = "pointer-dot"
			const ring = document.createElement("div")
			ring.id = "pointer-ring"
			document.body.insertBefore(pointer, document.body.children[0])
			document.body.insertBefore(ring, document.body.children[0])

			let mouseX = -100
			let mouseY = -100
			let ringX = -100
			let ringY = -100
			let isHover = false
			let mouseDown = false
			const init_pointer = (options) => {

				window.onmousemove = (mouse) => {
					mouseX = (mouse.clientX != undefined)?mouse.clientX:-100;
					mouseY = (mouse.clientY != undefined)?mouse.clientY:-100;
				}

				window.onmousedown = (mouse) => {
					mouseDown = true
				}

				window.onmouseup = (mouse) => {
					mouseDown = false
				}

				const trace = (a, b, n) => {
					return (1 - n) * a + n * b;
				}
				window["trace"] = trace

				const getOption = (option) => {
					let defaultObj = {
						pointerColor: "#750c7e",
						ringSize: 15,
						ringClickSize: (options["ringSize"] || 15) - 5,
					}
					if (options[option] == undefined) {
						return defaultObj[option]
					} else {
						return options[option]
					}
				}

				const render = () => {
					if(mouseX != undefined){
						ringX = trace(ringX, mouseX, 0.2)
						ringY = trace(ringY, mouseY, 0.2)
		
						if (document.querySelector(".p-action-click:hover")) {
							pointer.style.borderColor = getOption("pointerColor")
							isHover = true
						} else {
							pointer.style.borderColor = "white"
							isHover = false
						}
						ring.style.borderColor = getOption("pointerColor")
						if (mouseDown) {
							ring.style.padding = getOption("ringClickSize") + "px"
						} else {
							ring.style.padding = getOption("ringSize") + "px"
						}
						
						pointer.style.transform = `translate(${mouseX}px, ${mouseY}px)`
						
						ring.style.transform = `translate(${ringX - (mouseDown ? getOption("ringClickSize") : getOption("ringSize"))}px, ${ringY - (mouseDown ? getOption("ringClickSize") : getOption("ringSize"))}px)`
		
						requestAnimationFrame(render)
					}
				}
				requestAnimationFrame(render)
			}
			
			jQuery('a').on('mousemove',function(e){
				jQuery('#pointer-ring').addClass('active');
			});
			
			jQuery('a').on('mouseleave',function(e){
				jQuery('#pointer-ring').removeClass('active');
			});

			init_pointer({});	
		}
	}
	
	
	/* Equal Height ============ */
	var equalWidthSideNav = function() {
		
		if(screenWidth > 991)
		{
			jQuery('header.style-2 .extra-nav, .extra-nav-left').css('width','');
			var extraNavWidth = jQuery('header.style-2 .extra-nav').width();
			var sidebarNavWidth = jQuery('header.style-2 .extra-nav-left').width();
			
			if(sidebarNavWidth > extraNavWidth)
			{
				jQuery('header.style-2 .extra-nav, .extra-nav-left').css('width',sidebarNavWidth+'px');
			}else{
				jQuery('header.style-2 .extra-nav, .extra-nav-left').css('width',extraNavWidth+'px');
			}
		}else{
			jQuery('header.style-2 .extra-nav, .extra-nav-left').css('width','');
		}
	}

	/* Image Lazy Loading start */
	var handleLazyLoading = function(){
		
		/* On Image Tag */
		jQuery('.dz-lazy').lazyload();
		
		/* On Background Image */
		jQuery('.dz-lazy-background').each(function(){
			var imgSrc = jQuery(this).data('src');
            if(imgSrc !== undefined) {
				
                var elementStyle = jQuery(this).attr('style');
                var elementStyle2 = elementStyle.replace('url('+siteUrl+'assets/images/loading.svg)', 'url('+imgSrc+')');
                jQuery(this).attr('style',elementStyle2);
            }
		});
	}
	/* Image Lazy Loading END */
	
	/* setResizeMargin ============ */
	var setResizeMargin = function(){
		if(($('.setResizeMargin').length > 0) && screenWidth >= 1280){
			var containerSize = $('.container').width();
			var getMargin = (screenWidth - containerSize)/2;
			$('.setResizeMargin').css('margin-left',getMargin);
		}
		
	}
	
	var radialProgress = function(){

		// Remove svg.radial-progress .complete inline styling
		$('svg.radial-progress').each(function( index, value ) { 
			$(this).find($('circle.complete')).removeAttr( 'style' );
		});

		// Activate progress animation on scroll
		$(window).scroll(function(){
			$('svg.radial-progress').each(function( index, value ) { 
				// If svg.radial-progress is approximately 25% vertically into the window when scrolling from the top or the bottom
				if ( 
					$(window).scrollTop() > $(this).offset().top - ($(window).height() * 0.75) &&
					$(window).scrollTop() < $(this).offset().top + $(this).height() - ($(window).height() * 0.25)
				) {
					// Get percentage of progress
					percent = $(value).data('percentage');
					// Get radius of the svg's circle.complete
					radius = $(this).find($('circle.complete')).attr('r');
					// Get circumference (2πr)
					circumference = 2 * Math.PI * radius;
					// Get stroke-dashoffset value based on the percentage of the circumference
					strokeDashOffset = circumference - ((percent * circumference) / 100);
					// Transition progress for 1.25 seconds
					$(this).find($('circle.complete')).animate({'stroke-dashoffset': strokeDashOffset}, 1250);
				}
			});
		}).trigger('scroll');

	}
	
	/* Function ============ */
	return {
		init:function(){
			boxHover();
			onePageLayout();
			dzTheme();
			homeSearch();
			MagnificPopup();
			scrollTop();
			headerFix();
			handleVideo();
			handleFilterMasonary();
			handleCountDown(WebsiteLaunchDate);
			handleBannerResize();
			handelResize();
			lightGallery();
			pointerEffect();
			jQuery('.modal').on('show.bs.modal', reposition);
			
		},

		
		load:function(){
			counter();
			masonryBox();
			handleLazyLoading();
			equalWidthSideNav();
		},
		
		resize:function(){
			screenWidth = $(window).width();
			dzTheme();
			
			setTimeout(function(){
				equalWidthSideNav();
			}, 500);
			
		}
	}
	
}();

/* Document.ready Start */
jQuery(document).ready(function() {
    'use strict';
	W3Construct.init();
	
	$('a[data-toggle="tab"]').on('click',function(){
		/* todo remove snippet on bootstrap v4 */
		$('a[data-toggle="tab"]').on('click',function() {
		  $($(this).attr('href')).show().addClass('show active').siblings().hide();
		})
	});	
		
	jQuery('.navicon').on('click',function(){
		$(this).toggleClass('open');
	});

});
/* Document.ready END */

/* Window Load START */
jQuery(window).on('load',function () {
	'use strict'; 
	W3Construct.load();
	setTimeout(function(){
		jQuery('#loading-area').remove();
	}, 1000);
	document.body.addEventListener( 'keydown', function() {
		document.body.classList.add( 'show-focus-outline' );
	});

	document.body.addEventListener( 'mousedown', function() {
		document.body.classList.remove( 'show-focus-outline' );
	});
	
});
/*  Window Load END */

/* Window Resize START */
jQuery(window).on('resize',function () {
	'use strict'; 
	W3Construct.resize();
});
/*  Window Resize END */

})(window.jQuery);