<?php
/**
 * The Template for displaying 404 page
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

get_header();

global $w3construct_option;


$error_404_bg           = w3construct_set( $w3construct_option, 'error_404_bg' );
$error_page_title       = w3construct_set( $w3construct_option, 'error_page_title' );
$error_page_text        = w3construct_set( $w3construct_option, 'error_page_text' );
$error_page_button_text = w3construct_set( $w3construct_option, 'error_page_button_text' );

w3construct_get_banner();
?>
<!-- Error Page -->
<section class="content-inner-1 line-img" <?php if ( ! empty( $error_404_bg ) ) { ?>
		style="background-image:url(<?php echo esc_url( $error_404_bg ); ?>); background-position:right bottom; background-size:100%; background-repeat:no-repeat;"
	<?php } ?>>
	<div class="container">
		<div class="error-page text-center">
			<div class="dlab_error">
				<?php echo wp_kses( $error_page_title, 'string' ); ?>
			</div>
			<h2 class="error-head">
				<?php echo wp_kses( $error_page_text, 'string' ); ?>
			</h2>
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn btn-primary radius-no btn-rounded">
				<span class="p-lr15">
					<?php echo wp_kses( $error_page_button_text, 'string' ); ?>
				</span>
			</a>
		</div>
	</div>
</section>

<!-- Content END-->
<?php

get_footer();
