<?php
/**
 * Template Name: Custom Home Page
 */

get_header(); ?>

<main id="maincontent" role="main">  
  <?php do_action( 'vw_minimalist_before_slider' ); ?>

  <?php if( get_theme_mod( 'vw_minimalist_slider_arrows', true) == 1 || get_theme_mod( 'vw_minimalist_resp_slider_hide_show', true) == 1) { ?>
    <?php if(get_theme_mod('vw_minimalist_slider_type', 'Default slider') == 'Default slider' ){ ?>
      <section id="slider">
          <div id="carouselExampleCaptions" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="<?php echo esc_attr(get_theme_mod( 'vw_minimalist_slider_speed',3000)) ?>"> 
            <?php $vw_minimalist_pages = array();
              for ( $count = 1; $count <= 3; $count++ ) {
                $mod = intval( get_theme_mod( 'vw_minimalist_slider_page' . $count ));
                if ( 'page-none-selected' != $mod ) {
                  $vw_minimalist_pages[] = $mod;
                }
              }
              if( !empty($vw_minimalist_pages) ) :
              $args = array(
                'post_type' => 'page',
                'post__in' => $vw_minimalist_pages,
                'orderby' => 'post__in'
              );
              $query = new WP_Query( $args );
              if ( $query->have_posts() ) :
                $i = 1;
            ?>
            <div class="carousel-inner" role="listbox">
              <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
              <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
                <div class="container">
                  <div class="row">
                    <div class="col-lg-6 col-md-6">
                      <div class="carousel-caption">
                        <div class="inner_carousel">
                          <h1 class="wow zoomInDown delay-1000" data-wow-duration="2s"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
                          <p class="wow zoomInDown delay-1000" data-wow-duration="2s"><?php $vw_minimalist_excerpt = get_the_excerpt(); echo esc_html( vw_minimalist_string_limit_words( $vw_minimalist_excerpt, esc_attr(get_theme_mod('vw_minimalist_slider_excerpt_number','20')))); ?></p>
                          <?php
                            $vw_minimalist_button_text = get_theme_mod('vw_minimalist_slider_button_text','READ MORE');
                            $vw_minimalist_button_link = get_theme_mod('vw_minimalist_slider_button_link', '');
                            if (empty($vw_minimalist_button_link)) {
                              $vw_minimalist_button_link = get_permalink();
                            }
                            if ($vw_minimalist_button_text || !empty($vw_minimalist_button_link)) { ?>
                            <div class="read-btn wow zoomInDown delay-1000" data-wow-duration="2s">
                              <?php if( get_theme_mod('vw_minimalist_slider_button_text','READ MORE') != ''){ ?>
                                <a href="<?php echo esc_url($vw_minimalist_button_link); ?>" class="button redmor">
                                <?php echo esc_html($vw_minimalist_button_text); ?><span class="screen-reader-text"><?php echo esc_html($vw_minimalist_button_text); ?></span>
                                </a>
                              <?php } ?>
                            </div>
                          <?php } ?>
                        </div>
                      </div>
                    </div>
                    <div class="col-lg-6 col-md-6 slider-image-box">
                      <div class="slider-img"></div>
                      <a href="<?php the_permalink();?>">
                        <?php if(has_post_thumbnail()){
                          the_post_thumbnail();
                        } else{?>
                          <img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/block-patterns/images/banner-img.png" alt="" />
                        <?php } ?>
                      </a>
                    </div>
                  </div>
                </div>
              </div>
              <?php $i++; endwhile; 
              wp_reset_postdata();?>
            </div>
            <?php else : ?>
            <div class="no-postfound"></div>
              <?php endif;
            endif;?>
            <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
              <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-chevron-left"></i></span>
              <span class="screen-reader-text"><?php esc_html_e( 'Previous','vw-minimalist' );?></span>
            </a>
            <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
              <span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-chevron-right"></i></span>
              <span class="screen-reader-text"><?php esc_html_e( 'Next','vw-minimalist' );?></span>
            </a>
          </div>
          <div class="clearfix"></div>
      </section>
    <?php } else if(get_theme_mod('vw_minimalist_slider_type', 'Advance slider') == 'Advance slider'){?>
      <?php echo do_shortcode(get_theme_mod('vw_minimalist_advance_slider_shortcode')); ?>
    <?php } ?>
  <?php }?>

  <?php do_action( 'vw_minimalist_after_slider' ); ?>

  <?php if( get_theme_mod('vw_minimalist_services_category') != '' ){ ?>
    <section id="services-sec" class="wow slideInRight delay-1000" data-wow-duration="2s">
      <div class="container">
        <div class="heading-text">        
          <?php if( get_theme_mod( 'vw_minimalist_section_text') != '') { ?>
            <p class="sec-text"><?php echo esc_html(get_theme_mod('vw_minimalist_section_text',''));?></p>
          <?php } ?>
          <?php if( get_theme_mod( 'vw_minimalist_section_title') != '') { ?>
            <h2><?php echo esc_html(get_theme_mod('vw_minimalist_section_title',''));?></h2>
          <?php } ?>
        </div>
        <div class="row">
          <?php 
          $vw_minimalist_catData=  get_theme_mod('vw_minimalist_services_category');
            if($vw_minimalist_catData){
              $page_query = new WP_Query(array( 'category_name' => esc_html( $vw_minimalist_catData ,'vw-minimalist')));?>
                <?php while( $page_query->have_posts() ) : $page_query->the_post(); ?>
                  <div class="col-lg-3 col-md-4">
                    <div class="inner-box">
                      <?php the_post_thumbnail(); ?>
                      <h3><a href="<?php the_permalink();?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h3>
                      <p><?php $vw_minimalist_excerpt = get_the_excerpt(); echo esc_html( vw_minimalist_string_limit_words( $vw_minimalist_excerpt, esc_attr(get_theme_mod('vw_minimalist_services_excerpt_number','20')))); ?></p>
                      <div class="read-more-arrow"><a href="<?php the_permalink(); ?>"><i class="<?php echo esc_attr(get_theme_mod('vw_minimalist_services_read_more_icon','fas fa-calendar-alt')); ?>"></i></a></div>
                    </div>
                  </div>
                <?php endwhile;
              wp_reset_postdata();
            } ?>
        </div>
      </div>
    </section>
  <?php }?>

  <?php do_action( 'vw_minimalist_after_service' ); ?>

  <div id="content-vw">
    <div class="container">
      <?php while ( have_posts() ) : the_post(); ?>
        <?php the_content(); ?>
      <?php endwhile; // end of the loop. ?>
    </div>
  </div>

</main>

<?php get_footer(); ?>