<?php
/**
 * VW Minimalist Theme Customizer
 *
 * @package VW Minimalist
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function vw_minimalist_custom_controls() {
	load_template( trailingslashit( get_template_directory() ) . '/inc/custom-controls.php' );
}
add_action( 'customize_register', 'vw_minimalist_custom_controls' );

function vw_minimalist_customize_register( $wp_customize ) {

	load_template( trailingslashit( get_template_directory() ) . '/inc/icon-picker.php' );

	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage'; 
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'blogname', array( 
		'selector' => '.logo .site-title a', 
	 	'render_callback' => 'vw_minimalist_customize_partial_blogname', 
	)); 

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array( 
		'selector' => 'p.site-description', 
		'render_callback' => 'vw_minimalist_customize_partial_blogdescription', 
	));

	//add home page setting pannel
	$vw_minimalist_parent_panel = new VW_Minimalist_WP_Customize_Panel( $wp_customize, 'vw_minimalist_panel_id', array(
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => esc_html__( 'VW Settings', 'vw-minimalist' ),
		'priority' => 10,
	));

	//Menus Settings
	$wp_customize->add_section( 'vw_minimalist_menu_section' , array(
    	'title' => __( 'Menus Settings', 'vw-minimalist' ),
		'panel' => 'vw_minimalist_panel_id'
	) );

	$wp_customize->add_setting('vw_minimalist_navigation_menu_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_navigation_menu_font_size',array(
		'label'	=> __('Menus Font Size','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_menu_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_navigation_menu_font_weight',array(
        'default' => 700,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_navigation_menu_font_weight',array(
        'type' => 'select',
        'label' => __('Menus Font Weight','vw-minimalist'),
        'section' => 'vw_minimalist_menu_section',
        'choices' => array(
        	'100' => __('100','vw-minimalist'),
            '200' => __('200','vw-minimalist'),
            '300' => __('300','vw-minimalist'),
            '400' => __('400','vw-minimalist'),
            '500' => __('500','vw-minimalist'),
            '600' => __('600','vw-minimalist'),
            '700' => __('700','vw-minimalist'),
            '800' => __('800','vw-minimalist'),
            '900' => __('900','vw-minimalist'),
        ),
	) );

	// text trasform
	$wp_customize->add_setting('vw_minimalist_menu_text_transform',array(
		'default'=> 'Uppercase',
		'sanitize_callback'	=> 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_menu_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Menus Text Transform','vw-minimalist'),
		'choices' => array(
            'Uppercase' => __('Uppercase','vw-minimalist'),
            'Capitalize' => __('Capitalize','vw-minimalist'),
            'Lowercase' => __('Lowercase','vw-minimalist'),
        ),
		'section'=> 'vw_minimalist_menu_section',
	));

	$wp_customize->add_setting('vw_minimalist_header_menus_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_header_menus_color', array(
		'label'    => __('Menus Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_menu_section',
	)));

	$wp_customize->add_setting('vw_minimalist_header_menus_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_header_menus_hover_color', array(
		'label'    => __('Menus Hover Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_menu_section',
	)));

	$wp_customize->add_setting('vw_minimalist_header_submenus_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_header_submenus_color', array(
		'label'    => __('Sub Menus Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_menu_section',
	)));

	$wp_customize->add_setting('vw_minimalist_header_submenus_hover_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_header_submenus_hover_color', array(
		'label'    => __('Sub Menus Hover Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_menu_section',
	)));

	$wp_customize->add_setting('vw_minimalist_menus_item_style',array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_menus_item_style',array(
        'type' => 'select',
        'section' => 'vw_minimalist_menu_section',
		'label' => __('Menu Item Hover Style','vw-minimalist'),
		'choices' => array(
            'None' => __('None','vw-minimalist'),
            'Zoom In' => __('Zoom In','vw-minimalist'),
        ),
	) );

	//Slider
	$wp_customize->add_section( 'vw_minimalist_slidersettings' , array(
    	'title'      => __( 'Slider Settings', 'vw-minimalist' ),
    	'description' => __('Free theme has 3 slides options, For unlimited slides and more options <a class="go-pro-btn" target="blank" href="https://www.vwthemes.com/products/minimalist-wordpress-theme">GET PRO</a>','vw-minimalist'),
		'panel' => 'vw_minimalist_panel_id'
	) );

	$wp_customize->add_setting( 'vw_minimalist_slider_arrows',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_slider_arrows',array(
      	'label' => esc_html__( 'Show / Hide Slider','vw-minimalist' ),
      	'section' => 'vw_minimalist_slidersettings'
    )));

    $wp_customize->add_setting('vw_minimalist_slider_type',array(
        'default' => 'Default slider',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	) );
	$wp_customize->add_control('vw_minimalist_slider_type', array(
        'type' => 'select',
        'label' => __('Slider Type','vw-minimalist'),
        'section' => 'vw_minimalist_slidersettings',
        'choices' => array(
            'Default slider' => __('Default slider','vw-minimalist'),
            'Advance slider' => __('Advance slider','vw-minimalist'),
        ),
	));

	$wp_customize->add_setting('vw_minimalist_advance_slider_shortcode',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_advance_slider_shortcode',array(
		'label'	=> __('Add Slider Shortcode','vw-minimalist'),
		'section'=> 'vw_minimalist_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_minimalist_advance_slider'
	));

    //Selective Refresh
    $wp_customize->selective_refresh->add_partial('vw_minimalist_slider_arrows',array(
		'selector'        => '#slider .carousel-caption h1',
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_slider_arrows',
	));

	for ( $count = 1; $count <= 3; $count++ ) {
		$wp_customize->add_setting( 'vw_minimalist_slider_page' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'vw_minimalist_sanitize_dropdown_pages'
		) );
		$wp_customize->add_control( 'vw_minimalist_slider_page' . $count, array(
			'label'    => __( 'Select Slider Page', 'vw-minimalist' ),
			'description' => __('Slider image size (350 x 350)','vw-minimalist'),
			'section'  => 'vw_minimalist_slidersettings',
			'type'     => 'dropdown-pages',
			'active_callback' => 'vw_minimalist_default_slider'
		) );
	}

	$wp_customize->add_setting('vw_minimalist_slider_button_text',array(
		'default'=> 'READ MORE',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_slider_button_text',array(
		'label'	=> __('Add Slider Button Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'READ MORE', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_minimalist_default_slider'
	));

	$wp_customize->add_setting('vw_minimalist_slider_button_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('vw_minimalist_slider_button_link',array(
		'label'	=> esc_html__('Add Button Link','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => esc_html__( 'www.example-info.com', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_slidersettings',
		'type'=> 'url'
	));

	//content layout
	$wp_customize->add_setting('vw_minimalist_slider_content_option',array(
        'default' => 'Left',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Minimalist_Image_Radio_Control($wp_customize, 'vw_minimalist_slider_content_option', array(
        'type' => 'select',
        'label' => __('Slider Content Layouts','vw-minimalist'),
        'section' => 'vw_minimalist_slidersettings',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/assets/images/slider-content1.png',
            'Center' => esc_url(get_template_directory_uri()).'/assets/images/slider-content2.png',
            'Right' => esc_url(get_template_directory_uri()).'/assets/images/slider-content3.png',
    ),'active_callback' => 'vw_minimalist_default_slider'
    )));

    //Slider content padding
    $wp_customize->add_setting('vw_minimalist_slider_content_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_slider_content_padding_top_bottom',array(
		'label'	=> __('Slider Content Padding Top Bottom','vw-minimalist'),
		'description'	=> __('Enter a value in %. Example:20%','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '50%', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_minimalist_default_slider'
	));

	$wp_customize->add_setting('vw_minimalist_slider_content_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_slider_content_padding_left_right',array(
		'label'	=> __('Slider Content Padding Left Right','vw-minimalist'),
		'description'	=> __('Enter a value in %. Example:20%','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '50%', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_slidersettings',
		'type'=> 'text',
		'active_callback' => 'vw_minimalist_default_slider'
	));

    //Slider excerpt
	$wp_customize->add_setting( 'vw_minimalist_slider_excerpt_number', array(
		'default'              => 20,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_slider_excerpt_number', array(
		'label'       => esc_html__( 'Slider Excerpt length','vw-minimalist' ),
		'section'     => 'vw_minimalist_slidersettings',
		'type'        => 'range',
		'settings'    => 'vw_minimalist_slider_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),'active_callback' => 'vw_minimalist_default_slider'
	) );

	$wp_customize->add_setting( 'vw_minimalist_slider_speed', array(
		'default'  => 3000,
		'sanitize_callback'	=> 'vw_minimalist_sanitize_float'
	) );
	$wp_customize->add_control( 'vw_minimalist_slider_speed', array(
		'label' => esc_html__('Slider Transition Speed','vw-minimalist'),
		'section' => 'vw_minimalist_slidersettings',
		'type'  => 'number',
		'active_callback' => 'vw_minimalist_default_slider'
	) );

	//Feature Section
	$wp_customize->add_section('vw_minimalist_feature', array(
		'title'       => __('Feature Section', 'vw-minimalist'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-minimalist'),
		'priority'    => null,
		'panel'       => 'vw_minimalist_panel_id',
	));

	$wp_customize->add_setting('vw_minimalist_feature_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_feature_text',array(
		'description' => __('<p>1. More options for feature section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for feature section.</p>','vw-minimalist'),
		'section'=> 'vw_minimalist_feature',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_minimalist_feature_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_feature_btn',array(
		'description' => "<a class='go-pro' target='_blank' href='". admin_url('themes.php?page=vw_minimalist_guide') ." '>More Info</a>",
		'section'=> 'vw_minimalist_feature',
		'type'=> 'hidden'
	));

	//About Us Section
	$wp_customize->add_section('vw_minimalist_about', array(
		'title'       => __('About Us Section', 'vw-minimalist'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-minimalist'),
		'priority'    => null,
		'panel'       => 'vw_minimalist_panel_id',
	));

	$wp_customize->add_setting('vw_minimalist_about_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_about_text',array(
		'description' => __('<p>1. More options for about us section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for about us section.</p>','vw-minimalist'),
		'section'=> 'vw_minimalist_about',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_minimalist_about_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_about_btn',array(
		'description' => "<a class='go-pro' target='_blank' href='". admin_url('themes.php?page=vw_minimalist_guide') ." '>More Info</a>",
		'section'=> 'vw_minimalist_about',
		'type'=> 'hidden'
	));
 
	//Services
	$wp_customize->add_section('vw_minimalist_services',array(
		'title'	=> __('Services Section','vw-minimalist'),
		'description' => __('For more options of the services section <a class="go-pro-btn" target="blank" href="https://www.vwthemes.com/products/minimalist-wordpress-theme">GET PRO</a>','vw-minimalist'),
		'panel' => 'vw_minimalist_panel_id',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_minimalist_section_title', array( 
		'selector' => '.heading-text h2', 
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_section_title',
	));

	$wp_customize->add_setting('vw_minimalist_section_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('vw_minimalist_section_text',array(
		'label'	=> __('Section Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Services', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_services',
		'type'=> 'text'
	));	

	$wp_customize->add_setting('vw_minimalist_section_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('vw_minimalist_section_title',array(
		'label'	=> __('Section Title','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Services We Provide', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_services',
		'type'=> 'text'
	));	

	$categories = get_categories();
		$cat_posts = array();
			$i = 0;
			$cat_posts[]='Select';	
		foreach($categories as $category){
			if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_posts[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('vw_minimalist_services_category',array(
		'default'	=> 'select',
		'sanitize_callback' => 'vw_minimalist_sanitize_choices',
	));
	$wp_customize->add_control('vw_minimalist_services_category',array(
		'type'    => 'select',
		'choices' => $cat_posts,
		'label' => __('Select Category to display Latest Post','vw-minimalist'),		
		'section' => 'vw_minimalist_services',
	));

	//Services excerpt
	$wp_customize->add_setting( 'vw_minimalist_services_excerpt_number', array(
		'default'              => 20,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_services_excerpt_number', array(
		'label'       => esc_html__( 'Services Excerpt length','vw-minimalist' ),
		'section'     => 'vw_minimalist_services',
		'type'        => 'range',
		'settings'    => 'vw_minimalist_services_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_minimalist_services_read_more_icon',array(
		'default'	=> 'fas fa-arrow-right',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_services_read_more_icon',array(
		'label'	=> __('Add Services Read More Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_services',
		'type'		=> 'icon'
	)));

	//Portfolio Section
	$wp_customize->add_section('vw_minimalist_portfolio', array(
		'title'       => __('Portfolio Section', 'vw-minimalist'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-minimalist'),
		'priority'    => null,
		'panel'       => 'vw_minimalist_panel_id',
	));

	$wp_customize->add_setting('vw_minimalist_portfolio_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_portfolio_text',array(
		'description' => __('<p>1. More options for portfolio section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for portfolio section.</p>','vw-minimalist'),
		'section'=> 'vw_minimalist_portfolio',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_minimalist_portfolio_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_portfolio_btn',array(
		'description' => "<a class='go-pro' target='_blank' href='". admin_url('themes.php?page=vw_minimalist_guide') ." '>More Info</a>",
		'section'=> 'vw_minimalist_portfolio',
		'type'=> 'hidden'
	));

	//Team Section
	$wp_customize->add_section('vw_minimalist_team', array(
		'title'       => __('Team Section', 'vw-minimalist'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-minimalist'),
		'priority'    => null,
		'panel'       => 'vw_minimalist_panel_id',
	));

	$wp_customize->add_setting('vw_minimalist_team_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_team_text',array(
		'description' => __('<p>1. More options for team section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for team section.</p>','vw-minimalist'),
		'section'=> 'vw_minimalist_team',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_minimalist_team_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_team_btn',array(
		'description' => "<a class='go-pro' target='_blank' href='". admin_url('themes.php?page=vw_minimalist_guide') ." '>More Info</a>",
		'section'=> 'vw_minimalist_team',
		'type'=> 'hidden'
	));

	//Partners Section
	$wp_customize->add_section('vw_minimalist_partners', array(
		'title'       => __('Partners Section', 'vw-minimalist'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-minimalist'),
		'priority'    => null,
		'panel'       => 'vw_minimalist_panel_id',
	));

	$wp_customize->add_setting('vw_minimalist_partners_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_partners_text',array(
		'description' => __('<p>1. More options for partners section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for partners section.</p>','vw-minimalist'),
		'section'=> 'vw_minimalist_partners',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_minimalist_partners_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_partners_btn',array(
		'description' => "<a class='go-pro' target='_blank' href='". admin_url('themes.php?page=vw_minimalist_guide') ." '>More Info</a>",
		'section'=> 'vw_minimalist_partners',
		'type'=> 'hidden'
	));

	//Testimonial Section
	$wp_customize->add_section('vw_minimalist_testimonial', array(
		'title'       => __('Testimonial Section', 'vw-minimalist'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-minimalist'),
		'priority'    => null,
		'panel'       => 'vw_minimalist_panel_id',
	));

	$wp_customize->add_setting('vw_minimalist_testimonial_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_testimonial_text',array(
		'description' => __('<p>1. More options for testimonial section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for testimonial section.</p>','vw-minimalist'),
		'section'=> 'vw_minimalist_testimonial',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_minimalist_testimonial_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_testimonial_btn',array(
		'description' => "<a class='go-pro' target='_blank' href='". admin_url('themes.php?page=vw_minimalist_guide') ." '>More Info</a>",
		'section'=> 'vw_minimalist_testimonial',
		'type'=> 'hidden'
	));


	//Blog Section
	$wp_customize->add_section('vw_minimalist_blog', array(
		'title'       => __('Blog Section', 'vw-minimalist'),
		'description' => __('<p class="premium-opt">Premium Theme Features</p>','vw-minimalist'),
		'priority'    => null,
		'panel'       => 'vw_minimalist_panel_id',
	));

	$wp_customize->add_setting('vw_minimalist_blog_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_blog_text',array(
		'description' => __('<p>1. More options for blog section.</p>
			<p>2. Unlimited images options.</p>
			<p>3. Color options for blog section.</p>','vw-minimalist'),
		'section'=> 'vw_minimalist_blog',
		'type'=> 'hidden'
	));

	$wp_customize->add_setting('vw_minimalist_blog_btn',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_blog_btn',array(
		'description' => "<a class='go-pro' target='_blank' href='". admin_url('themes.php?page=vw_minimalist_guide') ." '>More Info</a>",
		'section'=> 'vw_minimalist_blog',
		'type'=> 'hidden'
	));

	//Footer Text
	$wp_customize->add_section('vw_minimalist_footer',array(
		'title'	=> __('Footer Settings','vw-minimalist'),
		'description' => __('For more options of the footer section <a class="go-pro-btn" target="blank" href="https://www.vwthemes.com/products/minimalist-wordpress-theme">GET PRO</a>','vw-minimalist'),
		'panel' => 'vw_minimalist_panel_id',
	));	

	$wp_customize->add_setting( 'vw_minimalist_footer_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));
    $wp_customize->add_control( new vw_minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_footer_hide_show',array(
      'label' => esc_html__( 'Show / Hide Footer','vw-minimalist' ),
      'section' => 'vw_minimalist_footer'
    )));

     // font size
	$wp_customize->add_setting('vw_minimalist_button_footer_font_size',array(
		'default'=> 25,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_button_footer_font_size',array(
		'label'	=> __('Footer Heading Font Size','vw-minimalist'),
  		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'vw_minimalist_footer',
	));

	$wp_customize->add_setting('vw_minimalist_button_footer_heading_letter_spacing',array(
		'default'=> 1,
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_button_footer_heading_letter_spacing',array(
		'label'	=> __('Heading Letter Spacing','vw-minimalist'),
  		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
	),
		'section'=> 'vw_minimalist_footer',
	));

	// text trasform
	$wp_customize->add_setting('vw_minimalist_button_footer_text_transform',array(
		'default'=> 'Capitalize',
		'sanitize_callback'	=> 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_button_footer_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Heading Text Transform','vw-minimalist'),
		'choices' => array(
      'Uppercase' => __('Uppercase','vw-minimalist'),
      'Capitalize' => __('Capitalize','vw-minimalist'),
      'Lowercase' => __('Lowercase','vw-minimalist'),
    ),
		'section'=> 'vw_minimalist_footer',
	));

	$wp_customize->add_setting('vw_minimalist_footer_heading_weight',array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_footer_heading_weight',array(
        'type' => 'select',
        'label' => __('Heading Font Weight','vw-minimalist'),
        'section' => 'vw_minimalist_footer',
        'choices' => array(
        	'100' => __('100','vw-minimalist'),
            '200' => __('200','vw-minimalist'),
            '300' => __('300','vw-minimalist'),
            '400' => __('400','vw-minimalist'),
            '500' => __('500','vw-minimalist'),
            '600' => __('600','vw-minimalist'),
            '700' => __('700','vw-minimalist'),
            '800' => __('800','vw-minimalist'),
            '900' => __('900','vw-minimalist'),
        ),
	) );

  	$wp_customize->add_setting('vw_minimalist_footer_template',array(
	    'default'	=> esc_html('vw-minimalist-footer-one'),
	    'sanitize_callback'	=> 'vw_minimalist_sanitize_choices'
  	));
 	$wp_customize->add_control('vw_minimalist_footer_template',array(
        'label'	=> esc_html__('Footer style','vw-minimalist'),
        'section'	=> 'vw_minimalist_footer',
        'setting'	=> 'vw_minimalist_footer_template',
        'type' => 'select',
        'choices' => array(
            'vw-minimalist-footer-one' => esc_html__('Style 1', 'vw-minimalist'),
            'vw-minimalist-footer-two' => esc_html__('Style 2', 'vw-minimalist'),
            'vw-minimalist-footer-three' => esc_html__('Style 3', 'vw-minimalist'),
            'vw-minimalist-footer-four' => esc_html__('Style 4', 'vw-minimalist'),
            'vw-minimalist-footer-five' => esc_html__('Style 5', 'vw-minimalist'),
        )
  	));

	$wp_customize->add_setting('vw_minimalist_footer_background_color', array(
		'default'           => '#222222',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_footer_background_color', array(
		'label'    => __('Footer Background Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_footer',
	)));

	$wp_customize->add_setting('vw_minimalist_footer_background_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'vw_minimalist_footer_background_image',array(
        'label' => __('Footer Background Image','vw-minimalist'),
        'section' => 'vw_minimalist_footer'
	)));

	$wp_customize->add_setting('vw_minimalist_footer_img_position',array(
	  'default' => 'center center',
	  'transport' => 'refresh',
	  'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_footer_img_position',array(
		'type' => 'select',
		'label' => __('Footer Image Position','vw-minimalist'),
		'section' => 'vw_minimalist_footer',
		'choices' 	=> array(
			'left top' 		=> esc_html__( 'Top Left', 'vw-minimalist' ),
			'center top'   => esc_html__( 'Top', 'vw-minimalist' ),
			'right top'   => esc_html__( 'Top Right', 'vw-minimalist' ),
			'left center'   => esc_html__( 'Left', 'vw-minimalist' ),
			'center center'   => esc_html__( 'Center', 'vw-minimalist' ),
			'right center'   => esc_html__( 'Right', 'vw-minimalist' ),
			'left bottom'   => esc_html__( 'Bottom Left', 'vw-minimalist' ),
			'center bottom'   => esc_html__( 'Bottom', 'vw-minimalist' ),
			'right bottom'   => esc_html__( 'Bottom Right', 'vw-minimalist' ),
		),
	)); 

	// Footer
	$wp_customize->add_setting('vw_minimalist_img_footer',array(
		'default'=> 'scroll',
		'sanitize_callback'	=> 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_img_footer',array(
		'type' => 'select',
		'label'	=> __('Footer Background Attatchment','vw-minimalist'),
		'choices' => array(
            'fixed' => __('fixed','vw-minimalist'),
            'scroll' => __('scroll','vw-minimalist'),
        ),
		'section'=> 'vw_minimalist_footer',
	));

	$wp_customize->add_setting('vw_minimalist_footer_widgets_heading',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_footer_widgets_heading',array(
        'type' => 'select',
        'label' => __('Footer Widget Heading','vw-minimalist'),
        'section' => 'vw_minimalist_footer',
        'choices' => array(
        	'Left' => __('Left','vw-minimalist'),
            'Center' => __('Center','vw-minimalist'),
            'Right' => __('Right','vw-minimalist')
        ),
	) );

	$wp_customize->add_setting('vw_minimalist_footer_widgets_content',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_footer_widgets_content',array(
        'type' => 'select',
        'label' => __('Footer Widget Content','vw-minimalist'),
        'section' => 'vw_minimalist_footer',
        'choices' => array(
        	'Left' => __('Left','vw-minimalist'),
            'Center' => __('Center','vw-minimalist'),
            'Right' => __('Right','vw-minimalist')
        ),
	) );

	// footer padding
	$wp_customize->add_setting('vw_minimalist_footer_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_footer_padding',array(
		'label'	=> __('Footer Top Bottom Padding','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
      'placeholder' => __( '10px', 'vw-minimalist' ),
    ),
		'section'=> 'vw_minimalist_footer',
		'type'=> 'text'
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_minimalist_footer_text', array( 
		'selector' => '.copyright p', 
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_footer_text', 
	));

	$wp_customize->add_setting( 'vw_minimalist_copyright_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));
    $wp_customize->add_control( new vw_minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_copyright_hide_show',array(
      'label' => esc_html__( 'Show / Hide Copyright','vw-minimalist' ),
      'section' => 'vw_minimalist_footer'
    )));

	$wp_customize->add_setting('vw_minimalist_copyright_background_color', array(
		'default'           => '#f33f4b',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_copyright_background_color', array(
		'label'    => __('Copyright Background Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_footer',
	)));
	
	$wp_customize->add_setting('vw_minimalist_footer_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('vw_minimalist_footer_text',array(
		'label'	=> __('Copyright Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Copyright 2019, .....', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_copyright_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_copyright_font_size',array(
		'label'	=> __('Copyright Font Size','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_copyright_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_copyright_padding_top_bottom',array(
		'label'	=> __('Copyright Padding Top Bottom','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_copyright_alingment',array(
        'default' => 'center',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Minimalist_Image_Radio_Control($wp_customize, 'vw_minimalist_copyright_alingment', array(
        'type' => 'select',
        'label' => __('Copyright Alignment','vw-minimalist'),
        'section' => 'vw_minimalist_footer',
        'settings' => 'vw_minimalist_copyright_alingment',
        'choices' => array(
            'left' => esc_url(get_template_directory_uri()).'/assets/images/copyright1.png',
            'center' => esc_url(get_template_directory_uri()).'/assets/images/copyright2.png',
            'right' => esc_url(get_template_directory_uri()).'/assets/images/copyright3.png'
    ))));

	$wp_customize->add_setting( 'vw_minimalist_footer_scroll',array(
    	'default' => 1,
      	'transport' => 'refresh',
      	'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_footer_scroll',array(
      	'label' => esc_html__( 'Show / Hide Scroll to Top','vw-minimalist' ),
      	'section' => 'vw_minimalist_footer'
    )));

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_minimalist_scroll_to_top_icon', array( 
		'selector' => '.scrollup i', 
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_scroll_to_top_icon', 
	));

    $wp_customize->add_setting('vw_minimalist_scroll_to_top_icon',array(
		'default'	=> 'fas fa-long-arrow-alt-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_scroll_to_top_icon',array(
		'label'	=> __('Add Scroll to Top Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_footer',
		'setting'	=> 'vw_minimalist_scroll_to_top_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('vw_minimalist_scroll_to_top_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_scroll_to_top_font_size',array(
		'label'	=> __('Icon Font Size','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_scroll_to_top_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_scroll_to_top_padding',array(
		'label'	=> __('Icon Top Bottom Padding','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_scroll_to_top_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_scroll_to_top_width',array(
		'label'	=> __('Icon Width','vw-minimalist'),
		'description'	=> __('Enter a value in pixels Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_scroll_to_top_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_scroll_to_top_height',array(
		'label'	=> __('Icon Height','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_footer',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_scroll_to_top_border_radius', array(
		'default'              => 50,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_scroll_to_top_border_radius', array(
		'label'       => esc_html__( 'Icon Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_footer',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

    $wp_customize->add_setting('vw_minimalist_scroll_top_alignment',array(
        'default' => 'Right',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Minimalist_Image_Radio_Control($wp_customize, 'vw_minimalist_scroll_top_alignment', array(
        'type' => 'select',
        'label' => __('Scroll To Top','vw-minimalist'),
        'section' => 'vw_minimalist_footer',
        'settings' => 'vw_minimalist_scroll_top_alignment',
        'choices' => array(
            'Left' => esc_url(get_template_directory_uri()).'/assets/images/layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/assets/images/layout2.png',
            'Right' => esc_url(get_template_directory_uri()).'/assets/images/layout3.png'
    ))));

    // footer social icon
	$wp_customize->add_setting( 'vw_minimalist_footer_icon',array(
		'default' => false,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
  	) );
	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_footer_icon',array(
		'label' => esc_html__( 'Show / Hide Footer Social Icon','vw-minimalist' ),
		'section' => 'vw_minimalist_footer'
  	)));

    $wp_customize->add_setting('vw_minimalist_align_footer_social_icon',array(
        'default' => 'center',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_align_footer_social_icon',array(
        'type' => 'select',
        'label' => __('Social Icon Alignment ','vw-minimalist'),
        'section' => 'vw_minimalist_footer',
        'choices' => array(
            'left' => __('Left','vw-minimalist'),
            'right' => __('Right','vw-minimalist'),
            'center' => __('Center','vw-minimalist'),
        ),
	) );

	$wp_customize->add_setting( 'vw_minimalist_copyright_sticky',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_copyright_sticky',array(
      'label' => esc_html__( 'Show / Hide Sticky Copyright','vw-minimalist' ),
      'section' => 'vw_minimalist_footer'
    )));

   $wp_customize->add_setting('vw_minimalist_footer_social_icons_font_size',array(
       'default'=> 16,
       'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('vw_minimalist_footer_social_icons_font_size',array(
    'label' => __('Social Icon Font Size','vw-minimalist'),
    	'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'vw_minimalist_footer',
	 ));


	//Blog Post
	$wp_customize->add_panel( $vw_minimalist_parent_panel );

	$BlogPostParentPanel = new VW_Minimalist_WP_Customize_Panel( $wp_customize, 'blog_post_parent_panel', array(
		'title' => __( 'Blog Post Settings', 'vw-minimalist' ),
		'panel' => 'vw_minimalist_panel_id',
		'priority' => 11,
	));

	$wp_customize->add_panel( $BlogPostParentPanel );

	// Add example section and controls to the middle (second) panel
	$wp_customize->add_section( 'vw_minimalist_post_settings', array(
		'title' => __( 'Post Settings', 'vw-minimalist' ),
		'panel' => 'blog_post_parent_panel',
	));

	//Blog layout
    $wp_customize->add_setting('vw_minimalist_blog_layout_option',array(
        'default' => 'Default',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
    ));
    $wp_customize->add_control(new VW_Minimalist_Image_Radio_Control($wp_customize, 'vw_minimalist_blog_layout_option', array(
        'type' => 'select',
        'label' => __('Blog Layouts','vw-minimalist'),
        'section' => 'vw_minimalist_post_settings',
        'choices' => array(
            'Default' => esc_url(get_template_directory_uri()).'/assets/images/blog-layout1.png',
            'Center' => esc_url(get_template_directory_uri()).'/assets/images/blog-layout2.png',
            'Left' => esc_url(get_template_directory_uri()).'/assets/images/blog-layout3.png',
    ))));

   	$wp_customize->add_setting('vw_minimalist_theme_options',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_theme_options',array(
        'type' => 'select',
        'label' => __('Post Sidebar Layout','vw-minimalist'),
        'description' => __('Here you can change the sidebar layout for posts. ','vw-minimalist'),
        'section' => 'vw_minimalist_post_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-minimalist'),
            'Right Sidebar' => __('Right Sidebar','vw-minimalist'),
            'One Column' => __('One Column','vw-minimalist'),
            'Three Columns' => __('Three Columns','vw-minimalist'),
            'Four Columns' => __('Four Columns','vw-minimalist'),
            'Grid Layout' => __('Grid Layout','vw-minimalist')
        ),
	) );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_minimalist_toggle_postdate', array( 
		'selector' => '.post-main-box h2 a', 
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_toggle_postdate', 
	));

    $wp_customize->add_setting('vw_minimalist_toggle_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_toggle_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_post_settings',
		'setting'	=> 'vw_minimalist_toggle_postdate_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_minimalist_toggle_postdate',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_toggle_postdate',array(
        'label' => esc_html__( 'Show / Hide Post Date','vw-minimalist' ),
        'section' => 'vw_minimalist_post_settings'
    )));

    $wp_customize->add_setting('vw_minimalist_toggle_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_toggle_author_icon',array(
		'label'	=> __('Add Author Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_post_settings',
		'setting'	=> 'vw_minimalist_toggle_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_minimalist_toggle_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_toggle_author',array(
		'label' => esc_html__( 'Show / Hide Author','vw-minimalist' ),
		'section' => 'vw_minimalist_post_settings'
    )));

    $wp_customize->add_setting('vw_minimalist_toggle_comments_icon',array(
		'default'	=> 'fa fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_toggle_comments_icon',array(
		'label'	=> __('Add Comments Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_post_settings',
		'setting'	=> 'vw_minimalist_toggle_comments_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_minimalist_toggle_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_toggle_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','vw-minimalist' ),
		'section' => 'vw_minimalist_post_settings'
    )));

    $wp_customize->add_setting('vw_minimalist_toggle_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_toggle_time_icon',array(
		'label'	=> __('Add Time Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_post_settings',
		'setting'	=> 'vw_minimalist_toggle_time_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_minimalist_toggle_time',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_toggle_time',array(
		'label' => esc_html__( 'Show / Hide Time','vw-minimalist' ),
		'section' => 'vw_minimalist_post_settings'
    )));

     $wp_customize->add_setting( 'vw_minimalist_featured_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_featured_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','vw-minimalist' ),
		'section' => 'vw_minimalist_post_settings'
    )));

    $wp_customize->add_setting( 'vw_minimalist_featured_image_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_featured_image_border_radius', array(
		'label'       => esc_html__( 'Featured Image Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_post_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_minimalist_featured_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_featured_image_box_shadow', array(
		'label'       => esc_html__( 'Featured Image Box Shadow','vw-minimalist' ),
		'section'     => 'vw_minimalist_post_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Featured Image
	$wp_customize->add_setting('vw_minimalist_blog_post_featured_image_dimension',array(
		'default' => 'default',
		'sanitize_callback'	=> 'vw_minimalist_sanitize_choices'
	));
  	$wp_customize->add_control('vw_minimalist_blog_post_featured_image_dimension',array(
		'type' => 'select',
		'label'	=> __('Blog Post Featured Image Dimension','vw-minimalist'),
		'section'	=> 'vw_minimalist_post_settings',
		'choices' => array(
		'default' => __('Default','vw-minimalist'),
		'custom' => __('Custom Image Size','vw-minimalist'),
      ),
  	));

	$wp_customize->add_setting('vw_minimalist_blog_post_featured_image_custom_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
		));
	$wp_customize->add_control('vw_minimalist_blog_post_featured_image_custom_width',array(
		'label'	=> __('Featured Image Custom Width','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
    	'placeholder' => __( '10px', 'vw-minimalist' ),),
		'section'=> 'vw_minimalist_post_settings',
		'type'=> 'text',
		'active_callback' => 'vw_minimalist_blog_post_featured_image_dimension'
		));

	$wp_customize->add_setting('vw_minimalist_blog_post_featured_image_custom_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_blog_post_featured_image_custom_height',array(
		'label'	=> __('Featured Image Custom Height','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
    	'placeholder' => __( '10px', 'vw-minimalist' ),),
		'section'=> 'vw_minimalist_post_settings',
		'type'=> 'text',
		'active_callback' => 'vw_minimalist_blog_post_featured_image_dimension'
	));

    $wp_customize->add_setting( 'vw_minimalist_excerpt_number', array(
		'default'              => 30,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_excerpt_number', array(
		'label'       => esc_html__( 'Excerpt length','vw-minimalist' ),
		'section'     => 'vw_minimalist_post_settings',
		'type'        => 'range',
		'settings'    => 'vw_minimalist_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_minimalist_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-minimalist'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-minimalist'),
		'section'=> 'vw_minimalist_post_settings',
		'type'=> 'text'
	));

    $wp_customize->add_setting('vw_minimalist_blog_page_posts_settings',array(
        'default' => 'Into Blocks',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_blog_page_posts_settings',array(
        'type' => 'select',
        'label' => __('Display Blog Posts','vw-minimalist'),
        'section' => 'vw_minimalist_post_settings',
        'choices' => array(
        	'Into Blocks' => __('Into Blocks','vw-minimalist'),
            'Without Blocks' => __('Without Blocks','vw-minimalist')
        ),
	) );

    $wp_customize->add_setting('vw_minimalist_excerpt_settings',array(
        'default' => 'Excerpt',
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_excerpt_settings',array(
        'type' => 'select',
        'label' => __('Post Content','vw-minimalist'),
        'section' => 'vw_minimalist_post_settings',
        'choices' => array(
        	'Content' => __('Content','vw-minimalist'),
            'Excerpt' => __('Excerpt','vw-minimalist'),
            'No Content' => __('No Content','vw-minimalist')
        ),
	) );

	$wp_customize->add_setting('vw_minimalist_excerpt_suffix',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_excerpt_suffix',array(
		'label'	=> __('Add Excerpt Suffix','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '[...]', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_post_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_blog_pagination_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_blog_pagination_hide_show',array(
		'label' => esc_html__( 'Show / Hide Blog Pagination','vw-minimalist' ),
		'section' => 'vw_minimalist_post_settings'
    )));

	$wp_customize->add_setting( 'vw_minimalist_blog_pagination_type', array(
        'default'			=> 'blog-page-numbers',
        'sanitize_callback'	=> 'vw_minimalist_sanitize_choices'
    ));
    $wp_customize->add_control( 'vw_minimalist_blog_pagination_type', array(
        'section' => 'vw_minimalist_post_settings',
        'type' => 'select',
        'label' => __( 'Blog Pagination', 'vw-minimalist' ),
        'choices'		=> array(
            'blog-page-numbers'  => __( 'Numeric', 'vw-minimalist' ),
            'next-prev' => __( 'Older Posts/Newer Posts', 'vw-minimalist' ),
    )));

    // Button Settings
	$wp_customize->add_section( 'vw_minimalist_button_settings', array(
		'title' => __( 'Button Settings', 'vw-minimalist' ),
		'panel' => 'blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_minimalist_button_text', array( 
		'selector' => '.post-main-box .more-btn a', 
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_button_text', 
	));

    $wp_customize->add_setting('vw_minimalist_button_text',array(
		'default'=> esc_html__( 'Read More', 'vw-minimalist' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_button_text',array(
		'label'	=> __('Add Button Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Read More', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_button_settings',
		'type'=> 'text'
	));

	// font size button
	$wp_customize->add_setting('vw_minimalist_button_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_button_font_size',array(
		'label'	=> __('Button Font Size','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
      	'placeholder' => __( '10px', 'vw-minimalist' ),
    ),
    	'type'        => 'text',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'vw_minimalist_button_settings',
	));

	$wp_customize->add_setting( 'vw_minimalist_button_border_radius', array(
		'default'              => 50,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_button_border_radius', array(
		'label'       => esc_html__( 'Button Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_button_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_minimalist_button_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_button_padding_top_bottom',array(
		'label'	=> __('Padding Top Bottom','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_button_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_button_padding_left_right',array(
		'label'	=> __('Padding Left Right','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_button_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_button_letter_spacing',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_button_letter_spacing',array(
		'label'	=> __('Button Letter Spacing','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
      	'placeholder' => __( '10px', 'vw-minimalist' ),
    ),
    	'type'        => 'text',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
		'section'=> 'vw_minimalist_button_settings',
	));

	// text trasform
	$wp_customize->add_setting('vw_minimalist_button_text_transform',array(
		'default'=> 'Uppercase',
		'sanitize_callback'	=> 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_button_text_transform',array(
		'type' => 'radio',
		'label'	=> __('Button Text Transform','vw-minimalist'),
		'choices' => array(
            'Uppercase' => __('Uppercase','vw-minimalist'),
            'Capitalize' => __('Capitalize','vw-minimalist'),
            'Lowercase' => __('Lowercase','vw-minimalist'),
        ),
		'section'=> 'vw_minimalist_button_settings',
	));

	// Related Post Settings
	$wp_customize->add_section( 'vw_minimalist_related_posts_settings', array(
		'title' => __( 'Related Posts Settings', 'vw-minimalist' ),
		'panel' => 'blog_post_parent_panel',
	));

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial('vw_minimalist_related_post_title', array( 
		'selector' => '.related-post h3', 
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_related_post_title', 
	));

    $wp_customize->add_setting( 'vw_minimalist_related_post',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_related_post',array(
		'label' => esc_html__( 'Show / Hide Related Post','vw-minimalist' ),
		'section' => 'vw_minimalist_related_posts_settings'
    )));

    $wp_customize->add_setting('vw_minimalist_related_post_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_related_post_title',array(
		'label'	=> __('Add Related Post Title','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Related Post', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_related_posts_settings',
		'type'=> 'text'
	));

   	$wp_customize->add_setting('vw_minimalist_related_posts_count',array(
		'default'=> '3',
		'sanitize_callback'	=> 'vw_minimalist_sanitize_float'
	));
	$wp_customize->add_control('vw_minimalist_related_posts_count',array(
		'label'	=> __('Add Related Post Count','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '3', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_related_posts_settings',
		'type'=> 'number'
	));

	$wp_customize->add_setting( 'vw_minimalist_related_posts_excerpt_number', array(
		'default'              => 20,
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_related_posts_excerpt_number', array(
		'label'       => esc_html__( 'Related Posts Excerpt length','vw-minimalist' ),
		'section'     => 'vw_minimalist_related_posts_settings',
		'type'        => 'range',
		'settings'    => 'vw_minimalist_related_posts_excerpt_number',
		'input_attrs' => array(
			'step'             => 5,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_minimalist_related_toggle_postdate',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_minimalist_switch_sanitization'
  	));
  	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_related_toggle_postdate',array(
	    'label' => esc_html__( 'Show / Hide Post Date','vw-minimalist' ),
	    'section' => 'vw_minimalist_related_posts_settings'
  	)));

  	$wp_customize->add_setting('vw_minimalist_related_postdate_icon',array(
	    'default' => 'fas fa-calendar-alt',
	    'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
  	$wp_customize,'vw_minimalist_related_postdate_icon',array(
	    'label' => __('Add Post Date Icon','vw-minimalist'),
	    'transport' => 'refresh',
	    'section' => 'vw_minimalist_related_posts_settings',
	    'setting' => 'vw_minimalist_related_postdate_icon',
	    'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'vw_minimalist_related_toggle_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
  	));
  	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_related_toggle_author',array(
		'label' => esc_html__( 'Show / Hide Author','vw-minimalist' ),
		'section' => 'vw_minimalist_related_posts_settings'
  	)));

  	$wp_customize->add_setting('vw_minimalist_related_author_icon',array(
	    'default' => 'fas fa-user',
	    'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
  	$wp_customize,'vw_minimalist_related_author_icon',array(
	    'label' => __('Add Author Icon','vw-minimalist'),
	    'transport' => 'refresh',
	    'section' => 'vw_minimalist_related_posts_settings',
	    'setting' => 'vw_minimalist_related_author_icon',
	    'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'vw_minimalist_related_toggle_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
  	) );
  	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_related_toggle_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','vw-minimalist' ),
		'section' => 'vw_minimalist_related_posts_settings'
  	)));

  	$wp_customize->add_setting('vw_minimalist_related_comments_icon',array(
	    'default' => 'fa fa-comments',
	    'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
  	$wp_customize,'vw_minimalist_related_comments_icon',array(
	    'label' => __('Add Comments Icon','vw-minimalist'),
	    'transport' => 'refresh',
	    'section' => 'vw_minimalist_related_posts_settings',
	    'setting' => 'vw_minimalist_related_comments_icon',
	    'type'    => 'icon'
  	)));

	$wp_customize->add_setting( 'vw_minimalist_related_toggle_time',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
  	) );
  	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_related_toggle_time',array(
		'label' => esc_html__( 'Show / Hide Time','vw-minimalist' ),
		'section' => 'vw_minimalist_related_posts_settings'
  	)));

  	$wp_customize->add_setting('vw_minimalist_related_time_icon',array(
	    'default' => 'fas fa-clock',
	    'sanitize_callback' => 'sanitize_text_field'
  	));
  	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
  	$wp_customize,'vw_minimalist_related_time_icon',array(
	    'label' => __('Add Time Icon','vw-minimalist'),
	    'transport' => 'refresh',
	    'section' => 'vw_minimalist_related_posts_settings',
	    'setting' => 'vw_minimalist_related_time_icon',
	    'type'    => 'icon'
  	)));

  	$wp_customize->add_setting('vw_minimalist_related_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_related_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-minimalist'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-minimalist'),
		'section'=> 'vw_minimalist_related_posts_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_related_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	));
  	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_related_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','vw-minimalist' ),
		'section' => 'vw_minimalist_related_posts_settings'
  	)));

  	$wp_customize->add_setting( 'vw_minimalist_related_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_related_image_box_shadow', array(
		'label'       => esc_html__( 'Related post Image Box Shadow','vw-minimalist' ),
		'section'     => 'vw_minimalist_related_posts_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

  $wp_customize->add_setting('vw_minimalist_related_button_text',array(
		'default'=> esc_html__('Read More','vw-minimalist'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_related_button_text',array(
		'label'	=> esc_html__('Add Button Text','vw-minimalist'),
		'input_attrs' => array(
      'placeholder' => esc_html__( 'Read More', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_related_posts_settings',
		'type'=> 'text'
	));

	// Single Posts Settings
	$wp_customize->add_section( 'vw_minimalist_single_blog_settings', array(
		'title' => __( 'Single Post Settings', 'vw-minimalist' ),
		'panel' => 'blog_post_parent_panel',
	));

  	$wp_customize->add_setting('vw_minimalist_single_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_single_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_single_blog_settings',
		'setting'	=> 'vw_minimalist_single_postdate_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_minimalist_single_postdate',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	) );
	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_single_postdate',array(
	    'label' => esc_html__( 'Show / Hide Date','vw-minimalist' ),
	   'section' => 'vw_minimalist_single_blog_settings'
	)));

	$wp_customize->add_setting('vw_minimalist_single_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_single_author_icon',array(
		'label'	=> __('Add Author Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_single_blog_settings',
		'setting'	=> 'vw_minimalist_single_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_minimalist_single_author',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	) );
	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_single_author',array(
	    'label' => esc_html__( 'Show / Hide Author','vw-minimalist' ),
	    'section' => 'vw_minimalist_single_blog_settings'
	)));

   	$wp_customize->add_setting('vw_minimalist_single_comments_icon',array(
		'default'	=> 'fa fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_single_comments_icon',array(
		'label'	=> __('Add Comments Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_single_blog_settings',
		'setting'	=> 'vw_minimalist_single_comments_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_minimalist_single_comments',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	) );
	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_single_comments',array(
	    'label' => esc_html__( 'Show / Hide Comments','vw-minimalist' ),
	    'section' => 'vw_minimalist_single_blog_settings'
	)));

  	$wp_customize->add_setting('vw_minimalist_single_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_single_time_icon',array(
		'label'	=> __('Add Time Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_single_blog_settings',
		'setting'	=> 'vw_minimalist_single_time_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_minimalist_single_time',array(
	    'default' => 1,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	) );
	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_single_time',array(
	    'label' => esc_html__( 'Show / Hide Time','vw-minimalist' ),
	    'section' => 'vw_minimalist_single_blog_settings'
	)));

	$wp_customize->add_setting( 'vw_minimalist_single_post_breadcrumb',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_single_post_breadcrumb',array(
		'label' => esc_html__( 'Show / Hide Breadcrumb','vw-minimalist' ),
		'section' => 'vw_minimalist_single_blog_settings'
    )));

    // Single Posts Category
  	$wp_customize->add_setting( 'vw_minimalist_single_post_category',array(
		'default' => true,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
  	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_single_post_category',array(
		'label' => esc_html__( 'Show / Hide Category','vw-minimalist' ),
		'section' => 'vw_minimalist_single_blog_settings'
    )));

	$wp_customize->add_setting( 'vw_minimalist_toggle_tags',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_toggle_tags', array(
		'label' => esc_html__( 'Show / Hide Tags','vw-minimalist' ),
		'section' => 'vw_minimalist_single_blog_settings'
    )));

	$wp_customize->add_setting( 'vw_minimalist_singlepost_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_singlepost_image_box_shadow', array(
		'label'       => esc_html__( 'Single post Image Box Shadow','vw-minimalist' ),
		'section'     => 'vw_minimalist_single_blog_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_minimalist_single_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_single_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-minimalist'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-minimalist'),
		'section'=> 'vw_minimalist_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_single_blog_post_navigation_show_hide',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	));
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_single_blog_post_navigation_show_hide', array(
		'label' => esc_html__( 'Show / Hide Post Navigation','vw-minimalist' ),
		'section' => 'vw_minimalist_single_blog_settings'
    )));

	//navigation text
	$wp_customize->add_setting('vw_minimalist_single_blog_prev_navigation_text',array(
		'default'=> 'PREVIOUS',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_single_blog_prev_navigation_text',array(
		'label'	=> __('Post Navigation Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'PREVIOUS', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_single_blog_next_navigation_text',array(
		'default'=> 'NEXT',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_single_blog_next_navigation_text',array(
		'label'	=> __('Post Navigation Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'NEXT', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_single_blog_comment_title',array(
		'default'=> 'Leave a Reply',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_minimalist_single_blog_comment_title',array(
		'label'	=> __('Add Comment Title','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Leave a Reply', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_single_blog_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_single_blog_comment_button_text',array(
		'default'=> 'Post Comment',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_minimalist_single_blog_comment_button_text',array(
		'label'	=> __('Add Comment Button Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Post Comment', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_single_blog_settings',
		'type'=> 'text'
	));

	// Grid layout setting
	$wp_customize->add_section( 'vw_minimalist_grid_layout_settings', array(
		'title' => __( 'Grid Layout Settings', 'vw-minimalist' ),
		'panel' => 'blog_post_parent_panel',
	));

  	$wp_customize->add_setting('vw_minimalist_grid_postdate_icon',array(
		'default'	=> 'fas fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_grid_postdate_icon',array(
		'label'	=> __('Add Post Date Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_grid_layout_settings',
		'setting'	=> 'vw_minimalist_grid_postdate_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting( 'vw_minimalist_grid_postdate',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_grid_postdate',array(
        'label' => esc_html__( 'Show / Hide Post Date','vw-minimalist' ),
        'section' => 'vw_minimalist_grid_layout_settings'
    )));

	$wp_customize->add_setting('vw_minimalist_grid_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_grid_author_icon',array(
		'label'	=> __('Add Author Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_grid_layout_settings',
		'setting'	=> 'vw_minimalist_grid_author_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_minimalist_grid_author',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_grid_author',array(
		'label' => esc_html__( 'Show / Hide Author','vw-minimalist' ),
		'section' => 'vw_minimalist_grid_layout_settings'
    )));

   	$wp_customize->add_setting('vw_minimalist_grid_comments_icon',array(
		'default'	=> 'fa fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_grid_comments_icon',array(
		'label'	=> __('Add Comments Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_grid_layout_settings',
		'setting'	=> 'vw_minimalist_grid_comments_icon',
		'type'		=> 'icon'
	)));

    $wp_customize->add_setting( 'vw_minimalist_grid_comments',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_grid_comments',array(
		'label' => esc_html__( 'Show / Hide Comments','vw-minimalist' ),
		'section' => 'vw_minimalist_grid_layout_settings'
    )));

	$wp_customize->add_setting('vw_minimalist_grid_button_text',array(
		'default'=> esc_html__('Read More','vw-minimalist'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_grid_button_text',array(
		'label'	=> esc_html__('Add Button Text','vw-minimalist'),
		'input_attrs' => array(
        'placeholder' => esc_html__( 'Read More', 'vw-minimalist' ),
      ),
		'section'=> 'vw_minimalist_grid_layout_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_grid_excerpt_suffix',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_grid_excerpt_suffix',array(
		'label'	=> __('Add Excerpt Suffix','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '[...]', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_grid_layout_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_grid_image_hide_show',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
	));
  	$wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_grid_image_hide_show', array(
		'label' => esc_html__( 'Show / Hide Featured Image','vw-minimalist' ),
		'section' => 'vw_minimalist_grid_layout_settings'
  	)));

 	$wp_customize->add_setting('vw_minimalist_grid_post_meta_field_separator',array(
		'default'=> '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_grid_post_meta_field_separator',array(
		'label'	=> __('Add Meta Separator','vw-minimalist'),
		'description' => __('Add the seperator for meta box. Example: "|", "/", etc.','vw-minimalist'),
		'section'=> 'vw_minimalist_grid_layout_settings',
		'type'=> 'text'
	));  

  	$wp_customize->add_setting('vw_minimalist_display_grid_posts_settings',array(
	    'default' => 'Into Blocks',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_display_grid_posts_settings',array(
	    'type' => 'select',
	    'label' => __('Display Grid Posts','vw-minimalist'),
	    'section' => 'vw_minimalist_grid_layout_settings',
	    'choices' => array(
	    	'Into Blocks' => __('Into Blocks','vw-minimalist'),
	        'Without Blocks' => __('Without Blocks','vw-minimalist')
	    ),
	) );

	$wp_customize->add_setting('vw_minimalist_grid_excerpt_settings',array(
    'default' => 'Excerpt',
    'transport' => 'refresh',
    'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_grid_excerpt_settings',array(
    'type' => 'select',
    'label' => esc_html__('Grid Post Content','vw-minimalist'),
    'section' => 'vw_minimalist_grid_layout_settings',
    'choices' => array(
    	'Content' => esc_html__('Content','vw-minimalist'),
      'Excerpt' => esc_html__('Excerpt','vw-minimalist'),
      'No Content' => esc_html__('No Content','vw-minimalist')
    ),
	) );

  $wp_customize->add_setting( 'vw_minimalist_grid_featured_image_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_grid_featured_image_border_radius', array(
		'label'       => esc_html__( 'Grid Featured Image Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_grid_layout_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_minimalist_grid_featured_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_grid_featured_image_box_shadow', array(
		'label'       => esc_html__( 'Grid Featured Image Box Shadow','vw-minimalist' ),
		'section'     => 'vw_minimalist_grid_layout_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//other settings

	$wp_customize->add_panel( $vw_minimalist_parent_panel );

	$OtherParentPanel = new VW_Minimalist_WP_Customize_Panel( $wp_customize, 'other_parent_panel', array(
		'title' => __( 'Other Settings', 'vw-minimalist' ),
		'panel' => 'vw_minimalist_panel_id',
		'priority' => 11,
	));

	$wp_customize->add_panel( $OtherParentPanel );

	// Layout
	$wp_customize->add_section( 'vw_minimalist_left_right', array(
    	'title'      => esc_html__( 'General Settings', 'vw-minimalist' ),
		'panel' => 'other_parent_panel'
	) );

   	// Header Background color
	$wp_customize->add_setting('vw_minimalist_header_background_color', array(
		'default'           => '#f3fbfe',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_header_background_color', array(
		'label'    => __('Header Background Color', 'vw-minimalist'),
		'section'  => 'header_image',
	)));

	$wp_customize->add_setting('vw_minimalist_header_img_position',array(
	  'default' => 'center top',
	  'transport' => 'refresh',
	  'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_header_img_position',array(
		'type' => 'select',
		'label' => __('Header Image Position','vw-minimalist'),
		'section' => 'header_image',
		'choices' 	=> array(
			'left top' 		=> esc_html__( 'Top Left', 'vw-minimalist' ),
			'center top'   => esc_html__( 'Top', 'vw-minimalist' ),
			'right top'   => esc_html__( 'Top Right', 'vw-minimalist' ),
			'left center'   => esc_html__( 'Left', 'vw-minimalist' ),
			'center center'   => esc_html__( 'Center', 'vw-minimalist' ),
			'right center'   => esc_html__( 'Right', 'vw-minimalist' ),
			'left bottom'   => esc_html__( 'Bottom Left', 'vw-minimalist' ),
			'center bottom'   => esc_html__( 'Bottom', 'vw-minimalist' ),
			'right bottom'   => esc_html__( 'Bottom Right', 'vw-minimalist' ),
		),
	));

	$wp_customize->add_setting('vw_minimalist_width_option',array(
        'default' => 'Full Width',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control(new VW_Minimalist_Image_Radio_Control($wp_customize, 'vw_minimalist_width_option', array(
        'type' => 'select',
        'label' => __('Width Layouts','vw-minimalist'),
        'description' => __('Here you can change the width layout of Website.','vw-minimalist'),
        'section' => 'vw_minimalist_left_right',
        'choices' => array(
            'Full Width' => esc_url(get_template_directory_uri()).'/assets/images/full-width.png',
            'Wide Width' => esc_url(get_template_directory_uri()).'/assets/images/wide-width.png',
            'Boxed' => esc_url(get_template_directory_uri()).'/assets/images/boxed-width.png',
    ))));

	$wp_customize->add_setting('vw_minimalist_page_layout',array(
        'default' => 'One Column',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_page_layout',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','vw-minimalist'),
        'description' => __('Here you can change the sidebar layout for pages. ','vw-minimalist'),
        'section' => 'vw_minimalist_left_right',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-minimalist'),
            'Right Sidebar' => __('Right Sidebar','vw-minimalist'),
            'One Column' => __('One Column','vw-minimalist')
        ),
	) );

    //Sticky Header
	$wp_customize->add_setting( 'vw_minimalist_sticky_header',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_sticky_header',array(
        'label' => esc_html__( 'Sticky Header','vw-minimalist' ),
        'section' => 'vw_minimalist_left_right'
    )));

    $wp_customize->add_setting('vw_minimalist_sticky_header_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_sticky_header_padding',array(
		'label'	=> __('Sticky Header Padding','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_left_right',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_single_page_breadcrumb',array(
		'default' => 1,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_single_page_breadcrumb',array(
		'label' => esc_html__( 'Show / Hide Page Breadcrumb','vw-minimalist' ),
		'section' => 'vw_minimalist_left_right'
    )));

	//Wow Animation
	$wp_customize->add_setting( 'vw_minimalist_animation',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_animation',array(
        'label' => esc_html__( 'Show / Hide Animations','vw-minimalist' ),
        'description' => __('Here you can disable overall site animation effect','vw-minimalist'),
        'section' => 'vw_minimalist_left_right'
    )));

    $wp_customize->add_setting('vw_minimalist_reset_all_settings',array(
      'sanitize_callback'	=> 'sanitize_text_field',
   	));
   	$wp_customize->add_control(new VW_Minimalist_Reset_Custom_Control($wp_customize, 'vw_minimalist_reset_all_settings',array(
      'type' => 'reset_control',
      'label' => __('Reset All Settings', 'vw-minimalist'),
      'description' => 'vw_minimalist_reset_all_settings',
      'section' => 'vw_minimalist_left_right'
   	)));

    //Pre-Loader
	$wp_customize->add_setting( 'vw_minimalist_loader_enable',array(
        'default' => 0,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_loader_enable',array(
        'label' => esc_html__( 'Show / Hide Pre-Loader','vw-minimalist' ),
        'section' => 'vw_minimalist_left_right'
    )));

	$wp_customize->add_setting('vw_minimalist_preloader_bg_color', array(
		'default'           => '#f33f4b',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_preloader_bg_color', array(
		'label'    => __('Pre-Loader Background Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_left_right',
	)));

	$wp_customize->add_setting('vw_minimalist_preloader_border_color', array(
		'default'           => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_preloader_border_color', array(
		'label'    => __('Pre-Loader Border Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_left_right',
	)));

	$wp_customize->add_setting('vw_minimalist_preloader_bg_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'vw_minimalist_preloader_bg_img',array(
        'label' => __('Preloader Background Image','vw-minimalist'),
        'section' => 'vw_minimalist_left_right'
	)));

	$wp_customize->add_setting('vw_minimalist_bradcrumbs_alignment',array(
        'default' => 'Left',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_bradcrumbs_alignment',array(
        'type' => 'select',
        'label' => __('Bradcrumbs Alignment','vw-minimalist'),
        'section' => 'vw_minimalist_left_right',
        'choices' => array(
            'Left' => __('Left','vw-minimalist'),
            'Right' => __('Right','vw-minimalist'),
            'Center' => __('Center','vw-minimalist'),
        ),
	) );
    
    //404 Page Setting
	$wp_customize->add_section('vw_minimalist_404_page',array(
		'title'	=> __('404 Page Settings','vw-minimalist'),
		'panel' => 'other_parent_panel',
	));	

	$wp_customize->add_setting('vw_minimalist_404_page_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_minimalist_404_page_title',array(
		'label'	=> __('Add Title','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '404 Not Found', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_404_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_404_page_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_minimalist_404_page_content',array(
		'label'	=> __('Add Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Looks like you have taken a wrong turn, Dont worry, it happens to the best of us.', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_404_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_404_page_button_text',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_404_page_button_text',array(
		'label'	=> __('Add Button Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'GO BACK', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_404_page',
		'type'=> 'text'
	));

	//No Result Page Setting
	$wp_customize->add_section('vw_minimalist_no_results_page',array(
		'title'	=> __('No Results Page Settings','vw-minimalist'),
		'panel' => 'other_parent_panel',
	));	

	$wp_customize->add_setting('vw_minimalist_no_results_page_title',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_minimalist_no_results_page_title',array(
		'label'	=> __('Add Title','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Nothing Found', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_no_results_page',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_no_results_page_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('vw_minimalist_no_results_page_content',array(
		'label'	=> __('Add Text','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_no_results_page',
		'type'=> 'text'
	));

	//Social Icon Setting
	$wp_customize->add_section('vw_minimalist_social_icon_settings',array(
		'title'	=> __('Social Icons Settings','vw-minimalist'),
		'panel' => 'other_parent_panel',
	));	

	$wp_customize->add_setting('vw_minimalist_social_icon_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_social_icon_font_size',array(
		'label'	=> __('Icon Font Size','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_social_icon_padding',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_social_icon_padding',array(
		'label'	=> __('Icon Padding','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_social_icon_width',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_social_icon_width',array(
		'label'	=> __('Icon Width','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_social_icon_height',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_social_icon_height',array(
		'label'	=> __('Icon Height','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_social_icon_settings',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_social_icon_border_radius', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_social_icon_border_radius', array(
		'label'       => esc_html__( 'Icon Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_social_icon_settings',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Responsive Media Settings
	$wp_customize->add_section('vw_minimalist_responsive_media',array(
		'title'	=> __('Responsive Media','vw-minimalist'),
		'panel' => 'other_parent_panel',
	));

    $wp_customize->add_setting( 'vw_minimalist_stickyheader_hide_show',array(
      'default' => 0,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_stickyheader_hide_show',array(
      'label' => esc_html__( 'Sticky Header','vw-minimalist' ),
      'section' => 'vw_minimalist_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_minimalist_resp_slider_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_resp_slider_hide_show',array(
      'label' => esc_html__( 'Show / Hide Slider','vw-minimalist' ),
      'section' => 'vw_minimalist_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_minimalist_sidebar_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_sidebar_hide_show',array(
      'label' => esc_html__( 'Show / Hide Sidebar','vw-minimalist' ),
      'section' => 'vw_minimalist_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_minimalist_responsive_preloader_hide',array(
        'default' => false,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_responsive_preloader_hide',array(
        'label' => esc_html__( 'Show / Hide Preloader','vw-minimalist' ),
        'section' => 'vw_minimalist_responsive_media'
    )));

    $wp_customize->add_setting( 'vw_minimalist_resp_scroll_top_hide_show',array(
      'default' => 1,
      'transport' => 'refresh',
      'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ));  
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_resp_scroll_top_hide_show',array(
      'label' => esc_html__( 'Show / Hide Scroll To Top','vw-minimalist' ),
      'section' => 'vw_minimalist_responsive_media'
    )));

    $wp_customize->add_setting('vw_minimalist_resp_menu_toggle_btn_bg_color', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'vw_minimalist_resp_menu_toggle_btn_bg_color', array(
		'label'    => __('Toggle Button Bg Color', 'vw-minimalist'),
		'section'  => 'vw_minimalist_responsive_media',
	)));

    $wp_customize->add_setting('vw_minimalist_res_menu_open_icon',array(
		'default'	=> 'fas fa-bars',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_res_menu_open_icon',array(
		'label'	=> __('Add Open Menu Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_responsive_media',
		'setting'	=> 'vw_minimalist_res_menu_open_icon',
		'type'		=> 'icon'
	)));

	$wp_customize->add_setting('vw_minimalist_res_menu_close_icon',array(
		'default'	=> 'fas fa-times',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new VW_Minimalist_Fontawesome_Icon_Chooser(
        $wp_customize,'vw_minimalist_res_menu_close_icon',array(
		'label'	=> __('Add Close Menu Icon','vw-minimalist'),
		'transport' => 'refresh',
		'section'	=> 'vw_minimalist_responsive_media',
		'setting'	=> 'vw_minimalist_res_menu_close_icon',
		'type'		=> 'icon'
	)));

	
    //Woocommerce settings
	$wp_customize->add_section('vw_minimalist_woocommerce_section', array(
		'title'    => __('WooCommerce Layout', 'vw-minimalist'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

    //Shop Page Featured Image
	$wp_customize->add_setting( 'vw_minimalist_shop_featured_image_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_shop_featured_image_border_radius', array(
		'label'       => esc_html__( 'Shop Page Featured Image Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting( 'vw_minimalist_shop_featured_image_box_shadow', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_shop_featured_image_box_shadow', array(
		'label'       => esc_html__( 'Shop Page Featured Image Box Shadow','vw-minimalist' ),
		'section'     => 'vw_minimalist_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_minimalist_woocommerce_shop_page_sidebar', array( 'selector' => '.post-type-archive-product #sidebar', 
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_woocommerce_shop_page_sidebar', ) );

    //Woocommerce Shop Page Sidebar
	$wp_customize->add_setting( 'vw_minimalist_woocommerce_shop_page_sidebar',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_woocommerce_shop_page_sidebar',array(
		'label' => esc_html__( 'Show / Hide Shop Page Sidebar','vw-minimalist' ),
		'section' => 'vw_minimalist_woocommerce_section'
    )));

    $wp_customize->add_setting('vw_minimalist_shop_page_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_shop_page_layout',array(
        'type' => 'select',
        'label' => __('Shop Page Sidebar Layout','vw-minimalist'),
        'section' => 'vw_minimalist_woocommerce_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-minimalist'),
            'Right Sidebar' => __('Right Sidebar','vw-minimalist'),
        ),
	) );

    //Selective Refresh
	$wp_customize->selective_refresh->add_partial( 'vw_minimalist_woocommerce_single_product_page_sidebar', array( 'selector' => '.single-product #sidebar', 
		'render_callback' => 'vw_minimalist_customize_partial_vw_minimalist_woocommerce_single_product_page_sidebar', ) );

    //Woocommerce Single Product page Sidebar
	$wp_customize->add_setting( 'vw_minimalist_woocommerce_single_product_page_sidebar',array(
		'default' => 0,
		'transport' => 'refresh',
		'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_woocommerce_single_product_page_sidebar',array(
		'label' => esc_html__( 'Show / Hide Single Product Sidebar','vw-minimalist' ),
		'section' => 'vw_minimalist_woocommerce_section'
    )));

    $wp_customize->add_setting('vw_minimalist_single_product_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_single_product_layout',array(
        'type' => 'select',
        'label' => __('Single Product Sidebar Layout','vw-minimalist'),
        'section' => 'vw_minimalist_woocommerce_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','vw-minimalist'),
            'Right Sidebar' => __('Right Sidebar','vw-minimalist'),
        ),
	) );

    //Products per page
    $wp_customize->add_setting('vw_minimalist_products_per_page',array(
		'default'=> '9',
		'sanitize_callback'	=> 'vw_minimalist_sanitize_float'
	));
	$wp_customize->add_control('vw_minimalist_products_per_page',array(
		'label'	=> __('Products Per Page','vw-minimalist'),
		'description' => __('Display on shop page','vw-minimalist'),
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'number',
	));

    //Products per row
    $wp_customize->add_setting('vw_minimalist_products_per_row',array(
		'default'=> '3',
		'sanitize_callback'	=> 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_products_per_row',array(
		'label'	=> __('Products Per Row','vw-minimalist'),
		'description' => __('Display on shop page','vw-minimalist'),
		'choices' => array(
            '2' => '2',
			'3' => '3',
			'4' => '4',
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'select',
	));

	//Products padding
	$wp_customize->add_setting('vw_minimalist_products_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_products_padding_top_bottom',array(
		'label'	=> __('Products Padding Top Bottom','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_products_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_products_padding_left_right',array(
		'label'	=> __('Products Padding Left Right','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'text'
	));

	//Products box shadow
	$wp_customize->add_setting( 'vw_minimalist_products_box_shadow', array(
		'default'              => '',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_products_box_shadow', array(
		'label'       => esc_html__( 'Products Box Shadow','vw-minimalist' ),
		'section'     => 'vw_minimalist_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Products border radius
    $wp_customize->add_setting( 'vw_minimalist_products_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_products_border_radius', array(
		'label'       => esc_html__( 'Products Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('vw_minimalist_products_btn_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_products_btn_padding_top_bottom',array(
		'label'	=> __('Products Button Padding Top Bottom','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_products_btn_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_products_btn_padding_left_right',array(
		'label'	=> __('Products Button Padding Left Right','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_products_button_border_radius', array(
		'default'              => '100',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_products_button_border_radius', array(
		'label'       => esc_html__( 'Products Button Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

	//Products Sale Badge
	$wp_customize->add_setting('vw_minimalist_woocommerce_sale_position',array(
        'default' => 'right',
        'sanitize_callback' => 'vw_minimalist_sanitize_choices'
	));
	$wp_customize->add_control('vw_minimalist_woocommerce_sale_position',array(
        'type' => 'select',
        'label' => __('Sale Badge Position','vw-minimalist'),
        'section' => 'vw_minimalist_woocommerce_section',
        'choices' => array(
            'left' => __('Left','vw-minimalist'),
            'right' => __('Right','vw-minimalist'),
        ),
	) );

	$wp_customize->add_setting('vw_minimalist_woocommerce_sale_font_size',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_woocommerce_sale_font_size',array(
		'label'	=> __('Sale Font Size','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_woocommerce_sale_padding_top_bottom',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_woocommerce_sale_padding_top_bottom',array(
		'label'	=> __('Sale Padding Top Bottom','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('vw_minimalist_woocommerce_sale_padding_left_right',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('vw_minimalist_woocommerce_sale_padding_left_right',array(
		'label'	=> __('Sale Padding Left Right','vw-minimalist'),
		'description'	=> __('Enter a value in pixels. Example:20px','vw-minimalist'),
		'input_attrs' => array(
            'placeholder' => __( '10px', 'vw-minimalist' ),
        ),
		'section'=> 'vw_minimalist_woocommerce_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'vw_minimalist_woocommerce_sale_border_radius', array(
		'default'              => '0',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'vw_minimalist_sanitize_number_range'
	) );
	$wp_customize->add_control( 'vw_minimalist_woocommerce_sale_border_radius', array(
		'label'       => esc_html__( 'Sale Border Radius','vw-minimalist' ),
		'section'     => 'vw_minimalist_woocommerce_section',
		'type'        => 'range',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 50,
		),
	) );

    // Related Product
    $wp_customize->add_setting( 'vw_minimalist_related_product_show_hide',array(
        'default' => 1,
        'transport' => 'refresh',
        'sanitize_callback' => 'vw_minimalist_switch_sanitization'
    ) );
    $wp_customize->add_control( new VW_Minimalist_Toggle_Switch_Custom_Control( $wp_customize, 'vw_minimalist_related_product_show_hide',array(
        'label' => esc_html__( 'Show / Hide Related product','vw-minimalist' ),
        'section' => 'vw_minimalist_woocommerce_section'
    )));  

    // Has to be at the top
	$wp_customize->register_panel_type( 'VW_Minimalist_WP_Customize_Panel' );
	$wp_customize->register_section_type( 'VW_Minimalist_WP_Customize_Section' );
}

add_action( 'customize_register', 'vw_minimalist_customize_register' );

load_template( trailingslashit( get_template_directory() ) . '/inc/logo/logo-resizer.php' );

if ( class_exists( 'WP_Customize_Panel' ) ) {
  	class VW_Minimalist_WP_Customize_Panel extends WP_Customize_Panel {
	    public $panel;
	    public $type = 'vw_minimalist_panel';
	    public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'type', 'panel', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;
	      return $array;
    	}
  	}
}

if ( class_exists( 'WP_Customize_Section' ) ) {
  	class VW_Minimalist_WP_Customize_Section extends WP_Customize_Section {
	    public $section;
	    public $type = 'vw_minimalist_section';
	    public function json() {

	      $array = wp_array_slice_assoc( (array) $this, array( 'id', 'description', 'priority', 'panel', 'type', 'description_hidden', 'section', ) );
	      $array['title'] = html_entity_decode( $this->title, ENT_QUOTES, get_bloginfo( 'charset' ) );
	      $array['content'] = $this->get_content();
	      $array['active'] = $this->active();
	      $array['instanceNumber'] = $this->instance_number;

	      if ( $this->panel ) {
	        $array['customizeAction'] = sprintf( 'Customizing &#9656; %s', esc_html( $this->manager->get_panel( $this->panel )->title ) );
	      } else {
	        $array['customizeAction'] = 'Customizing';
	      }
	      return $array;
    	}
  	}
}

// Enqueue our scripts and styles
function vw_minimalist_customize_controls_scripts() {
  wp_enqueue_script( 'vw-minimalist-customizer-controls', get_theme_file_uri( '/assets/js/customizer-controls.js' ), array(), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'vw_minimalist_customize_controls_scripts' );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class VW_Minimalist_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	*/
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'VW_Minimalist_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section( new VW_Minimalist_Customize_Section_Pro( $manager,'vw_minimalist_upgrade_pro_link', array(
			'priority'   => 1,
			'title'    => esc_html__( 'VW Minimalist Pro', 'vw-minimalist' ),
			'pro_text' => esc_html__( 'UPGRADE PRO', 'vw-minimalist' ),
			'pro_url'  => esc_url('https://www.vwthemes.com/products/minimalist-wordpress-theme'),
		)));

		$manager->add_section(new VW_Minimalist_Customize_Section_Pro($manager,'vw_minimalist_get_started_link',array(
			'priority'   => 1,
			'title'    => esc_html__( 'DOCUMENTATION', 'vw-minimalist' ),
			'pro_text' => esc_html__( 'DOCS', 'vw-minimalist' ),
			'pro_url'  => esc_url('https://preview.vwthemesdemo.com/docs/free-vw-minimalist/'),
		)));
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'vw-minimalist-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'vw-minimalist-customize-controls', trailingslashit( esc_url(get_template_directory_uri()) ) . '/assets/css/customize-controls.css' );

		wp_localize_script(
		'vw-minimalist-customize-controls',
		'vw_minimalist_customizer_params',
		array(
			'ajaxurl' =>	admin_url( 'admin-ajax.php' )
		));
	}
}

// Doing this customizer thang!
VW_Minimalist_Customize::get_instance();