<?php
/**
 * VW Minimalist: Block Patterns
 *
 * @package VW Minimalist
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'vw-minimalist',
		array( 'label' => __( 'VW Minimalist', 'vw-minimalist' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-minimalist/banner-section',
		array(
			'title'      => __( 'Banner Section', 'vw-minimalist' ),
			'categories' => array( 'vw-minimalist' ),
			'content'    => "<!-- wp:cover {\"customOverlayColor\":\"#f3fbfe\",\"minHeight\":600,\"isDark\":false,\"align\":\"full\",\"className\":\"banner-section\"} -->\n<div class=\"wp-block-cover alignfull is-light banner-section\" style=\"min-height:600px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#f3fbfe\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"full\"} -->\n<div class=\"wp-block-columns alignfull\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":1,\"style\":{\"color\":{\"text\":\"#f33f4b\"}}} -->\n<h1 class=\"wp-block-heading has-text-align-left has-text-color\" style=\"color:#f33f4b\">Lorem ipsum is simply dummy text</h1>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<p class=\"has-text-color\" style=\"color:#222222\">Lorem Ipsum has been the industrys standard. Lorem Ipsum has been the industrys standard.&nbsp;Lorem Ipsum has been the industrys standard.&nbsp;</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"white\",\"style\":{\"color\":{\"background\":\"#f33f4b\"}},\"className\":\"btn\"} -->\n<div class=\"wp-block-button btn\"><a class=\"wp-block-button__link has-white-color has-text-color has-background wp-element-button\" href=\"#\" style=\"background-color:#f33f4b\" target=\"_blank\" rel=\"noreferrer noopener\">READ MORE</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"align\":\"left\",\"id\":5540,\"sizeSlug\":\"large\",\"linkDestination\":\"media\",\"className\":\"banner-circle-img\"} -->\n<figure class=\"wp-block-image alignleft size-large banner-circle-img\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner-circle.png\" alt=\"\" class=\"wp-image-5540\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-minimalist/services-section',
		array(
			'title'      => __( 'Services Section', 'vw-minimalist' ),
			'categories' => array( 'vw-minimalist' ),
			'content'    => "<!-- wp:cover {\"overlayColor\":\"white\",\"align\":\"wide\",\"className\":\"article-outer-box\"} -->\n<div class=\"wp-block-cover alignwide has-white-background-color has-background-dim article-outer-box\"><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#f33f4b\",\"background\":\"#f4fbfe\"}}} -->\n<p class=\"has-text-align-left has-text-color has-background\" style=\"background-color:#f4fbfe;color:#f33f4b\">Services</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"textAlign\":\"left\",\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<h2 class=\"has-text-align-left has-text-color\" style=\"color:#222222\">Services We Provide</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"align\":\"full\",\"className\":\"article-container\"} -->\n<div class=\"wp-block-columns alignfull article-container\"><!-- wp:column {\"className\":\"article-section\"} -->\n<div class=\"wp-block-column article-section\"><!-- wp:image {\"align\":\"center\",\"id\":5548,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/services1.png\" alt=\"\" class=\"wp-image-5548\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<h3 class=\"has-text-align-center has-text-color\" style=\"color:#222222\">Services 01</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#888888\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#888888\">Lorem Ipsum has been the industrys standard. Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":50,\"style\":{\"color\":{\"text\":\"#888888\"}},\"backgroundColor\":\"white\",\"className\":\"service-btn\"} -->\n<div class=\"wp-block-button service-btn\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background\" style=\"border-radius:50px;color:#888888\"></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"article-section\"} -->\n<div class=\"wp-block-column article-section\"><!-- wp:image {\"align\":\"center\",\"id\":5550,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/services2.png\" alt=\"\" class=\"wp-image-5550\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<h3 class=\"has-text-align-center has-text-color\" style=\"color:#222222\">Services 02</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#888888\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#888888\">Lorem Ipsum has been the industrys standard. Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":50,\"style\":{\"color\":{\"text\":\"#888888\"}},\"backgroundColor\":\"white\",\"className\":\"service-btn\"} -->\n<div class=\"wp-block-button service-btn\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background\" style=\"border-radius:50px;color:#888888\"></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"article-section\"} -->\n<div class=\"wp-block-column article-section\"><!-- wp:image {\"align\":\"center\",\"id\":5551,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/services3.png\" alt=\"\" class=\"wp-image-5551\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<h3 class=\"has-text-align-center has-text-color\" style=\"color:#222222\">Services 03</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#888888\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#888888\">Lorem Ipsum has been the industrys standard. Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":50,\"style\":{\"color\":{\"text\":\"#888888\"}},\"backgroundColor\":\"white\",\"className\":\"service-btn\"} -->\n<div class=\"wp-block-button service-btn\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background\" style=\"border-radius:50px;color:#888888\"></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"article-section\"} -->\n<div class=\"wp-block-column article-section\"><!-- wp:image {\"align\":\"center\",\"id\":5552,\"sizeSlug\":\"large\",\"linkDestination\":\"media\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/services4.png\" alt=\"\" class=\"wp-image-5552\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"color\":{\"text\":\"#222222\"}}} -->\n<h3 class=\"has-text-align-center has-text-color\" style=\"color:#222222\">Services 04</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#888888\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#888888\">Lorem Ipsum has been the industrys standard. Lorem Ipsum has been the industrys standard.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"center\"} -->\n<div class=\"wp-block-buttons aligncenter\"><!-- wp:button {\"borderRadius\":49,\"style\":{\"color\":{\"text\":\"#888888\"}},\"backgroundColor\":\"white\",\"className\":\"service-btn\"} -->\n<div class=\"wp-block-button service-btn\"><a class=\"wp-block-button__link has-white-background-color has-text-color has-background\" style=\"border-radius:49px;color:#888888\"></a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->",
		)
	);
}