<?php
/**
 * VW Medical Care: Block Patterns
 *
 * @package VW Medical Care
 * @since   1.0.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'vw-medical-care',
		array( 'label' => __( 'VW Medical Care', 'vw-medical-care' ) )
	);
}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {
	register_block_pattern(
		'vw-medical-care/banner-section',
		array(
			'title'      => __( 'Banner Section', 'vw-medical-care' ),
			'categories' => array( 'vw-medical-care' ),
			'content'    => "<!-- wp:cover {\"url\":\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner.png\",\"id\":204,\"dimRatio\":40,\"customGradient\":\"linear-gradient(90deg,rgb(255,255,255) 0%,rgb(0,0,0) 100%)\",\"align\":\"full\",\"className\":\"banner-section\"} -->\n<div class=\"wp-block-cover alignfull has-background-dim-40 has-background-dim has-background-gradient banner-section\" style=\"background-image:url(" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/banner.png)\"><span aria-hidden=\"true\" class=\"wp-block-cover__gradient-background\" style=\"background:linear-gradient(90deg,rgb(255,255,255) 0%,rgb(0,0,0) 100%)\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"align\":\"wide\",\"className\":\"mx-md-5 mx-0 px-lg-5\"} -->\n<div class=\"wp-block-columns alignwide mx-md-5 mx-0 px-lg-5\"><!-- wp:column {\"className\":\"banner-box\"} -->\n<div class=\"wp-block-column banner-box\"><!-- wp:paragraph {\"className\":\"small-title\",\"style\":{\"color\":{\"text\":\"#2f3241\"}}} -->\n<p class=\"small-title has-text-color\" style=\"color:#2f3241\"><strong>LOREM IPSUM IS SIMPLY DUMMY TEXT</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"className\":\"mt-0\",\"style\":{\"color\":{\"text\":\"#2f3241\"},\"typography\":{\"fontSize\":40}}} -->\n<h2 class=\"mt-0 has-text-color\" style=\"color:#2f3241;font-size:40px\"><strong>LOREM IPSUM IS SIMPLY TEXT</strong></h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"mt-0\",\"style\":{\"color\":{\"text\":\"#2f3241\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"mt-0 has-text-color\" style=\"color:#2f3241;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"borderRadius\":30,\"style\":{\"color\":{\"background\":\"#3fa4f6\"}},\"textColor\":\"white\",\"className\":\"is-style-fill\"} -->\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-white-color has-text-color has-background\" style=\"border-radius:30px;background-color:#3fa4f6\">Read More</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div></div>\n<!-- /wp:cover -->",
		)
	);

	register_block_pattern(
		'vw-medical-care/features-section',
		array(
			'title'      => __( 'Contact Details', 'vw-medical-care' ),
			'categories' => array( 'vw-medical-care' ),
			'content'    => "<!-- wp:columns {\"align\":\"wide\",\"className\":\"contact-details mx-lg-5 mx-0\"} -->\n<div class=\"wp-block-columns alignwide contact-details mx-lg-5 mx-0\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:cover {\"customOverlayColor\":\"#3fa4f6\",\"minHeight\":150,\"isDark\":false,\"className\":\"phone p-lg-4 p-md-2 p-4 mb-md-0 mb-4\"} -->\n<div class=\"wp-block-cover is-light phone p-lg-4 p-md-2 p-4 mb-md-0 mb-4\" style=\"min-height:150px\"><span aria-hidden=\"true\" class=\"has-background-dim-100 wp-block-cover__gradient-background has-background-dim\" style=\"background-color:#3fa4f6\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"className\":\"phone-head pt-4 mt-0\"} -->\n<div class=\"wp-block-columns phone-head pt-4 mt-0\"><!-- wp:column {\"width\":\"33.33%\",\"className\":\"text-right\"} -->\n<div class=\"wp-block-column text-right\" style=\"flex-basis:33.33%\"><!-- wp:image {\"align\":\"right\",\"id\":207,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"alignright size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/phone.png\" alt=\"\" class=\"wp-image-207\"/></figure></div>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"medium\"} -->\n<h3 class=\"has-medium-font-size\"><strong>Phone No.</strong></h3>\n<!-- /wp:heading --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mt-0\",\"fontSize\":\"medium\"} -->\n<p class=\"has-text-align-center text-center mt-0 has-medium-font-size\">98745632110</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"ms-0 mb-md-0 mb-4\"} -->\n<div class=\"wp-block-column ms-0 mb-md-0 mb-4\"><!-- wp:cover {\"customOverlayColor\":\"#3fa4f6\",\"minHeight\":200,\"isDark\":false,\"className\":\"address text-center p-lg-4 p-md-2 p-4\"} -->\n<div class=\"wp-block-cover is-light address text-center p-lg-4 p-md-2 p-4\" style=\"min-height:200px\"><span aria-hidden=\"true\" class=\"has-background-dim-100 wp-block-cover__gradient-background has-background-dim\" style=\"background-color:#3fa4f6\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:image {\"align\":\"center\",\"id\":208,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"text-center mt-0\"} -->\n<div class=\"wp-block-image text-center mt-0\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/location.png\" alt=\"\" class=\"wp-image-208\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"mb-3 pb-4\",\"fontSize\":\"medium\"} -->\n<h3 class=\"has-text-align-center mb-3 pb-4 has-medium-font-size\"><strong>Hospital Address</strong></h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":14}},\"className\":\"text-center\"} -->\n<p class=\"has-text-align-center text-center\" style=\"font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing and typesetting industry.</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"ms-0\"} -->\n<div class=\"wp-block-column ms-0\"><!-- wp:cover {\"customOverlayColor\":\"#3fa4f6\",\"minHeight\":150,\"isDark\":false,\"className\":\"email p-lg-4 p-md-2 p-4 mb-md-0 mb-4\"} -->\n<div class=\"wp-block-cover is-light email p-lg-4 p-md-2 p-4 mb-md-0 mb-4\" style=\"min-height:150px\"><span aria-hidden=\"true\" class=\"has-background-dim-100 wp-block-cover__gradient-background has-background-dim\" style=\"background-color:#3fa4f6\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:columns {\"className\":\"phone-head pt-4 mt-0\"} -->\n<div class=\"wp-block-columns phone-head pt-4 mt-0\"><!-- wp:column {\"width\":\"33.33%\",\"className\":\"text-right\"} -->\n<div class=\"wp-block-column text-right\" style=\"flex-basis:33.33%\"><!-- wp:image {\"align\":\"right\",\"id\":209,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"alignright size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/email.png\" alt=\"\" class=\"wp-image-209\"/></figure></div>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"level\":3,\"fontSize\":\"medium\"} -->\n<h3 class=\"has-medium-font-size\"><strong>Email Address</strong></h3>\n<!-- /wp:heading --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"text-center mt-0\",\"fontSize\":\"medium\"} -->\n<p class=\"has-text-align-center text-center mt-0 has-medium-font-size\">example@gmai.com</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
		)
	);

	register_block_pattern(
		'vw-medical-care/about-section',
		array(
			'title'      => __( 'Facility Section', 'vw-medical-care' ),
			'categories' => array( 'vw-medical-care' ),
			'content'    => "<!-- wp:columns {\"align\":\"wide\",\"className\":\"facility-section py-5 mx-md-5 mx-0\"} -->\n<div class=\"wp-block-columns alignwide facility-section py-5 mx-md-5 mx-0\"><!-- wp:column {\"className\":\"text-center mb-md-0 mb-4\"} -->\n<div class=\"wp-block-column text-center mb-md-0 mb-4\"><!-- wp:image {\"align\":\"center\",\"id\":165,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/icon1.png\" alt=\"\" class=\"wp-image-165\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"style\":{\"typography\":{\"fontSize\":25},\"color\":{\"text\":\"#2f3241\"}}} -->\n<h4 class=\"has-text-align-center has-text-color\" style=\"color:#2f3241;font-size:25px\"><strong>FACILITIES TITLE 1</strong></h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#71737c\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#71737c;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"text-center mb-md-0 mb-4\"} -->\n<div class=\"wp-block-column text-center mb-md-0 mb-4\"><!-- wp:image {\"align\":\"center\",\"id\":166,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/icon2.png\" alt=\"\" class=\"wp-image-166\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"style\":{\"typography\":{\"fontSize\":25},\"color\":{\"text\":\"#2f3241\"}}} -->\n<h4 class=\"has-text-align-center has-text-color\" style=\"color:#2f3241;font-size:25px\"><strong>FACILITIES TITLE 2</strong></h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#71737c\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#71737c;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"text-center mb-md-0 mb-4\"} -->\n<div class=\"wp-block-column text-center mb-md-0 mb-4\"><!-- wp:image {\"align\":\"center\",\"id\":167,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"" . esc_url(get_template_directory_uri()) . "/inc/block-patterns/images/icon3.png\" alt=\"\" class=\"wp-image-167\"/></figure></div>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"style\":{\"typography\":{\"fontSize\":25},\"color\":{\"text\":\"#2f3241\"}}} -->\n<h4 class=\"has-text-align-center has-text-color\" style=\"color:#2f3241;font-size:25px\"><strong>FACILITIES TITLE 3</strong></h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#71737c\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#71737c;font-size:14px\">Lorem Ipsum&nbsp;is simply dummy text of the printing</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->",
		)
	);
}