<?php
/**
 * The template part for displaying Content
 *
 * @package VW Lawyer Attorney 
 * @subpackage vw_lawyer_attorney
 * @since VW Lawyer Attorney 1.0
 */
?>
<?php 
  $vw_lawyer_attorney_archive_year  = get_the_time('Y'); 
  $vw_lawyer_attorney_archive_month = get_the_time('m'); 
  $vw_lawyer_attorney_archive_day   = get_the_time('d'); 
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
  <div class="postbox smallpostimage wow zoomInUp delay-1000" data-wow-duration="2s"> 
    <?php $vw_lawyer_attorney_theme_lay = get_theme_mod( 'vw_lawyer_attorney_blog_layout_option','Default');
    if($vw_lawyer_attorney_theme_lay == 'Default'){ ?>
      <div class="row">
        <?php if(has_post_thumbnail() && get_theme_mod( 'vw_lawyer_attorney_featured_image_hide_show',true) == 1) {?>
          <div class="col-lg-6 col-md-6">
            <div class="service-image">
              <?php the_post_thumbnail(); ?>
            </div>
          </div>
        <?php } ?>
        <div class="new-text <?php if(has_post_thumbnail() && get_theme_mod( 'vw_lawyer_attorney_featured_image_hide_show',true) == 1) { ?>col-lg-6 col-md-6"<?php } else { ?>col-lg-12 col-md-12" <?php } ?>>
            <div class="box-content">
              <h2 class="section-title"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
              <?php if( get_theme_mod( 'vw_lawyer_attorney_toggle_postdate',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_author',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_comments',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_time',true) == 1) { ?>
                <div class="metabox">
                  <?php if(get_theme_mod('vw_lawyer_attorney_toggle_postdate',true)==1){ ?>
                    <span class="entry-date"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_postdate_icon','fas fa-calendar-alt')); ?>"></i><a href="<?php echo esc_url( get_day_link( $vw_lawyer_attorney_archive_year, $vw_lawyer_attorney_archive_month, $vw_lawyer_attorney_archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
                  <?php } ?>

                  <?php if(get_theme_mod('vw_lawyer_attorney_toggle_author',true)==1){ ?>
                    <span class="entry-author"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_author_icon','fas fa-user')); ?>"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
                  <?php } ?>

                  <?php if(get_theme_mod('vw_lawyer_attorney_toggle_comments',true)==1){ ?>
                    <span class="entry-comments"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_comments_icon','fas fa-comments')); ?>"></i><?php comments_number( __('0 Comments','vw-lawyer-attorney'), __('0 Comments','vw-lawyer-attorney'), __('% Comments','vw-lawyer-attorney')); ?></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
                  <?php } ?>

                  <?php if(get_theme_mod('vw_lawyer_attorney_toggle_time',true)==1){ ?>
                    <span class="entry-time"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_time_icon','fas fa-clock')); ?>"></i><?php echo esc_html( get_the_time() ); ?></span>
                  <?php } ?>
                  <?php echo esc_html (vw_lawyer_attorney_edit_link()); ?>
                </div>
              <?php } ?>
              <hr class="big">
              <hr class="small">
              <div class="entry-content">
                <p>
                  <?php $vw_lawyer_attorney_theme_lay = get_theme_mod( 'vw_lawyer_attorney_excerpt_settings','Excerpt');
                  if($vw_lawyer_attorney_theme_lay == 'Content'){ ?>
                    <?php the_content(); ?>
                  <?php }
                  if($vw_lawyer_attorney_theme_lay == 'Excerpt'){ ?>
                    <?php if(get_the_excerpt()) { ?>
                      <p><?php $vw_lawyer_attorney_excerpt = get_the_excerpt(); echo esc_html( vw_lawyer_attorney_string_limit_words( $vw_lawyer_attorney_excerpt, esc_attr(get_theme_mod('vw_lawyer_attorney_excerpt_number','30')))); ?> <?php echo esc_html(get_theme_mod('vw_lawyer_attorney_excerpt_suffix',''));?></p>
                    <?php }?>
                  <?php }?>
                </p>
              </div>
              <?php if( get_theme_mod('vw_lawyer_attorney_button_text','Read Full') != ''){ ?>
                <div class ="testbutton">
                  <a href="<?php echo esc_url( get_permalink() );?>" class="hvr-sweep-to-right"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_button_text',__('Read Full','vw-lawyer-attorney')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_button_text',__('Read Full','vw-lawyer-attorney')));?></span></a>
                </div>
              <?php } ?>
            </div>
        </div>
      </div>
    <?php }else if($vw_lawyer_attorney_theme_lay == 'Center'){ ?>
      <div class="new-text">
        <div class="box-content">
          <h2 class="section-title"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
          <?php if( get_theme_mod( 'vw_lawyer_attorney_featured_image_hide_show',true) == 1) { ?>
            <div class="box-image">
              <?php the_post_thumbnail(); ?>
            </div>
          <?php } ?>
          <?php if( get_theme_mod( 'vw_lawyer_attorney_toggle_postdate',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_author',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_comments',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_time',true) == 1) { ?>
            <div class="metabox">
              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_postdate',true)==1){ ?>
                <span class="entry-date"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_postdate_icon','fas fa-calendar-alt')); ?>"></i><a href="<?php echo esc_url( get_day_link( $vw_lawyer_attorney_archive_year, $vw_lawyer_attorney_archive_month, $vw_lawyer_attorney_archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
              <?php } ?>

              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_author',true)==1){ ?>
                <span class="entry-author"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_author_icon','fas fa-user')); ?>"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
              <?php } ?>

              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_comments',true)==1){ ?>
                <span class="entry-comments"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_comments_icon','fas fa-comments')); ?>"></i><?php comments_number( __('0 Comments','vw-lawyer-attorney'), __('0 Comments','vw-lawyer-attorney'), __('% Comments','vw-lawyer-attorney')); ?></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
              <?php } ?>

              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_time',true)==1){ ?>
                <span class="entry-time"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_time_icon','fas fa-clock')); ?>"></i><?php echo esc_html( get_the_time() ); ?></span>
              <?php } ?>

              <?php echo esc_html (vw_lawyer_attorney_edit_link()); ?>
            </div>
          <?php } ?>
          <hr class="big">
          <hr class="small">
          <div class="entry-content">
            <p>
              <?php $vw_lawyer_attorney_theme_lay = get_theme_mod( 'vw_lawyer_attorney_excerpt_settings','Excerpt');
              if($vw_lawyer_attorney_theme_lay == 'Content'){ ?>
                <?php the_content(); ?>
              <?php }
              if($vw_lawyer_attorney_theme_lay == 'Excerpt'){ ?>
                <?php if(get_the_excerpt()) { ?>
                  <p><?php $vw_lawyer_attorney_excerpt = get_the_excerpt(); echo esc_html( vw_lawyer_attorney_string_limit_words( $vw_lawyer_attorney_excerpt, esc_attr(get_theme_mod('vw_lawyer_attorney_excerpt_number','30')))); ?> <?php echo esc_html(get_theme_mod('vw_lawyer_attorney_excerpt_suffix',''));?></p>
                <?php }?>
              <?php }?>
            </p>
          </div>
          <?php if( get_theme_mod('vw_lawyer_attorney_button_text','Read Full') != ''){ ?>
            <div class ="testbutton">
              <a href="<?php echo esc_url( get_permalink() );?>" class="hvr-sweep-to-right"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_button_text',__('Read Full','vw-lawyer-attorney')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_button_text',__('Read Full','vw-lawyer-attorney')));?></span></a>
            </div>
          <?php } ?>
        </div>
      </div>
    <?php }else if($vw_lawyer_attorney_theme_lay == 'Left'){ ?>
      <div class="new-text">
        <div class="box-content">
          <?php if( get_theme_mod( 'vw_lawyer_attorney_featured_image_hide_show',true) == 1) { ?>
            <div class="box-image">
              <?php the_post_thumbnail(); ?>
            </div>
          <?php } ?>
          <h2 class="section-title"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
          <?php if( get_theme_mod( 'vw_lawyer_attorney_toggle_postdate',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_author',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_comments',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_time',true) == 1) { ?>
            <div class="metabox">
              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_postdate',true)==1){ ?>
                <span class="entry-date"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_postdate_icon','fas fa-calendar-alt')); ?>"></i><a href="<?php echo esc_url( get_day_link( $vw_lawyer_attorney_archive_year, $vw_lawyer_attorney_archive_month, $vw_lawyer_attorney_archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
              <?php } ?>

              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_author',true)==1){ ?>
                <span class="entry-author"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_author_icon','fas fa-user')); ?>"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
              <?php } ?>

              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_comments',true)==1){ ?>
                <span class="entry-comments"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_comments_icon','fas fa-comments')); ?>"></i><?php comments_number( __('0 Comments','vw-lawyer-attorney'), __('0 Comments','vw-lawyer-attorney'), __('% Comments','vw-lawyer-attorney')); ?></span><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span>
              <?php } ?>

              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_time',true)==1){ ?>
                <span class="entry-time"><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_toggle_time_icon','fas fa-clock')); ?>"></i><?php echo esc_html( get_the_time() ); ?></span>
              <?php } ?>

              <?php echo esc_html (vw_lawyer_attorney_edit_link()); ?>
            </div>
          <?php } ?>
          <hr class="big">
          <hr class="small">
          <div class="entry-content">
            <p>
              <?php $vw_lawyer_attorney_theme_lay = get_theme_mod( 'vw_lawyer_attorney_excerpt_settings','Excerpt');
              if($vw_lawyer_attorney_theme_lay == 'Content'){ ?>
                <?php the_content(); ?>
              <?php }
              if($vw_lawyer_attorney_theme_lay == 'Excerpt'){ ?>
                <?php if(get_the_excerpt()) { ?>
                  <p><?php $vw_lawyer_attorney_excerpt = get_the_excerpt(); echo esc_html( vw_lawyer_attorney_string_limit_words( $vw_lawyer_attorney_excerpt, esc_attr(get_theme_mod('vw_lawyer_attorney_excerpt_number','30')))); ?> <?php echo esc_html(get_theme_mod('vw_lawyer_attorney_excerpt_suffix',''));?></p>
                <?php }?>
              <?php }?>
            </p>
          </div>
          <?php if( get_theme_mod('vw_lawyer_attorney_button_text','Read Full') != ''){ ?>
            <div class ="testbutton">
              <a href="<?php echo esc_url( get_permalink() );?>" class="hvr-sweep-to-right"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_button_text',__('Read Full','vw-lawyer-attorney')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_button_text',__('Read Full','vw-lawyer-attorney')));?></span></a>
            </div>
          <?php } ?>
        </div>
      </div>
    <?php } ?>
    <div class="clearfix"></div> 
  </div>
</article>