<?php
/**
 * The template part for displaying Audio Post
 *
 * @package VW Lawyer Attorney 
 * @subpackage vw_lawyer_attorney
 * @since VW Lawyer Attorney 1.0
 */
?>
<?php 
  $vw_lawyer_attorney_archive_year  = get_the_time('Y'); 
  $vw_lawyer_attorney_archive_month = get_the_time('m'); 
  $vw_lawyer_attorney_archive_day   = get_the_time('d'); 
?>
<?php
	$content = apply_filters( 'the_content', get_the_content() );
	$audio = false;

	// Only get audio from the content if a playlist isn't present.
	if ( false === strpos( $content, 'wp-playlist-script' ) ) {
		$audio = get_media_embedded_in_content( $content, array( 'audio' ) );
	}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('inner-service'); ?>>
  <div class="postbox smallpostimage wow zoomInUp delay-1000" data-wow-duration="2s"> 		
    <?php
			if ( ! is_single() ) {
				// If not a single post, highlight the audio file.
				if ( ! empty( $audio ) ) {
					foreach ( $audio as $audio_html ) {
						echo '<div class="entry-audio">';
							echo $audio_html;
						echo '</div><!-- .entry-audio -->';
					}
				};
			};
		?>
    <div class="new-text">
      <div class="box-content">
        	<h2 class="section-title"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2> 
          <?php if( get_theme_mod( 'vw_lawyer_attorney_toggle_postdate',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_author',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_comments',true) == 1 || get_theme_mod( 'vw_lawyer_attorney_toggle_time',true) == 1) { ?>
           	<div class="metabox">
            	<?php if(get_theme_mod('vw_lawyer_attorney_toggle_postdate',true)==1){ ?>
                <span class="entry-date"><i class="fas fa-calendar-alt"></i><a href="<?php echo esc_url( get_day_link( $vw_lawyer_attorney_archive_year, $vw_lawyer_attorney_archive_month, $vw_lawyer_attorney_archive_day)); ?>"><?php echo esc_html( get_the_date() ); ?><span class="screen-reader-text"><?php echo esc_html( get_the_date() ); ?></span></a></span>
              <?php } ?>
              
              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_author',true)==1){ ?>
                <span class="entry-author"><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span><i class="fas fa-user"></i><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' )) ); ?>"><?php the_author(); ?><span class="screen-reader-text"><?php the_author(); ?></span></a></span>
              <?php } ?>

              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_comments',true)==1){ ?>
                <span class="entry-comments"><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span><i class="fas fa-comments"></i><?php comments_number( __('0 Comments','vw-lawyer-attorney'), __('0 Comments','vw-lawyer-attorney'), __('% Comments','vw-lawyer-attorney')); ?></span>
              <?php } ?>

              <?php if(get_theme_mod('vw_lawyer_attorney_toggle_time',true)==1){ ?>
                <span class="entry-time"><span><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_meta_field_separator'));?></span><i class="fas fa-clock"></i><?php echo esc_html( get_the_time() ); ?></span>
              <?php } ?>
           	</div>
          <?php } ?>
        	<hr class="big">
       	  <hr class="small">
        	<div class="entry-content">
            <p>
              <?php $vw_lawyer_attorney_theme_lay = get_theme_mod( 'vw_lawyer_attorney_excerpt_settings','Excerpt');
              if($vw_lawyer_attorney_theme_lay == 'Content'){ ?>
                <?php the_content(); ?>
              <?php }
              if($vw_lawyer_attorney_theme_lay == 'Excerpt'){ ?>
                <?php if(get_the_excerpt()) { ?>
                  <p><?php $vw_lawyer_attorney_excerpt = get_the_excerpt(); echo esc_html( vw_lawyer_attorney_string_limit_words( $vw_lawyer_attorney_excerpt, esc_attr(get_theme_mod('vw_lawyer_attorney_excerpt_number','30')))); ?>  <?php echo esc_html(get_theme_mod('vw_lawyer_attorney_excerpt_suffix',''));?></p>
                <?php }?>
              <?php }?>
            </p>
          </div>
          <?php if( get_theme_mod('vw_lawyer_attorney_button_text','Read Full') != ''){ ?>
         	  <div class ="testbutton">
              <a href="<?php echo esc_url( get_permalink() );?>" class="hvr-sweep-to-right"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_button_text',__('Read Full','vw-lawyer-attorney')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_button_text',__('Read Full','vw-lawyer-attorney')));?></span></a>
            </div>
          <?php } ?>
   	  </div>
    </div>  	
  	<div class="clearfix"></div> 
	</div>
</article>