<?php
/**
 * Template Name: Custom Home
 */
get_header(); ?>

<main id="maincontent" role="main">
	<?php do_action( 'vw_lawyer_attorney_above_slider' ); ?>

	<?php if( get_theme_mod( 'vw_lawyer_attorney_slider_hide_show', true) == 1 || get_theme_mod( 'vw_lawyer_attorney_resp_slider_hide_show', true) == 1) { ?>
	  	<section class="slider">
	  		<?php if(get_theme_mod('vw_lawyer_attorney_slider_type', 'Default slider') == 'Default slider' ){ ?>
		    <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel" data-bs-interval="<?php echo esc_attr(get_theme_mod( 'vw_lawyer_attorney_slider_speed',4000)) ?>"> 
		      <?php $vw_lawyer_attorney_slider_pages = array();
		        for ( $count = 1; $count <= 3; $count++ ) {
		          $mod = intval( get_theme_mod( 'vw_lawyer_attorney_slider_page' . $count ));
		          if ( 'page-none-selected' != $mod ) {
		            $vw_lawyer_attorney_slider_pages[] = $mod;
		          }
		        }
		        if( !empty($vw_lawyer_attorney_slider_pages) ) :
		          $args = array(
		            'post_type' => 'page',
		            'post__in' => $vw_lawyer_attorney_slider_pages,
		            'orderby' => 'post__in'
		          );
		          $query = new WP_Query( $args );
		          if ( $query->have_posts() ) :
		            $i = 1;
		      ?>     
		      <div class="carousel-inner" role="listbox">
		        <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
		          <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>
		            <?php if(has_post_thumbnail()){
                  the_post_thumbnail();
                } else{?>
                  <img src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/block-patterns/images/slider.png" alt="" />
                <?php } ?>
		            <div class="carousel-caption">
		              <div class="inner_carousel">
		                <h1 class="wow slideInRight" data-wow-duration="2s"><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
		                <p class="wow slideInRight" data-wow-duration="2s"><?php $vw_lawyer_attorney_excerpt = get_the_excerpt(); echo esc_html( vw_lawyer_attorney_string_limit_words( $vw_lawyer_attorney_excerpt, esc_attr(get_theme_mod('vw_lawyer_attorney_slider_excerpt_number','30')))); ?></p>		                

				        		<?php
	                    $vw_lawyer_attorney_button_text = get_theme_mod('vw_lawyer_attorney_slider_button_text', 'KNOW MORE');
	                    $vw_lawyer_attorney_button_link = get_theme_mod('vw_lawyer_attorney_slider_button_link_text2', '');
	                    if (empty($vw_lawyer_attorney_button_link)) {
	                      $vw_lawyer_attorney_button_link = get_permalink();
	                    }
	                    if ($vw_lawyer_attorney_button_text || !empty($vw_lawyer_attorney_button_link)) { ?>
	                      <div class="testbutton wow slideInRight" data-wow-duration="2s">
	                        <?php if( get_theme_mod('vw_lawyer_attorney_slider_button_text') != ''){ ?>
	                          <a class="hvr-sweep-to-right" href="<?php echo esc_url($vw_lawyer_attorney_button_link); ?>" class="button redmor">
	                          <?php echo esc_html($vw_lawyer_attorney_button_text); ?>
	                            <span class="screen-reader-text"><?php echo esc_html($vw_lawyer_attorney_button_text); ?></span>
	                          </a>
	                        <?php } ?>
	                      </div>
	                  <?php } ?>
		              </div>
		            </div>
		          </div>
		        <?php $i++; endwhile; 
		        wp_reset_postdata();?>
		      </div>
		      <?php else : ?>
		          <div class="no-postfound"></div>
		        <?php endif;
		      endif;?>
		      <?php if(get_theme_mod('vw_lawyer_attorney_slider_arrow_hide_show', true)){?>
	      		<a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
              <span class="carousel-control-prev-icon w-auto h-auto" aria-hidden="true"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_slider_prev_icon','fas fa-angle-left')); ?>"></i></span>
              <span class="screen-reader-text"><?php esc_html_e( 'Previous','vw-lawyer-attorney' );?></span>
            </a>
            <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
              <span class="carousel-control-next-icon w-auto h-auto" aria-hidden="true"><i class="<?php echo esc_attr(get_theme_mod('vw_lawyer_attorney_slider_next_icon','fas fa-angle-right')); ?>"></i></span>
              <span class="screen-reader-text"><?php esc_html_e( 'Next','vw-lawyer-attorney' );?></span>
            </a>
          <?php }?>
		    </div>  
	    	<div class="clearfix"></div>
	    	  <?php } else if(get_theme_mod('vw_lawyer_attorney_slider_type', 'Advance slider') == 'Advance slider'){?>
	          <?php echo do_shortcode(get_theme_mod('vw_lawyer_attorney_advance_slider_shortcode')); ?>
	        <?php } ?>
	  	</section> 
	<?php }?>

	<?php do_action( 'vw_lawyer_attorney_below_slider' ); ?>

	<?php if( get_theme_mod( 'vw_lawyer_attorney_about_setting') != '' || get_theme_mod( 'vw_lawyer_attorney_main_title' )!= '' || get_theme_mod( 'vw_lawyer_attorney_blogcategory_setting' )!= '' || get_theme_mod( 'vw_lawyer_attorney_about_name' )!= ''){ ?>
		<div class="container wow bounceInUp delay-1000" data-wow-duration="3s">
			<div class="row m-0">
				<div class="about col-lg-6 col-md-6">
				    <?php
				    $vw_lawyer_attorney_postData1=  get_theme_mod('vw_lawyer_attorney_about_setting');
		        	if($vw_lawyer_attorney_postData1){
				      $args = array( 'p' => esc_html($vw_lawyer_attorney_postData1 ,'vw-lawyer-attorney'),
				      'post_type' => 'post',	
				    	);
				      $query = new WP_Query( $args );
				      if ( $query->have_posts() ) :
				        while ( $query->have_posts() ) : $query->the_post(); ?>
				        	<span class="about-small-text mb-3"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_about_small_text'))?></span>
				            <h2 class="pt-3"><?php the_title(); ?></h2>
				            <p><?php $vw_lawyer_attorney_excerpt = get_the_excerpt(); echo esc_html( vw_lawyer_attorney_string_limit_words( $vw_lawyer_attorney_excerpt, esc_attr(get_theme_mod('vw_lawyer_attorney_about_excerpt_number','30')))); ?></p>
				            <?php if( get_theme_mod('vw_lawyer_attorney_about_name','Discover More About Us') != ''){ ?>
					            <div class ="testbutton">
					              <a class="hvr-sweep-to-right" href="<?php the_permalink(); ?>"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_about_name',__('Discover More About Us','vw-lawyer-attorney')));?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_about_name',__('Discover More About Us','vw-lawyer-attorney')));?></span></a>
					            </div>
				            <?php } ?>
				        <?php endwhile; 
				        wp_reset_postdata();?>
				        <?php else : ?>
				           <div class="no-postfound"></div>
				        <?php
				    endif; }?>
				</div>
				<div id="" class="col-lg-6 col-md-6 choose" >
					<?php if( get_theme_mod('vw_lawyer_attorney_main_title') != ''){ ?>
					    <div class="heading-line">
				      		<h3><?php echo esc_html(get_theme_mod('vw_lawyer_attorney_main_title','')); ?> </h3>
					    </div>
				    <?php } ?>
					<?php 
						$vw_lawyer_attorney_catData1=  get_theme_mod('vw_lawyer_attorney_blogcategory_setting');
			            if($vw_lawyer_attorney_catData1){ 
					    $page_query = new WP_Query(array( 'category_name' => esc_html($vw_lawyer_attorney_catData1 ,'vw-lawyer-attorney')));?>
				  		<?php while( $page_query->have_posts() ) : $page_query->the_post(); ?>
				  			<div class="why-box">
					  			<div class="row m-0">
							    	<div class="col-lg-3 col-md-3">
							    		<div class="abt-img-box"><?php if(has_post_thumbnail()) { ?><?php the_post_thumbnail(); ?><?php } ?></div>
							    	</div>
							    	<div class="col-lg-9 col-md-9">
							    		<h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></h4><span class="screen-reader-text"><?php the_title(); ?></span></a>
							    		<p><?php $vw_lawyer_attorney_excerpt = get_the_excerpt(); echo esc_html( vw_lawyer_attorney_string_limit_words( $vw_lawyer_attorney_excerpt, esc_attr(get_theme_mod('vw_lawyer_attorney_choose_excerpt_number','30')))); ?></p>
							    	</div>
							    </div>
							</div>
					    	<div class="clearfix"></div>
					    <?php endwhile;
					    wp_reset_postdata();
					}?>
				</div>
			</div>
		</div>
	<?php }?>

	<?php do_action( 'vw_lawyer_attorney_below_about' ); ?>

	<div class="content-vw">
		<div class="container">
		    <?php while ( have_posts() ) : the_post(); ?>
		        <?php the_content(); ?>
		    <?php endwhile; // end of the loop. ?>
		</div>
	</div>	
</main>

<?php get_footer(); ?>